function varargout = Liaisons_fixes_BilanLiaison_Dispo(varargin)
% Liaisons_fixes MATLAB code for Liaisons_fixes.fig
%      Liste des programmes :
%           - Premire interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilit
%           - Temprature et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des rseaux cellulaires
%           - Dbit maximal 
%
%      Liaisons_fixes, by itself, creates a new Liaisons_fixes_BilanLiaison_Dispo or raises the existing
%      singleton*.
%
%      H = Liaisons_fixes returns the handle to a new Liaisons_fixes_BilanLiaison_Dispo or the handle to
%      the existing singleton*.
%
%      Liaisons_fixes_BilanLiaison_Dispo('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Liaisons_fixes.M with the given input arguments.
%
%      Liaisons_fixes_BilanLiaison_Dispo('Property','Value',...) creates a new Liaisons_fixes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Liaisons_fixes_BilanLiaison_Dispo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Liaisons_fixes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Liaisons_fixes_BilanLiaison_Dispo
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 24-Feb-2019 18:11:24

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Liaisons_fixes_BilanLiaison_Dispo_OpeningFcn, ...
                   'gui_OutputFcn',  @Liaisons_fixes_BilanLiaison_Dispo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Liaisons_fixes_BilanLiaison_Dispo is made visible.
function Liaisons_fixes_BilanLiaison_Dispo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Liaisons_fixes_BilanLiaison_Dispo (see VARARGIN)

% Choose default command line output for Liaisons_fixes_BilanLiaison_Dispo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);




% UIWAIT makes Liaisons_fixes_BilanLiaison_Dispo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Liaisons_fixes_BilanLiaison_Dispo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function PTX_Callback(hObject, eventdata, handles)
% hObject    handle to PTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PTX as text
%        str2double(get(hObject,'String')) returns contents of PTX as a double


% --- Executes during object creation, after setting all properties.
function PTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in UnitePuissanceTX.
function UnitePuissanceTX_Callback(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch get(handles.UnitePuissanceTX,'Value')   
	case 2
        Unite_P_TX = 1; % Unit de la puissance de transmission en dBm
	case 3
        Unite_P_TX = 2; % Unit de la puissance de transmission en W
    otherwise
        errordlg('Choisissez l''unit de PTX','File Error');
end
set(handles.UnitePuissanceTX, 'UserData', Unite_P_TX);

% Hints: contents = cellstr(get(hObject,'String')) returns UnitePuissanceTX contents as cell array
%        contents{get(hObject,'Value')} returns selected item from UnitePuissanceTX


% --- Executes during object creation, after setting all properties.
function UnitePuissanceTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function distance_Callback(hObject, eventdata, handles)
% hObject    handle to distance (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of distance as text
%        str2double(get(hObject,'String')) returns contents of distance as a double


% --- Executes during object creation, after setting all properties.
function distance_CreateFcn(hObject, eventdata, handles)
% hObject    handle to distance (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function FM_Input_Callback(hObject, eventdata, handles)
% hObject    handle to FM_Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FM_Input as text
%        str2double(get(hObject,'String')) returns contents of FM_Input as a double


% --- Executes during object creation, after setting all properties.
function FM_Input_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FM_Input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function hTX_Callback(hObject, eventdata, handles)
% hObject    handle to hTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hTX as text
%        str2double(get(hObject,'String')) returns contents of hTX as a double


% --- Executes during object creation, after setting all properties.
function hTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function hRX_Callback(hObject, eventdata, handles)
% hObject    handle to hRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hRX as text
%        str2double(get(hObject,'String')) returns contents of hRX as a double


% --- Executes during object creation, after setting all properties.
function hRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BP_Callback(hObject, eventdata, handles)
% hObject    handle to BP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BP as text
%        str2double(get(hObject,'String')) returns contents of BP as a double


% --- Executes during object creation, after setting all properties.
function BP_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function SNSeuil_Callback(hObject, eventdata, handles)
% hObject    handle to SNSeuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNSeuil as text
%        str2double(get(hObject,'String')) returns contents of SNSeuil as a double


% --- Executes during object creation, after setting all properties.
function SNSeuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNSeuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PuissanceRXdBm_Callback(hObject, eventdata, handles)
% hObject    handle to PuissanceRXdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PuissanceRXdBm as text
%        str2double(get(hObject,'String')) returns contents of PuissanceRXdBm as a double


% --- Executes during object creation, after setting all properties.
function PuissanceRXdBm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PuissanceRXdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PuissanceRXW_Callback(hObject, eventdata, handles)
% hObject    handle to PuissanceRXW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PuissanceRXW as text
%        str2double(get(hObject,'String')) returns contents of PuissanceRXW as a double


% --- Executes during object creation, after setting all properties.
function PuissanceRXW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PuissanceRXW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function GM_Callback(hObject, eventdata, handles)
% hObject    handle to GM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GM as text
%        str2double(get(hObject,'String')) returns contents of GM as a double


% --- Executes during object creation, after setting all properties.
function GM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function FM_Callback(hObject, eventdata, handles)
% hObject    handle to FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FM as text
%        str2double(get(hObject,'String')) returns contents of FM as a double


% --- Executes during object creation, after setting all properties.
function FM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PRXmindBm_Callback(hObject, eventdata, handles)
% hObject    handle to PRXmindBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PRXmindBm as text
%        str2double(get(hObject,'String')) returns contents of PRXmindBm as a double


% --- Executes during object creation, after setting all properties.
function PRXmindBm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PRXmindBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PRXminW_Callback(hObject, eventdata, handles)
% hObject    handle to PRXminW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PRXminW as text
%        str2double(get(hObject,'String')) returns contents of PRXminW as a double


% --- Executes during object creation, after setting all properties.
function PRXminW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PRXminW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PbruitdBm_Callback(hObject, eventdata, handles)
% hObject    handle to PbruitdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PbruitdBm as text
%        str2double(get(hObject,'String')) returns contents of PbruitdBm as a double


% --- Executes during object creation, after setting all properties.
function PbruitdBm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PbruitdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PbruitW_Callback(hObject, eventdata, handles)
% hObject    handle to PbruitW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PbruitW as text
%        str2double(get(hObject,'String')) returns contents of PbruitW as a double


% --- Executes during object creation, after setting all properties.
function PbruitW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PbruitW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SN_Callback(hObject, eventdata, handles)
% hObject    handle to SN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SN as text
%        str2double(get(hObject,'String')) returns contents of SN as a double


% --- Executes during object creation, after setting all properties.
function SN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function Acceptable_SN_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Acceptable_SN_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function freq_Callback(hObject, eventdata, handles)
% hObject    handle to freq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of freq as text
%        str2double(get(hObject,'String')) returns contents of freq as a double


% --- Executes during object creation, after setting all properties.
function freq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to freq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on selection change in ChoixEspace.
function ChoixEspace_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixEspace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch get(handles.ChoixEspace,'Value')   
	case 2
        Espace = 1; % Espace libre slectionn

	case 3
        Espace = 2; % Milieu urbain slectionn

    otherwise
        errordlg('Choisissez le milieu de propagation','File Error');
end
set(handles.ChoixEspace, 'UserData', Espace);

% Hints: contents = cellstr(get(hObject,'String')) returns ChoixEspace contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ChoixEspace


% --- Executes during object creation, after setting all properties.
function ChoixEspace_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChoixEspace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function GTX_Callback(hObject, eventdata, handles)
% hObject    handle to GTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GTX as text
%        str2double(get(hObject,'String')) returns contents of GTX as a double


% --- Executes during object creation, after setting all properties.
function GTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function GRX_Callback(hObject, eventdata, handles)
% hObject    handle to GRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GRX as text
%        str2double(get(hObject,'String')) returns contents of GRX as a double


% --- Executes during object creation, after setting all properties.
function GRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Accept_PRX_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_PRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_PRX as text
%        str2double(get(hObject,'String')) returns contents of Accept_PRX as a double


% --- Executes during object creation, after setting all properties.
function Accept_PRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_PRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_FM_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_FM as text
%        str2double(get(hObject,'String')) returns contents of Accept_FM as a double


% --- Executes during object creation, after setting all properties.
function Accept_FM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Lp_Callback(hObject, eventdata, handles)
% hObject    handle to Lp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Lp as text
%        str2double(get(hObject,'String')) returns contents of Lp as a double


% --- Executes during object creation, after setting all properties.
function Lp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Lp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function LCTX_Callback(hObject, eventdata, handles)
% hObject    handle to LCTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LCTX as text
%        str2double(get(hObject,'String')) returns contents of LCTX as a double


% --- Executes during object creation, after setting all properties.
function LCTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LCTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function LCRX_Callback(hObject, eventdata, handles)
% hObject    handle to LCRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LCRX as text
%        str2double(get(hObject,'String')) returns contents of LCRX as a double


% --- Executes during object creation, after setting all properties.
function LCRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LCRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function La_Callback(hObject, eventdata, handles)
% hObject    handle to La (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of La as text
%        str2double(get(hObject,'String')) returns contents of La as a double


% --- Executes during object creation, after setting all properties.
function La_CreateFcn(hObject, eventdata, handles)
% hObject    handle to La (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Accept_SN_Seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_SN_Seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_SN_Seuil as text
%        str2double(get(hObject,'String')) returns contents of Accept_SN_Seuil as a double


% --- Executes during object creation, after setting all properties.
function Accept_SN_Seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_SN_Seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function PXRMin_Callback(hObject, eventdata, handles)
% hObject    handle to PXRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PXRMin as text
%        str2double(get(hObject,'String')) returns contents of PXRMin as a double


% --- Executes during object creation, after setting all properties.
function PXRMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PXRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function distance_s_TX1_TX2_Callback(hObject, eventdata, handles)
% hObject    handle to distance_s_TX1_TX2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of distance_s_TX1_TX2 as text
%        str2double(get(hObject,'String')) returns contents of distance_s_TX1_TX2 as a double


% --- Executes during object creation, after setting all properties.
function distance_s_TX1_TX2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to distance_s_TX1_TX2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Ond_Callback(hObject, eventdata, handles)
% hObject    handle to Ond (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ond as text
%        str2double(get(hObject,'String')) returns contents of Ond as a double


% --- Executes during object creation, after setting all properties.
function Ond_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ond (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Ofd_Callback(hObject, eventdata, handles)
% hObject    handle to Ofd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ofd as text
%        str2double(get(hObject,'String')) returns contents of Ofd as a double


% --- Executes during object creation, after setting all properties.
function Ofd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ofd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Osd_Callback(hObject, eventdata, handles)
% hObject    handle to Osd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Osd as text
%        str2double(get(hObject,'String')) returns contents of Osd as a double


% --- Executes during object creation, after setting all properties.
function Osd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Osd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Isd_Callback(hObject, eventdata, handles)
% hObject    handle to Isd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Isd as text
%        str2double(get(hObject,'String')) returns contents of Isd as a double


% --- Executes during object creation, after setting all properties.
function Isd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Isd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Ifd_Callback(hObject, eventdata, handles)
% hObject    handle to Ifd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ifd as text
%        str2double(get(hObject,'String')) returns contents of Ifd as a double


% --- Executes during object creation, after setting all properties.
function Ifd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ifd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Ond_pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Ond_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ond_pourcent as text
%        str2double(get(hObject,'String')) returns contents of Ond_pourcent as a double


% --- Executes during object creation, after setting all properties.
function Ond_pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ond_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Ofd_pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Ofd_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ofd_pourcent as text
%        str2double(get(hObject,'String')) returns contents of Ofd_pourcent as a double


% --- Executes during object creation, after setting all properties.
function Ofd_pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ofd_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Osd_pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Osd_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Osd_pourcent as text
%        str2double(get(hObject,'String')) returns contents of Osd_pourcent as a double


% --- Executes during object creation, after setting all properties.
function Osd_pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Osd_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function cteV_Callback(hObject, eventdata, handles)
% hObject    handle to cteV (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of cteV as text
%        str2double(get(hObject,'String')) returns contents of cteV as a double


% --- Executes during object creation, after setting all properties.
function cteV_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cteV (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function FreqC1_Callback(hObject, eventdata, handles)
% hObject    handle to FreqC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FreqC1 as text
%        str2double(get(hObject,'String')) returns contents of FreqC1 as a double


% --- Executes during object creation, after setting all properties.
function FreqC1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FreqC1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function FreqC2_Callback(hObject, eventdata, handles)
% hObject    handle to FreqC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FreqC2 as text
%        str2double(get(hObject,'String')) returns contents of FreqC2 as a double


% --- Executes during object creation, after setting all properties.
function FreqC2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FreqC2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ChoixTypeClimat.
function ChoixTypeClimat_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixTypeClimat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch get(handles.ChoixTypeClimat,'Value')   
	case 2
        B = 1/2; % Climat chaud ou humide slectionn

	case 3
        B = 1/4; % Climat tempr slectionn

    case 4
        B = 1/8; % Climat froid, en montagne ou sec slectionn

    otherwise
        errordlg('Choisissez le type de climat','File Error');
end
set(handles.ChoixTypeClimat, 'UserData', B);


% Hints: contents = cellstr(get(hObject,'String')) returns ChoixTypeClimat contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ChoixTypeClimat


% --- Executes during object creation, after setting all properties.
function ChoixTypeClimat_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChoixTypeClimat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ChoixTypeTerrain.
function ChoixTypeTerrain_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixTypeTerrain (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch get(handles.ChoixTypeTerrain,'Value')   
	case 2
        C = 4; % Terrain prs des lacs ou rgions ctires slectionn

	case 3
        C = 1; % Terrain moyennement accident slectionn

    case 4
        C = 1/4; % Terrain montagneux slectionn

    otherwise
        errordlg('Choisissez le type de terrain','File Error');
end
set(handles.ChoixTypeTerrain, 'UserData', C);


% Hints: contents = cellstr(get(hObject,'String')) returns ChoixTypeTerrain contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ChoixTypeTerrain


% --- Executes during object creation, after setting all properties.
function ChoixTypeTerrain_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChoixTypeTerrain (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ChoixConstanteA.
function ChoixConstanteA_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixConstanteA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch get(handles.ChoixConstanteA,'Value')   
	case 2
        A = 3; % Bande de frquence : 0.89 - 0.96 GHz slectionn

	case 3
        A = 1; % Bande de frquence : 2 GHz

    case 4
        A = 1/2; % Bande de frquence : 4 GHz
        
	case 5
        A = 1/4; % Bande de frquence : 6 GHz slectionn

	case 6
        A = 1/8; % Bande de frquence : 7 - 8 GHz

    case 7
        A = 1/12; % Bande de frquence : 11 - 12 GHz
        
    otherwise
        errordlg('Choisissez la bande de frquence','File Error');
end
set(handles.ChoixConstanteA, 'UserData', A);



% Hints: contents = cellstr(get(hObject,'String')) returns ChoixConstanteA contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ChoixConstanteA


% --- Executes during object creation, after setting all properties.
function ChoixConstanteA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChoixConstanteA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in UnitePuissancePRMin.
function UnitePuissancePRMin_Callback(hObject, eventdata, handles)
% hObject    handle to UnitePuissancePRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns UnitePuissancePRMin contents as cell array
%        contents{get(hObject,'Value')} returns selected item from UnitePuissancePRMin
switch get(handles.UnitePuissancePRMin,'Value')   
	case 2
        Unite_P_RX_min = 1; % Unit de la puissance de transmission en dBm
	case 3
        Unite_P_RX_min = 2; % Unit de la puissance de transmission en W
    otherwise
        errordlg('Choisissez l''unit de PRX min','File Error');
end
set(handles.UnitePuissancePRMin, 'UserData', Unite_P_RX_min);

% --- Executes during object creation, after setting all properties.
function UnitePuissancePRMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UnitePuissancePRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function SN_Seuil_sortie_Callback(hObject, eventdata, handles)
% hObject    handle to SN_Seuil_sortie (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SN_Seuil_sortie as text
%        str2double(get(hObject,'String')) returns contents of SN_Seuil_sortie as a double


% --- Executes during object creation, after setting all properties.
function SN_Seuil_sortie_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SN_Seuil_sortie (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Pbruit_Callback(hObject, eventdata, handles)
% hObject    handle to Pbruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Pbruit as text
%        str2double(get(hObject,'String')) returns contents of Pbruit as a double


% --- Executes during object creation, after setting all properties.
function Pbruit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Pbruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in UnitePuissanceBruit.
function UnitePuissanceBruit_Callback(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceBruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch get(handles.UnitePuissanceBruit,'Value')   
	case 2
        Unite_N = 1; % Unit de la puissance de bruit en dBm
	case 3
        Unite_N = 2; % Unit de la puissance de bruit en W
    otherwise
        errordlg('Choisissez l''unit de la puissance de bruit','File Error');
end
set(handles.UnitePuissanceBruit, 'UserData', Unite_N);

% Hints: contents = cellstr(get(hObject,'String')) returns UnitePuissanceBruit contents as cell array
%        contents{get(hObject,'Value')} returns selected item from UnitePuissanceBruit


% --- Executes during object creation, after setting all properties.
function UnitePuissanceBruit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceBruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Temp_Callback(hObject, eventdata, handles)
% hObject    handle to Temp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Temp as text
%        str2double(get(hObject,'String')) returns contents of Temp as a double


% --- Executes during object creation, after setting all properties.
function Temp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Temp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Acceptable_SN_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Acceptable_SN_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Acceptable_SN_seuil as text
%        str2double(get(hObject,'String')) returns contents of Acceptable_SN_seuil as a double


% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Calcul Puissance de Rception :

Espace = get(handles.ChoixEspace, 'UserData');
Unite_P_TX = get(handles.UnitePuissanceTX, 'UserData');
P_TX_value = str2double(get(handles.PTX,'String'));
d_m = str2double(get(handles.distance,'String'));
h_TX_m = str2double(get(handles.hTX,'String'));
h_RX_m = str2double(get(handles.hRX,'String'));
G_TX_dB = str2double(get(handles.GTX,'String'));
G_RX_dB = str2double(get(handles.GRX,'String'));
Lp_dB = str2double(get(handles.Lp,'String'));
L_CTX_dB = str2double(get(handles.LCTX,'String'));
L_CRX_dB = str2double(get(handles.LCRX,'String'));
La_dB = str2double(get(handles.La,'String'));
f_MHz = str2double(get(handles.freq,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_Lp = isempty(get(handles.Lp,'String'));
value_hTX = isempty(get(handles.hTX,'String'));
value_hRX = isempty(get(handles.hRX,'String'));
value_d = isempty(get(handles.distance,'String'));
value_f = isempty(get(handles.freq,'String'));
value_LCTX = isempty(get(handles.LCTX,'String'));
value_LCRX = isempty(get(handles.LCRX,'String'));
value_La = isempty(get(handles.La,'String'));
value_PTX = isempty(get(handles.PTX,'String'));
value_GTX = isempty(get(handles.GTX,'String'));
value_GRX = isempty(get(handles.GRX,'String'));


% Constantes :

c = 3.00 * 10^(8); % Vitesse de la lumire en m/s
k = physconst('Boltzmann'); % Constante de Boltzmann

% Conversions :

if value_f ~=1
    f_Hz = f_MHz * 10^(6); % Frquence en Hz
    f_GHz = f_MHz * 10^(-3); % Frquence en GHz
end

if value_d ~=1
    d_km = d_m * 10^(-3); % Distance en km
end

% Calcul de la puissance de rception :

% Si LCTX et LCRX non renseignes :

if value_LCTX == 1
    set(handles.LCTX, 'String', 0); % On affiche 0 dans l'interface
    L_CTX_dB = 0; % On fixe L_CRX  0 dB;
end

if value_LCRX == 1
    set(handles.LCRX, 'String', 0); % On affiche 0 dans l'interface
    L_CRX_dB = 0; % On fixe L_CRX  0 dB;
end

% Si La non renseigne :

if value_La == 1
    set(handles.La, 'String', 0); % On affiche 0 dans l'interface
    La_dB = 0; % On fixe La  0 dB;
end

% Si GTX et GRX non renseigns :

if value_GTX == 1
    set(handles.GTX, 'String', 0); % On affiche 0 dans l'interface
    G_TX_dB = 0; % On fixe L_CRX  0 dB;
end

if value_GRX == 1
    set(handles.GRX, 'String', 0); % On affiche 0 dans l'interface
    G_RX_dB = 0; % On fixe L_CRX  0 dB;
end

if Espace == 1  % En espace libre
    if value_Lp == 1 % Lp n'a pas t renseigne par l'utilisateur
        if value_d == 1 || value_f ==1 
            errordlg('Rentrer une valeur de Lp ou Rentrer les valeurs de d et de f','File Error');
        else
            Lp_dB = 20*log10((4 * pi * d_m * f_Hz)/c); % Calcul des pertes de propagation en dB en espace libre
            if value_PTX == 0 % Si l'utilisateur a renseign une valeur de P_TX
                if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                	P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CRX_dB - L_CTX_dB - La_dB; % Calcul de la puissance de rception en dBm
                    P_RX_W = 10.^(P_RX_dBm/10).*10^(-3); % Conversion de la puissance de rception en W
                elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                    P_RX_W = (P_TX_value * 10^(G_RX_dB/10) * 10^(G_TX_dB/10))/ ((10^(Lp_dB/10))*(10^(L_CRX_dB/10))*(10^(L_CTX_dB/10)) * (10^(La_dB/10))); % Calcul de la puissance de rception en W
                    P_RX_dBm = 10*log10(P_RX_W * 10^(3)); % Conversion de la puissance de rception en dBm
                else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                    errordlg('Choisissez l''unit de PTX','File Error');
                end
                set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
                set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W
            end
            
            set(handles.Lp,'String',Lp_dB);
        end
          
    else
        if value_PTX == 0 % Si l'utilisateur a renseign une valeur de P_TX
            if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CRX_dB - L_CTX_dB - La_dB; % Calcul de la puissance de rception en dBm
                P_RX_W = 10.^(P_RX_dBm/10).*10^(-3); % Conversion de la puissance de rception en W 
            elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                P_RX_W = (P_TX_value * 10^(G_RX_dB/10) * 10^(G_TX_dB/10))/ (10^(Lp_dB/10)*(10^(L_CRX_dB/10))*(10^(L_CTX_dB/10))* (10^(La_dB/10))); % Calcul de la puissance de rception en W
                P_RX_dBm = 10*log10(P_RX_W * 10^(3)); % Conversion de la puissance de rception en dBm
            else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                errordlg('Choisissez l''unit de PTX','File Error');
            end
            
            set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
            set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W    
        end
        
 
    end

elseif Espace == 2 % En milieu urbain
    if value_Lp == 1
        if value_hTX == 1 || value_hRX ==1 || value_d == 1
            errordlg('Rentrer les valeurs des hauteurs d''antennes et/ou la distance entre Tx et RX ou rentrer une valeur de Lp','File Error');
        else
            if value_PTX == 0 % Si l'utilisateur a rentr une valeur de P_TX
                if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                    P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB  - L_CTX_dB - L_CRX_dB - La_dB + 20*log10(h_TX_m*h_RX_m) - 40*log10(d_m);
                    P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
                elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                    P_TX_value = 10*log10(P_TX_value * 10^(3));
                    P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - L_CTX_dB - L_CRX_dB - La_dB + 20*log10(h_TX_m*h_RX_m) - 40*log10(d_m);
                    P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
                else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                    errordlg('Choisissez l''unit de PTX','File Error');
                end
                set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
                set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W
            end

            
        end
        
    else % Si Lp a t renseign par l'utilisateur
        if value_PTX == 0 % Si l'utilisateur a rentr une valeur de P_TX
            if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CTX_dB - L_CRX_dB - La_dB; % Calcul de P_RX en dBm en milieu urbain
                P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
            elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                P_TX_value = 10*log10(P_TX_value * 10^(3));
                P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CTX_dB - L_CRX_dB - La_dB; % Calcul de P_RX en dBm en milieu urbain
                P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
            else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                errordlg('Choisissez l''unit de PTX','File Error');
            end
            set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
            set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W
        end
        
        
    end
else % Si le milieu de propagation n'a pas t slectionn par l'utilisateur
    errordlg('Choisissez le milieu de propagation','File Error');
end

% Calcul de la puissance de bruit :

N_value = str2double(get(handles.Pbruit,'String'));
Temp_value = str2double(get(handles.Temp,'String'));
W_value = str2double(get(handles.BP,'String'));
Unite_N = get(handles.UnitePuissanceBruit,'UserData');

% Conversions :

T_Kelvin = Temp_value + 273; % Temprature de C en degr Kelvin
W_Hz = W_value * 10^(6); % Bande passante de MHz en Hz

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_N = isempty(get(handles.Pbruit,'String'));
value_Temp = isempty(get(handles.Temp,'String'));
value_W = isempty(get(handles.BP,'String'));

if value_N == 1 % Si l'utilisateur ne rentre pas une valeur de puissance de bruit
    if value_W == 0 && value_Temp == 0 % Si la bande passante et la temprature sont connues
        N_W = k * T_Kelvin * W_Hz; % Calcul de la puissance de bruit en W
        N_dBm = 10*log10(N_W * 10^(3)); % Calcul de la puissance de bruit en dBm
        set(handles.PbruitdBm,'String',N_dBm); % Affiche le rsultat de la puissance de bruit en dBm
        set(handles.PbruitW,'String',N_W); % Affiche le rsultat de la puissance de bruit en W
    end

else % Si l'utilisateur a rentr une valeur de N 
    if Unite_N == 1 % Si l'unit de N est dBm
        N_dBm = N_value;
        N_W = 10^(N_dBm/10) * 10^(-3); % Conversion de N en W
    elseif Unite_N == 2 % Si l'unit de N est W
        N_W = N_value;
        N_dBm = 10*log10(N_W * 10^(3)); % Conversion de N en dBm
    else % Si l'utilisateur n'a pas choisi l'unit de N
        errordlg('Choisissez l''unit de la puissance de bruit','File Error');
    end 
    set(handles.PbruitdBm,'String',N_dBm); % Affiche le rsultat de la puissance de bruit en dBm
    set(handles.PbruitW,'String',N_W); % Affiche le rsultat de la puissance de bruit en W
end

% Calcul de la sensibilit du rcepteur P_RX_min :

PXRMin_value = str2double(get(handles.PXRMin,'String'));
Unite_P_RX_min = get(handles.UnitePuissancePRMin,'UserData');
SNSeuil_value = str2double(get(handles.SNSeuil,'String'));
N_dBm_out_value = str2double(get(handles.PbruitdBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_P_RX_min = isempty(get(handles.PXRMin,'String'));
value_SNSeuil = isempty(get(handles.SNSeuil,'String'));
value_PbruitdBm_out = isempty(get(handles.PbruitdBm,'String'));

if value_P_RX_min == 0 % Si l'utilisateur a rentr une valeur de puissance de rception minimale
    if Unite_P_RX_min == 1 % Si l'unit de PRXmin est dBm
        PXRMin_dBm = PXRMin_value;
        PXRMin_W = 10^(PXRMin_dBm/10) * 10^(-3); % Conversion de PRXmin en W
    elseif Unite_P_RX_min == 2 % Si l'unit de PRXmin est W
        PXRMin_W = PXRMin_value;
        PXRMin_dBm = 10*log10(PXRMin_W * 10^(3)); % Conversion de PRXmin en dBm
    else % Si l'utilisateur n'a pas choisi l'unit de PRXmin
        errordlg('Choisissez l''unit de la sensibilit du rcepteur','File Error');
    end 
    set(handles.PRXmindBm,'String',PXRMin_dBm); % Affiche le rsultat de la puissance de rception minimale en dBm
    set(handles.PRXminW,'String',PXRMin_W); % Affiche le rsultat de la puissance de rception minimale en W

else % Si l'utilisateur ne rentre pas une valeur de puissance de rception minimale
    if value_SNSeuil == 0 && value_PbruitdBm_out == 0 % Si le rapport S/N seuil et la puissance de bruit sont connus
        PXRMin_dBm = SNSeuil_value + N_dBm_out_value; % Calcul de la puissance de rception minimale en dBm
        PXRMin_W = 10^(PXRMin_dBm/10) * 10^(-3); % % Conversion de PRXmin en W
        set(handles.PRXmindBm,'String',PXRMin_dBm); % Affiche le rsultat de la puissance de rception minimale en dBm
        set(handles.PRXminW,'String',PXRMin_W); % Affiche le rsultat de la puissance de rception minimale en W
    end
          
end

% Calcul rapport sur bruit seuil :

PRXMin_dBM_out_value = str2double(get(handles.PRXmindBm,'String'));
SNSeuil_value = str2double(get(handles.SNSeuil,'String'));
N_dBm_out_value = str2double(get(handles.PbruitdBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PRXMin_dBM_out = isempty(get(handles.PRXmindBm,'String'));
value_SNSeuil = isempty(get(handles.SNSeuil,'String'));
value_PbruitdBm_out = isempty(get(handles.PbruitdBm,'String'));

if value_SNSeuil == 0 % Si l'utilisateur a rentr une valeur de S/N seuil
    SNSeuil_dB = SNSeuil_value;
    if SNSeuil_dB > 0 % Si SN seuil >0 dB
        set(handles.Accept_SN_Seuil,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
    else % Si SN seuil <0 dB
        set(handles.Accept_SN_Seuil,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
    end
    set(handles.SN_Seuil_sortie,'String',SNSeuil_dB); % Affiche le rsultat du rapport S/N seuil en dB

else % Si l'utilisateur ne rentre pas une valeur de rapport S/N seuil
    if value_PRXMin_dBM_out == 0 && value_PbruitdBm_out == 0 % Si la sensibilit du rcepteur et la puissance de bruit sont connues
        SNSeuil_dB = PRXMin_dBM_out_value - N_dBm_out_value; % Calcul du rapport S/N seuil en dB
        set(handles.SN_Seuil_sortie,'String',SNSeuil_dB); % Affiche le rsultat du rapport S/N seuil en dB
        if SNSeuil_dB > 0 % Si SN seuil >0 dB
            set(handles.Accept_SN_Seuil,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
        else % Si SN seuil <0 dB
            set(handles.Accept_SN_Seuil,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
        end
    end
          
end

% Calcul rapport sur bruit :

PRX_dBM_out_value = str2double(get(handles.PuissanceRXdBm,'String'));
N_dBm_out_value = str2double(get(handles.PbruitdBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PRX_dBM_out = isempty(get(handles.PuissanceRXdBm,'String'));
value_PbruitdBm_out = isempty(get(handles.PbruitdBm,'String'));

if value_PRX_dBM_out == 0 && value_PbruitdBm_out == 0 % Si la puissance de rception et la puissance de bruit sont connues
	SN_dB = PRX_dBM_out_value - N_dBm_out_value; % Calcul du rapport S/N en dB
	set(handles.SN,'String',SN_dB); % Affiche le rsultat du rapport S/N en dB
end

% Calcul marge de gain :

P_TX_value = str2double(get(handles.PTX,'String'));
PRXMin_dBM_out_value = str2double(get(handles.PRXmindBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PTX = isempty(get(handles.PTX,'String'));
value_PRXMin_dBM_out = isempty(get(handles.PRXmindBm,'String'));

if value_PTX == 0 && value_PRXMin_dBM_out == 0 % Si la puissance de transmission et la puissance de rception minimale sont connues
    if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
    	P_TX_dBm = P_TX_value;
    	GM_dB = P_TX_dBm - PRXMin_dBM_out_value; % Calcul de la marge de gain en dB
    	set(handles.GM,'String',GM_dB); % Affiche le rsultat de la marge de gain en dB
    end
    
    if Unite_P_TX == 2 % Si P_TX a t renseigne en W
        P_TX_dBm = 10*log10(P_TX_value *10^(3)); % Conversion de la puissance de transmission en dBm
        GM_dB = P_TX_dBm - PRXMin_dBM_out_value; % Calcul de la marge de gain en dB
        set(handles.GM,'String',GM_dB); % Affiche le rsultat de la marge de gain en dB
    end
end

% Calcul marge d'vanouissement :

PRX_dBM_out_value = str2double(get(handles.PuissanceRXdBm,'String'));
PRXMin_dBM_out_value = str2double(get(handles.PRXmindBm,'String'));
FM_in_dB_value = str2double(get(handles.FM_Input,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PRX_dBM_out = isempty(get(handles.PuissanceRXdBm,'String'));
value_PRXMin_dBM_out = isempty(get(handles.PRXmindBm,'String'));
value_FM_in_dB = isempty(get(handles.FM_Input,'String'));

if value_FM_in_dB ==0 % Si l'utilisateur a rentr une valeur de FM
    set(handles.FM,'String',FM_in_dB_value); % Affiche le rsultat de la marge d'vanouissement en dB
    if FM_in_dB_value > 0 % Si FM >0 dB
    	set(handles.Accept_FM,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
    else % Si SN seuil <0 dB
        set(handles.Accept_FM,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
    end
else
    if value_PRX_dBM_out == 0 && value_PRXMin_dBM_out == 0 % Si la puissance de rception et la puissance de rception minimale sont connues
        FM_dB = PRX_dBM_out_value - PRXMin_dBM_out_value; % Calcul de la marge d'vanouissement en dB
        set(handles.FM,'String',FM_dB); % Affiche le rsultat de la marge d'vanouissement en dB
        if FM_dB > 0 % Si FM >0 dB
            set(handles.Accept_FM,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
        else % Si SN seuil <0 dB
            set(handles.Accept_FM,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
        end
    end
end

% Calcul qualit de liaison Puissance de rception :

if value_PRX_dBM_out == 0 && value_PRXMin_dBM_out == 0 % Si la puissance de rception et la puissance de rception minimale sont connues
    if abs(PRX_dBM_out_value - value_PRXMin_dBM_out) > 0 % Si puissance reue > puissance de rception minimale en dBm
        set(handles.Accept_PRX,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
    else % Si puissance reue < puissance de rception minimale en dBm
        set(handles.Accept_PRX,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
    end
end

% Vrification du choix du milieu de propagation :

if value_PTX == 0 % Si l'utilisateur a rentr une valeur de puissance de transmission
    if Espace ~= 2 % si l'utilisateur n'a pas renseign le milieu de propagation
        if Espace ~= 1
            errordlg('Choisissez le milieu de propagation','File Error'); % Retourne un message d'erreur pour choisir le milieu de propagation
        end
    end
    
    if Unite_P_TX ~= 1 % si l'utilisateur n'a pas renseign l'unit de la puissance de transmission
        if Unite_P_TX ~= 2
            errordlg('Choisissez l''unit de PTX','File Error'); % Retourne un message d'erreur pour choisir l'unit de la puissance de transmission
        end
    end      
end

% Calcul de la distance :

value_d = isempty(get(handles.distance,'String'));

if value_f == 0
    Lambda = c / f_Hz;
end

if value_d == 1 % Si la distance n'a pas t renseigne
    if Espace == 1 % Milieu rural
        if value_Lp == 0 && value_f == 0 % Si les pertes de propagation et la frquence sont connues
            LP_su = 10^(Lp_dB/10); 
            d_m = (sqrt(LP_su) * Lambda) / (4 * pi); % Calcul de la distance en m
            
            set(handles.distance,'String',d_m); % Affiche le rsultat de la distance en m
        end
    end
    if Espace ==2 % Milieu urbain
        if value_Lp == 0 && value_f == 0 % Si les pertes de propagation et la frquence sont connues
            LP_su = 10^(Lp_dB/10); 
            d_m = (((LP_su)^(1/4)) * Lambda) / (4 * pi); % Calcul de la distance en m
            
            set(handles.distance,'String',d_m); % Affiche le rsultat de la distance en m
        end
    end
end

    
    

% Calcul de la non-disponibilit sans diversit :


B=get(handles.ChoixTypeClimat, 'UserData');
C=get(handles.ChoixTypeTerrain, 'UserData');
FM_out_dB_value = str2double(get(handles.FM,'String'));
d_m = str2double(get(handles.distance,'String'));

% if value_d ~=1
%     d_km = d_m * 10^(-3); % Distance en km
% end

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_FM_out_dB = isempty(get(handles.FM,'String'));

if value_FM_out_dB == 0
    d_km = d_m * 10^(-3); % Distance en km
    Ond_su = 6 * 10^(-7) * B * C * f_GHz * (d_km)^(3) * 10^(-FM_out_dB_value/10); % Calcul de la non-disponibilit sans diversit sans unit
    Ond_pourcentage = Ond_su * 100; % Calcul de la non-disponibilit en %

    set(handles.Ond,'String',Ond_su); % Affiche le rsultat de la non-disponibilit sans diversit sans unit
    set(handles.Ond_pourcent,'String',Ond_pourcentage); % Affiche le rsultat de la non-disponibilit sans diversit en %
end

% Calcul de la non-disponibilit avec diversit de frquence :

    % Calcul du facteur d'amlioration :
    
A = get(handles.ChoixConstanteA, 'UserData');
fc1_value = str2double(get(handles.FreqC1,'String'));
fc2_value = str2double(get(handles.FreqC2,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_fc1 = isempty(get(handles.FreqC1,'String'));
value_fc2 = isempty(get(handles.FreqC2,'String'));

if value_fc1 == 0 && value_fc2 == 0
    Delta_f = abs(fc1_value - fc2_value);
    f_moy = (fc1_value + fc2_value)/2;
    Ifd_su = A * (Delta_f/f_moy) * 10^(FM_out_dB_value/10);
    set(handles.Ifd,'String',Ifd_su); % Affiche le rsultat du facteur d'amlioration diversit de frquence
end

    % Calcul de la non-dispo en cas de diversit de frquence :

Ifd_value = str2double(get(handles.Ifd,'String'));
Ond_value = str2double(get(handles.Ond,'String'));

value_Ifd = isempty(get(handles.Ifd,'String'));
value_Ond = isempty(get(handles.Ond,'String'));

if value_Ifd == 0 && value_Ond == 0 % Si le facteur d'amlioration diversit de frquence et la non-dispo sans diversit sont connus
    Ofd_su = Ond_value / Ifd_value; % Calcul de la non-dispo avec diversit de frquence sans unit
    Ofd_pourcentage = Ofd_su * 100; % Calcul de la non-dispo avec diversit de frquence en %
    set(handles.Ofd,'String',Ofd_su); % Affiche le rsultat de la non-disponibilit avec diversit de frquence sans unit
    set(handles.Ofd_pourcent,'String',Ofd_pourcentage); % Affiche le rsultat de la non-disponibilit avec diversit de frquence en %
end

% Calcul de la non-dispo en cas de diversit d'espace :
    
    % Calcul du facteur d'amlioration en cas de diversit d'espace :
    

v_value = str2double(get(handles.cteV,'String'));
s_value = str2double(get(handles.distance_s_TX1_TX2,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_v = isempty(get(handles.cteV,'String'));
value_s = isempty(get(handles.distance_s_TX1_TX2,'String'));

if value_v == 0 && value_s == 0 && value_FM_out_dB == 0 && value_d == 0 && value_f == 0
    d_km = d_m * 10^(-3); % Distance en km
    Isd_su = (1.2 / d_km) * 10^(-3) * f_GHz * (s_value)^(2) * (v_value)^(2) * 10^(FM_out_dB_value/10); % Calcul du facteur d'amlioration en cas de diversit d'espace
    set(handles.Isd,'String',Isd_su); % Affiche le rsultat du facteur d'amlioration en cas de diversit d'espace
end

	% Calcul de la non-dispo avec diversit d'espace :
    
Isd_value = str2double(get(handles.Isd,'String'));
Ond_value = str2double(get(handles.Ond,'String'));

value_Isd = isempty(get(handles.Isd,'String'));
value_Ond = isempty(get(handles.Ond,'String'));

if value_Isd == 0 && value_Ond == 0
    Osd_su = Ond_value / Isd_value; % Calcul de la non-dispo en cas de diversit d'espace sans unit
    Osd_pourcentage = Osd_su * 100 ; % Calcul de la non-dispo en cas de diversit d'espace en %
    set(handles.Osd,'String',Osd_su); % Affiche le rsultat de la non-disponibilit avec diversit d'espace sans unit
    set(handles.Osd_pourcent,'String',Osd_pourcentage); % Affiche le rsultat de la non-disponibilit avec diversit d'espace en %
end
    




% --- Executes on button press in Effacer.
function Effacer_Callback(hObject, eventdata, handles)
% hObject    handle to Effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entre :

set(handles.PTX, 'String', ''); % Efface la valeur de la puissance de transmission
set(handles.distance, 'String', ''); % Efface la valeur de la distance
set(handles.hTX, 'String', ''); % Efface la valeur de la hauteur d'antenne TX
set(handles.hRX, 'String', ''); % Efface la valeur de la hauteur d'antenne RX
set(handles.GTX, 'String', ''); % Efface la valeur du gain d'antenne TX
set(handles.GRX, 'String', ''); % Efface la valeur du gain d'antenne RX
set(handles.Lp, 'String', ''); % Efface la valeur des pertes de propagation
set(handles.LCTX, 'String', ''); % Efface la valeur des pertes de connexion LCTX
set(handles.LCRX, 'String', ''); % Efface la valeur des pertes de connexion LCRX
set(handles.La, 'String', ''); % Efface la valeur des pertes atmosphriques
set(handles.Pbruit, 'String', ''); % Efface la valeur des pertes de bruit
set(handles.Temp, 'String', ''); % Efface la valeur de la temprature
set(handles.BP, 'String', ''); % Efface la valeur de la bande passante
set(handles.SNSeuil, 'String', ''); % Efface la valeur du rapport S/N seuil
set(handles.freq, 'String', ''); % Efface la valeur de la frquence
set(handles.PXRMin, 'String', ''); % Efface la valeur de la puissance de rception minimale
set(handles.UnitePuissanceTX, 'Value', 1); % Remet le popumenu "Unit PTX"  l'tat initial
set(handles.ChoixEspace, 'Value', 1); % Remet le popumenu "Choix espace"  l'tat initial
set(handles.UnitePuissanceBruit, 'Value', 1); % Remet le popumenu "Unit N"  l'tat initial
set(handles.UnitePuissancePRMin, 'Value', 1); % Remet le popumenu "Unit PRXmin"  l'tat initial
set(handles.FM_Input, 'String', ''); % Efface la valeur de la marge d'vanouissement
set(handles.ChoixTypeClimat, 'Value', 1); % Remet le popumenu "Choix Type de climat"  l'tat initial (disponibilit)
set(handles.ChoixTypeTerrain, 'Value', 1); % Remet le popumenu "ChoixTypeTerrain"  l'tat initial (disponibilit)
set(handles.ChoixConstanteA, 'Value', 1); % Remet le popumenu "ChoixConstanteA"  l'tat initial (diversit de frquence)
set(handles.FreqC1, 'String', ''); % Efface la valeur de la frquence porteuse fc1 (diversit de frquence)
set(handles.FreqC2, 'String', ''); % Efface la valeur de la frquence porteuse fc2 (diversit de frquence)
set(handles.cteV, 'String', ''); % Efface la valeur de la constante v (diversit d'espace)
set(handles.distance_s_TX1_TX2, 'String', ''); % Efface la valeur de la distance entre les deux antennes de transmission (diversit d'espace)


% Effacer les valeurs de sortie :

set(handles.PuissanceRXdBm, 'String', ''); % Efface la valeur de P_RX_dBm
set(handles.PuissanceRXW, 'String', ''); % Efface la valeur de P_RX_W
set(handles.PbruitdBm, 'String', ''); % Efface la valeur de N_dBm
set(handles.PbruitW, 'String', ''); % Efface la valeur de N_W
set(handles.PRXmindBm, 'String', ''); % Efface la valeur de P_RX_dBm minimale
set(handles.PRXminW, 'String', ''); % Efface la valeur de P_RX_W minimale
set(handles.SN, 'String', ''); % Efface la valeur du rapport S/N
set(handles.SN_Seuil_sortie, 'String', ''); % Efface la valeur du rapport S/N seuil
set(handles.GM, 'String', ''); % Efface la valeur de la marge de gain
set(handles.FM, 'String', ''); % Efface la valeur de la marge d'vanouissement
set(handles.Accept_SN_Seuil, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' SN_seuil
set(handles.Accept_PRX, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' PRX
set(handles.Accept_FM, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' FM
set(handles.Ond, 'String', ''); % Efface la valeur de la non-dispo sans diversit
set(handles.Ofd, 'String', ''); % Efface la valeur de la non-dispo avec diversit de frquence
set(handles.Osd, 'String', ''); % Efface la valeur de la non-dispo avec diversit d'espace
set(handles.Ifd, 'String', ''); % Efface la valeur du facteur d'amlioration en cas de diversit de frquence
set(handles.Isd, 'String', ''); % Efface la valeur du facteur d'amlioration en cas de diversit d'espace
set(handles.Ond_pourcent, 'String', ''); % Efface la valeur de la non-dispo en % sans diversit
set(handles.Ofd_pourcent, 'String', ''); % Efface la valeur de la non-dispo en % avec diversit de frquence
set(handles.Osd_pourcent, 'String', ''); % Efface la valeur de la non-dispo en % avec diversit d'espace


% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all;


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal
close Liaisons_fixes_BilanLiaison_Dispo
