function varargout = Dimensionnement_reseau_cellulaire(varargin)
% Liaisons_fixes MATLAB code for Liaisons_fixes.fig
%      Liste des programmes :
%           - Premire interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilit
%           - Temprature et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des rseaux cellulaires
%           - Dbit maximal 
%
%      Liaisons_fixes, by itself, creates a new Dimensionnement_reseau_cellulaire or raises the existing
%      singleton*.
%
%      H = Liaisons_fixes returns the handle to a new Dimensionnement_reseau_cellulaire or the handle to
%      the existing singleton*.
%
%      Dimensionnement_reseau_cellulaire('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Liaisons_fixes.M with the given input arguments.
%
%      Dimensionnement_reseau_cellulaire('Property','Value',...) creates a new Liaisons_fixes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Dimensionnement_reseau_cellulaire_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Liaisons_fixes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Dimensionnement_reseau_cellulaire
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 16-Apr-2019 18:57:37

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Dimensionnement_reseau_cellulaire_OpeningFcn, ...
                   'gui_OutputFcn',  @Dimensionnement_reseau_cellulaire_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Dimensionnement_reseau_cellulaire is made visible.
function Dimensionnement_reseau_cellulaire_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Dimensionnement_reseau_cellulaire (see VARARGIN)

% Choose default command line output for Dimensionnement_reseau_cellulaire
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);




% UIWAIT makes Dimensionnement_reseau_cellulaire wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Dimensionnement_reseau_cellulaire_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function S_reseau_Callback(hObject, eventdata, handles)
% hObject    handle to S_reseau (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_reseau as text
%        str2double(get(hObject,'String')) returns contents of S_reseau as a double


% --- Executes during object creation, after setting all properties.
function S_reseau_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_reseau (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ChoixSysteme.
function ChoixSysteme_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixSysteme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns ChoixSysteme contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ChoixSysteme

switch get(handles.ChoixSysteme,'Value')   
	case 2
        Type_reseau = 1; % Rseau AMPS
 
	case 3
        Type_reseau = 2; % Rseau NAMPS

    case 4
        Type_reseau = 3; % Rseau TDMA/DAMPS

    case 5
        Type_reseau = 4; % Rseau GSM

    case 6
        Type_reseau = 5; % Rseau CDMA
        
    otherwise
        errordlg('Choisissez le type de rseau','File Error');

end
set(handles.ChoixSysteme, 'UserData', Type_reseau);



% --- Executes during object creation, after setting all properties.
function ChoixSysteme_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChoixSysteme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function R_cellule_Callback(hObject, eventdata, handles)
% hObject    handle to R_cellule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of R_cellule as text
%        str2double(get(hObject,'String')) returns contents of R_cellule as a double


% --- Executes during object creation, after setting all properties.
function R_cellule_CreateFcn(hObject, eventdata, handles)
% hObject    handle to R_cellule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function S_cellule_Callback(hObject, eventdata, handles)
% hObject    handle to S_cellule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_cellule as text
%        str2double(get(hObject,'String')) returns contents of S_cellule as a double


% --- Executes during object creation, after setting all properties.
function S_cellule_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_cellule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_motif_Callback(hObject, eventdata, handles)
% hObject    handle to T_motif (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_motif as text
%        str2double(get(hObject,'String')) returns contents of T_motif as a double


% --- Executes during object creation, after setting all properties.
function T_motif_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_motif (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_Callback(hObject, eventdata, handles)
% hObject    handle to C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C as text
%        str2double(get(hObject,'String')) returns contents of C as a double


% --- Executes during object creation, after setting all properties.
function C_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_Callback(hObject, eventdata, handles)
% hObject    handle to T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T as text
%        str2double(get(hObject,'String')) returns contents of T as a double


% --- Executes during object creation, after setting all properties.
function T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_Unite_T.
function Choix_Unite_T_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_Unite_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_Unite_T contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_Unite_T

switch get(handles.Choix_Unite_T,'Value')   
	case 2
        Unite_T = 1; % Unit de la dure d'un appel en secondes
	case 3
        Unite_T = 2; % Unit de la dure d'un appel en minutes
    case 4
        Unite_T = 3; % Unit de la dure d'un appel en heures
    otherwise
        errordlg('Choisissez l''unit de la dure d''un appel','File Error');
end
set(handles.Choix_Unite_T, 'UserData', Unite_T);



% --- Executes during object creation, after setting all properties.
function Choix_Unite_T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_Unite_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function D_km_Callback(hObject, eventdata, handles)
% hObject    handle to D_km (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of D_km as text
%        str2double(get(hObject,'String')) returns contents of D_km as a double


% --- Executes during object creation, after setting all properties.
function D_km_CreateFcn(hObject, eventdata, handles)
% hObject    handle to D_km (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_abonne_Callback(hObject, eventdata, handles)
% hObject    handle to Q_abonne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_abonne as text
%        str2double(get(hObject,'String')) returns contents of Q_abonne as a double


% --- Executes during object creation, after setting all properties.
function Q_abonne_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_abonne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_abonne_Callback(hObject, eventdata, handles)
% hObject    handle to C_abonne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_abonne as text
%        str2double(get(hObject,'String')) returns contents of C_abonne as a double


% --- Executes during object creation, after setting all properties.
function C_abonne_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_abonne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_abonne_Callback(hObject, eventdata, handles)
% hObject    handle to T_abonne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_abonne as text
%        str2double(get(hObject,'String')) returns contents of T_abonne as a double


% --- Executes during object creation, after setting all properties.
function T_abonne_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_abonne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function N_motif_Callback(hObject, eventdata, handles)
% hObject    handle to N_motif (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_motif as text
%        str2double(get(hObject,'String')) returns contents of N_motif as a double


% --- Executes during object creation, after setting all properties.
function N_motif_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_motif (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function S_out_Callback(hObject, eventdata, handles)
% hObject    handle to S_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_out as text
%        str2double(get(hObject,'String')) returns contents of S_out as a double


% --- Executes during object creation, after setting all properties.
function S_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function W_reseau_out_Callback(hObject, eventdata, handles)
% hObject    handle to W_reseau_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of W_reseau_out as text
%        str2double(get(hObject,'String')) returns contents of W_reseau_out as a double


% --- Executes during object creation, after setting all properties.
function W_reseau_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to W_reseau_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_reseau_E_MHz_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_MHz_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_reseau_E_MHz_out as text
%        str2double(get(hObject,'String')) returns contents of Q_reseau_E_MHz_out as a double


% --- Executes during object creation, after setting all properties.
function Q_reseau_E_MHz_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_MHz_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_reseau_out_Callback(hObject, eventdata, handles)
% hObject    handle to C_reseau_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_reseau_out as text
%        str2double(get(hObject,'String')) returns contents of C_reseau_out as a double


% --- Executes during object creation, after setting all properties.
function C_reseau_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_reseau_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_reseau_E_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_reseau_E_out as text
%        str2double(get(hObject,'String')) returns contents of Q_reseau_E_out as a double


% --- Executes during object creation, after setting all properties.
function Q_reseau_E_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_reseau_E_km2_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_reseau_E_km2_out as text
%        str2double(get(hObject,'String')) returns contents of Q_reseau_E_km2_out as a double


% --- Executes during object creation, after setting all properties.
function Q_reseau_E_km2_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_reseau_E_MHz_km2_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_MHz_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_reseau_E_MHz_km2_out as text
%        str2double(get(hObject,'String')) returns contents of Q_reseau_E_MHz_km2_out as a double


% --- Executes during object creation, after setting all properties.
function Q_reseau_E_MHz_km2_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_reseau_E_MHz_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_abonne_out_Callback(hObject, eventdata, handles)
% hObject    handle to N_abonne_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_abonne_out as text
%        str2double(get(hObject,'String')) returns contents of N_abonne_out as a double


% --- Executes during object creation, after setting all properties.
function N_abonne_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_abonne_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function W_m_out_Callback(hObject, eventdata, handles)
% hObject    handle to W_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of W_m_out as text
%        str2double(get(hObject,'String')) returns contents of W_m_out as a double


% --- Executes during object creation, after setting all properties.
function W_m_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to W_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function S_m_out_Callback(hObject, eventdata, handles)
% hObject    handle to S_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_m_out as text
%        str2double(get(hObject,'String')) returns contents of S_m_out as a double


% --- Executes during object creation, after setting all properties.
function S_m_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_m_out_Callback(hObject, eventdata, handles)
% hObject    handle to N_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_m_out as text
%        str2double(get(hObject,'String')) returns contents of N_m_out as a double


% --- Executes during object creation, after setting all properties.
function N_m_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_canaux_m_out_Callback(hObject, eventdata, handles)
% hObject    handle to N_canaux_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_canaux_m_out as text
%        str2double(get(hObject,'String')) returns contents of N_canaux_m_out as a double


% --- Executes during object creation, after setting all properties.
function N_canaux_m_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_canaux_m_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_cellules_reseau_out_Callback(hObject, eventdata, handles)
% hObject    handle to N_cellules_reseau_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_cellules_reseau_out as text
%        str2double(get(hObject,'String')) returns contents of N_cellules_reseau_out as a double


% --- Executes during object creation, after setting all properties.
function N_cellules_reseau_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_cellules_reseau_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function S_c_out_Callback(hObject, eventdata, handles)
% hObject    handle to S_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_c_out as text
%        str2double(get(hObject,'String')) returns contents of S_c_out as a double


% --- Executes during object creation, after setting all properties.
function S_c_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function W_c_out_Callback(hObject, eventdata, handles)
% hObject    handle to W_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of W_c_out as text
%        str2double(get(hObject,'String')) returns contents of W_c_out as a double


% --- Executes during object creation, after setting all properties.
function W_c_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to W_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_c_E_MHz_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_c_E_MHz_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_c_E_MHz_out as text
%        str2double(get(hObject,'String')) returns contents of Q_c_E_MHz_out as a double


% --- Executes during object creation, after setting all properties.
function Q_c_E_MHz_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_c_E_MHz_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_out_Callback(hObject, eventdata, handles)
% hObject    handle to C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_out as text
%        str2double(get(hObject,'String')) returns contents of C_out as a double


% --- Executes during object creation, after setting all properties.
function C_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_c_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_c_out as text
%        str2double(get(hObject,'String')) returns contents of Q_c_out as a double


% --- Executes during object creation, after setting all properties.
function Q_c_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_c_E_km2_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_c_E_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_c_E_km2_out as text
%        str2double(get(hObject,'String')) returns contents of Q_c_E_km2_out as a double


% --- Executes during object creation, after setting all properties.
function Q_c_E_km2_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_c_E_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_c_E_MHz_km2_out_Callback(hObject, eventdata, handles)
% hObject    handle to Q_c_E_MHz_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_c_E_MHz_km2_out as text
%        str2double(get(hObject,'String')) returns contents of Q_c_E_MHz_km2_out as a double


% --- Executes during object creation, after setting all properties.
function Q_c_E_MHz_km2_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_c_E_MHz_km2_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_abonne_c_out_Callback(hObject, eventdata, handles)
% hObject    handle to N_abonne_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_abonne_c_out as text
%        str2double(get(hObject,'String')) returns contents of N_abonne_c_out as a double


% --- Executes during object creation, after setting all properties.
function N_abonne_c_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_abonne_c_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_out_Callback(hObject, eventdata, handles)
% hObject    handle to N_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_out as text
%        str2double(get(hObject,'String')) returns contents of N_out as a double


% --- Executes during object creation, after setting all properties.
function N_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_I_dB_out_Callback(hObject, eventdata, handles)
% hObject    handle to C_I_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_I_dB_out as text
%        str2double(get(hObject,'String')) returns contents of C_I_dB_out as a double


% --- Executes during object creation, after setting all properties.
function C_I_dB_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_I_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function D_min_km_out_Callback(hObject, eventdata, handles)
% hObject    handle to D_min_km_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of D_min_km_out as text
%        str2double(get(hObject,'String')) returns contents of D_min_km_out as a double


% --- Executes during object creation, after setting all properties.
function D_min_km_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to D_min_km_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_D_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_D as text
%        str2double(get(hObject,'String')) returns contents of Accept_D as a double


% --- Executes during object creation, after setting all properties.
function Accept_D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_C_I_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_C_I (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_C_I as text
%        str2double(get(hObject,'String')) returns contents of Accept_C_I as a double


% --- Executes during object creation, after setting all properties.
function Accept_C_I_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_C_I (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_N_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_N as text
%        str2double(get(hObject,'String')) returns contents of Accept_N as a double


% --- Executes during object creation, after setting all properties.
function Accept_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_I_seuil_dB_Callback(hObject, eventdata, handles)
% hObject    handle to C_I_seuil_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_I_seuil_dB as text
%        str2double(get(hObject,'String')) returns contents of C_I_seuil_dB as a double


% --- Executes during object creation, after setting all properties.
function C_I_seuil_dB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_I_seuil_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function W_reseau_Callback(hObject, eventdata, handles)
% hObject    handle to W_reseau (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of W_reseau as text
%        str2double(get(hObject,'String')) returns contents of W_reseau as a double


% --- Executes during object creation, after setting all properties.
function W_reseau_CreateFcn(hObject, eventdata, handles)
% hObject    handle to W_reseau (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Q_c_Callback(hObject, eventdata, handles)
% hObject    handle to Q_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_c as text
%        str2double(get(hObject,'String')) returns contents of Q_c as a double


% --- Executes during object creation, after setting all properties.
function Q_c_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_Callback(hObject, eventdata, handles)
% hObject    handle to N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N as text
%        str2double(get(hObject,'String')) returns contents of N as a double


% --- Executes during object creation, after setting all properties.
function N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function P_pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to P_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of P_pourcent as text
%        str2double(get(hObject,'String')) returns contents of P_pourcent as a double


% --- Executes during object creation, after setting all properties.
function P_pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to P_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Calcul de la bande passante d'un canal en fonction du type de rseau :

Type_reseau = get(handles.ChoixSysteme, 'UserData');

if Type_reseau == 1 % Si type de rseau = AMPS
	W_canaux = 60e3; % Bande Passante AMPS en Hz
elseif Type_reseau == 2 % Si type de rseau = NAMPS
	W_canaux = 20e3; % Bande Passante NAMPS en Hz
elseif Type_reseau == 3 % Si type de rseau = TDMA/DAMPS
	W_canaux = 60e3; % Bande Passante TDMA/DAMPS en Hz
elseif Type_reseau == 4 % Si type de rseau = GSM
	W_canaux = 400e3; % Bande Passante GSM en Hz
elseif Type_reseau == 5 % Si type de rseau = CDMA
	W_canaux = 1.25e6; % Bande Passante CDMA en Hz
end


% Conversion de la dure d'un appel en heure si la valeur a t renseigne:

value_T_su = isempty(get(handles.T,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
Unite_T = get(handles.Choix_Unite_T, 'UserData');
T_su_value = str2double(get(handles.T,'String')); % Rcupration de la valeur de la dure d'un appel sans unit

if value_T_su == 0 % Si une dure a t renseigne
    if Unite_T == 1 % Si l'unit de la dure est en secondes
        T_h = T_su_value / (3600); % Conversion de la dure en h
    elseif Unite_T == 2 % Si l'unit de la dure est en minutes
        T_h = T_su_value / (60); % Conversion de la dure en h
    elseif Unite_T == 3 % Si l'unit de la dure est en heures
        T_h = T_su_value; % Affectation de la valeur utilisateur dans la variable
    else % Si aucune unit n'a t choisie
        errordlg('Choisissez l''unit de la dure d''un appel','File Error');
    end
end

% Conversion Rapport d'interfrence co-canal : dB --> Sans unit

value_C_I_seuil_dB = isempty(get(handles.C_I_seuil_dB,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_C_I_seuil_dB ==0
    C_I_seuil_dB_value = str2double(get(handles.C_I_seuil_dB,'String')); % Rcupration de la valeur du rapport C/I en dB
    C_I_seuil_su = 10^(C_I_seuil_dB_value/10);
end

% Calcul de la bande passante du rseau :

value_W_reseau = isempty(get(handles.W_reseau,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N = isempty(get(handles.N,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)


if value_W_reseau == 0 % Si la bande passante du rseau est connue
    W_reseau_value = str2double(get(handles.W_reseau,'String')); % Rcupration de la valeur de la bande passante du rseau
    W_reseau_MHz = W_reseau_value;
    set(handles.W_reseau_out,'String',W_reseau_MHz); % Affiche le rsultat de la bande passante du rseau en sortie
    set(handles.W_m_out,'String',W_reseau_MHz); % Affiche le rsultat de la bande passante du motif en sortie

else
    if value_N ==0 && value_T_motif ==0 && (Type_reseau == 1 || Type_reseau == 2 || Type_reseau == 3 || Type_reseau == 4 || Type_reseau == 5 )
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        N_value = str2double(get(handles.N,'String')); % Rcupration de la valeur du nombre de canaux par cellule
        W_reseau_Hz = W_canaux * N_value * T_motif_value; % Calcul de la bande passante du rseau en Hz
        W_reseau_MHz = W_reseau_Hz * 10^(-6); % Conversion Bande passante rseau en MHz
        set(handles.W_reseau_out,'String',W_reseau_MHz); % Affiche le rsultat de la bande passante du rseau en sortie
        set(handles.W_m_out,'String',W_reseau_MHz); % Affiche le rsultat de la bande passante du motif en sortie
    end
end

% Calcul surface rseau :

value_S_cellule = isempty(get(handles.S_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_R_cellule = isempty(get(handles.R_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_reseau = isempty(get(handles.S_reseau,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_motif = isempty(get(handles.N_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_S_reseau == 0 % Si la surface du rseau est connue
	S_reseau_value = str2double(get(handles.S_reseau,'String')); % Rcupration de la valeur de la surface du rseau
    S_reseau_km2 = S_reseau_value;
    set(handles.S_out,'String',S_reseau_km2); % Affiche le rsultat de la surface du rseau
else
    if value_S_cellule == 0 && value_N_motif == 0 && value_T_motif == 0 % Si la surface d'une cellule, la taille d'un motif et le nombre de motifs dans le rseau sont connus
        S_cellule_value = str2double(get(handles.S_cellule,'String')); % Rcupration de la valeur de la surface d'une cellule
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        N_motif_value = str2double(get(handles.N_motif,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
        S_reseau_km2 = S_cellule_value * T_motif_value * N_motif_value ; % Calcul de la surface du rseau
        set(handles.S_out,'String',S_reseau_km2); % Affiche le rsultat de la surface du rseau
    elseif value_R_cellule == 0 && value_N_motif == 0 && value_T_motif == 0 % Si le rayon d'une cellule, la taille d'un motif et le nombre de motifs dans le rseau sont connus
        R_cellule_value = str2double(get(handles.R_cellule,'String')); % Rcupration de la valeur du rayon d'une cellule
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        N_motif_value = str2double(get(handles.N_motif,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
        S_reseau_km2 = pi * (R_cellule_value)^2 * T_motif_value * N_motif_value ; % Calcul de la surface du rseau
        set(handles.S_out,'String',S_reseau_km2); % Affiche le rsultat de la surface du rseau
    end
end

% Calcul surface cellule :

value_S_cellule = isempty(get(handles.S_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_R_cellule = isempty(get(handles.R_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_reseau = isempty(get(handles.S_reseau,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_motif = isempty(get(handles.N_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_D_km = isempty(get(handles.D_km,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_C_I_seuil_dB = isempty(get(handles.C_I_seuil_dB,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_S_cellule == 0 % Si la surface d'une cellule a t renseigne
    S_cellule_value = str2double(get(handles.S_cellule,'String')); % Rcupration de la valeur de la surface d'une cellule
    S_cellule_km2 = S_cellule_value;
    set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
else % Surface d'une cellule non renseigne
    if value_R_cellule ==0 % Si rayon d'une cellule est connu
        R_cellule_value = str2double(get(handles.R_cellule,'String')); % Rcupration de la valeur du rayon d'une cellule
        S_cellule_km2 = pi * (R_cellule_value)^2; % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
	elseif value_S_reseau == 0 && value_T_motif == 0 && value_N_motif == 0 % Si la surface du rseau, la taille d'un motif et le nombre de motifs dans le rseau sont connus
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        N_motif_value = str2double(get(handles.N_motif,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
        S_reseau_value = str2double(get(handles.S_reseau,'String')); % Rcupration de la valeur de la surface du rseau
        S_cellule_km2 = S_reseau_value / (N_motif_value * T_motif_value); % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
    elseif value_D_km ==0 && value_T_motif == 0 % Si la distance entre cellules de mme frquence et la taille des motifs sont connues
        D_km_value = str2double(get(handles.D_km,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        R_cellule_km = D_km_value / (sqrt(3 * T_motif_value)); % Calcul du rayon d'une cellule
        S_cellule_km2 = pi * (R_cellule_km)^2; % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
        set(handles.R_cellule,'String',R_cellule_km); % Affiche le rsultat du rayon d'une cellule
    elseif value_C_I_seuil_dB ==0 && value_D_km ==0 % Si rapport d'interfrence cocanal et la distance entre cellules de mme frquence sont connus
        D_km_value = str2double(get(handles.D_km,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
        R_cellule_km = D_km_value /(C_I_seuil_su)^(1/3.52); % Calcul du rayon d'une cellule
        S_cellule_km2 = pi * (R_cellule_km)^2; % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
        set(handles.R_cellule,'String',R_cellule_km); % Affiche le rsultat du rayon d'une cellule
    end
end

% Calcul du rayon d'une cellule :

value_S_cellule = isempty(get(handles.S_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_R_cellule = isempty(get(handles.R_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_D_km = isempty(get(handles.D_km,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_C_I_seuil_dB = isempty(get(handles.C_I_seuil_dB,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_R_cellule ==1 % Si le rayon d'une cellule n'est pas connu
    if value_S_cellule == 0 % Si la surface d'une cellule a t renseigne
        S_cellule_value = str2double(get(handles.S_cellule,'String')); % Rcupration de la valeur de la surface d'une cellule
        R_cellule_km = sqrt ( pi / S_cellule_value); % Calcul du rayon d'une cellule
        set(handles.R_cellule,'String',R_cellule_km); % Affiche le rsultat du rayon d'une cellule
    elseif value_D_km ==0 && value_T_motif == 0 % Si la distance entre cellules de mme frquence et la taille des motifs sont connues
        D_km_value = str2double(get(handles.D_km,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        R_cellule_km = D_km_value / (sqrt(3 * T_motif_value)); % Calcul du rayon d'une cellule
        S_cellule_km2 = pi * (R_cellule_km)^2; % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
        set(handles.R_cellule,'String',R_cellule_km); % Affiche le rsultat du rayon d'une cellule
    elseif value_C_I_seuil_dB ==0 && value_D_km ==0 % Si rapport d'interfrence cocanal et la distance entre cellules de mme frquence sont connus
        D_km_value = str2double(get(handles.D_km,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
        R_cellule_km = D_km_value /(C_I_seuil_su)^(1/3.52); % Calcul du rayon d'une cellule
        S_cellule_km2 = pi * (R_cellule_km)^2; % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
        set(handles.R_cellule,'String',R_cellule_km); % Affiche le rsultat du rayon d'une cellule
    end
end


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :
value_P_pourcent = isempty(get(handles.P_pourcent,'String'));
value_C_appel_h = isempty(get(handles.C,'String'));
value_Q_c = isempty(get(handles.Q_c,'String'));
value_T_su = isempty(get(handles.T,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N = isempty(get(handles.N,'String'));
Unite_T = get(handles.Choix_Unite_T, 'UserData');
  
% Calcul du trafic par cellule : 

if value_Q_c == 0 % Si le trafic a t renseign
	Q_c_value = str2double(get(handles.Q_c,'String')); % Rcupration de la valeur du trafic par cellule
    Q_c_E = Q_c_value;
    set(handles.Q_c_out,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang en sortie
else % Si le trafic n'a pas t renseign
	if value_C_appel_h ==0 && value_T_su ==0 % Si le nombre d'appels et la dure d'un appel ont t renseigns
        C_appel_h_value = str2double(get(handles.C,'String')); % Rcupration de la valeur du nombre d'appels moyen par heure
        if Unite_T == 1
            Q_c_E = C_appel_h_value * T_h; % Calcul du trafic en Erlangs
            set(handles.Q_c_out,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang en sortie
            set(handles.Q_c,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang ct entre
        elseif Unite_T == 2
            Q_c_E = C_appel_h_value * T_h; % Calcul du trafic en Erlangs
            set(handles.Q_c_out,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang en sortie
            set(handles.Q_c,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang ct entre
        elseif Unite_T == 3
            Q_c_E = C_appel_h_value * T_h; % Calcul du trafic en Erlangs
            set(handles.Q_c_out,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang en sortie
            set(handles.Q_c,'String',Q_c_E); % Affiche le rsultat du trafic en Erlang ct entre
        else
            errordlg('Choisissez l''unit de la dure d''un appel','File Error');
        end
	end
end

% Calcul de la probabilit de blocage selon le modle d'Erlang B :

value_Q_c = isempty(get(handles.Q_c,'String'));
Choix_Syst = get(handles.ChoixSysteme, 'Value'); % = 1 Si popmenu  l'tat initial
    
if value_P_pourcent == 1 % Si la probabilit de blocage n'a pas t renseigne
    if value_Q_c ==0 && value_N == 0 && Choix_Syst == 1 % Si le trafic calcul et le nombre de lignes sont connus et le type de rseau est non connu
        Q_c_value = str2double(get(handles.Q_c,'String')); % Rcupration de la valeur du trafic
        N_value = str2double(get(handles.N,'String')); % Rcupration du nombre de canaux par cellule
        sum3 = 0;
        for i = 0 : N_value
            sum3= sum3 + Q_c_value^(i)/factorial(i); % Calcul du dnominateur
        end

	denominateur = sum3;
	numerateur = Q_c_value^(N_value) / factorial(N_value); % Calcul du numrateur
    P = numerateur / denominateur; % Calcul de la probabilit de blocage
	P_pourcentage = P * 100; % Probabilit de blocage en pourcentage
	set(handles.P_pourcent,'String',P_pourcentage); % Affiche le rsultat de la probabilit de blocage en %
    
    elseif value_Q_c ==0 && value_N == 0 && Choix_Syst ~= 1 % Si le trafic calcul et le nombre de lignes et le type de rseau sont connus
        N_value = str2double(get(handles.N,'String')); % Rcupration de la valeur du nombre de canaux par cellule (en entre)
        if Type_reseau == 1 || Type_reseau == 2 % Si type de rseau AMPS ou NAMPS
            N_canaux_cellule = N_value; % Pas de multiplexage
        elseif Type_reseau == 3 % Si type de rseau = TDMA/DAMPS
            N_canaux_cellule = N_value * 3; % Multiplexage par 3
        elseif Type_reseau == 4 % Si type de rseau = GSM
            N_canaux_cellule = N_value * 8; % Multiplexage par 8
        elseif Type_reseau == 5 % Si type de rseau = CDMA
            N_canaux_cellule = N_value * 55; % Multiplexage par 55
        end
        
        Q_c_value = str2double(get(handles.Q_c,'String')); % Rcupration de la valeur du trafic
        sum3 = 0;
        for i = 0 : N_canaux_cellule
            sum3= sum3 + Q_c_value^(i)/factorial(i); % Calcul du dnominateur
        end
        denominateur = sum3;
        numerateur = Q_c_value^(N_canaux_cellule) / factorial(N_canaux_cellule); % Calcul du numrateur
        P = numerateur / denominateur; % Calcul de la probabilit de blocage
        P_pourcentage = P * 100; % Probabilit de blocage en pourcentage
        set(handles.P_pourcent,'String',P_pourcentage); % Affiche le rsultat de la probabilit de blocage en %
    end
end

        
% Calcul de la distance minimale entre cellules de mme frquence :

value_R_cellule = isempty(get(handles.R_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_R_cellule == 0 && value_T_motif == 0 % Si le rayon d'une cellule et la taille des motifs sont connus
    T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
    R_cellule_value = str2double(get(handles.R_cellule,'String')); % Rcupration de la valeur du rayon d'une cellule
    D_min_km = sqrt ( 3 * T_motif_value ) * R_cellule_value; % Calcul de la distance minimale entre cellules de mme frquence
    set(handles.D_min_km_out,'String',D_min_km); % Affiche le rsultat de la distance minimale entre cellules de mme frquence
end

% Calcul de l'interfrence co-canal "rel" :
value_R_cellule = isempty(get(handles.R_cellule,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_D_km = isempty(get(handles.D_km,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_T_motif == 0 % Si la taille du motif est connue 
	T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
    C_I_su = (3 * T_motif_value)^(3.52/2); % Calcul de l'interfrence cocanal sans unit
    C_I_dB = 10*log10(C_I_su); % Conversion de l'interfrence cocanal en dB
    set(handles.C_I_dB_out,'String',C_I_dB); % Affiche le rsultat de l'interfrence cocanal en dB
elseif value_D_km == 0 && value_R_cellule == 0 % Si la distance entre cellules de mme frquence et le rayon d'une cellule sont connus
    D_km_value = str2double(get(handles.D_km,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
    R_cellule_value = str2double(get(handles.R_cellule,'String')); % Rcupration de la valeur du rayon d'une cellule
    C_I_su = (D_km_value / R_cellule_value)^(3.52); % Calcul de l'interfrence cocanal sans unit
    C_I_dB = 10*log10(C_I_su); % Conversion de l'interfrence cocanal en dB
    set(handles.C_I_dB_out,'String',C_I_dB); % Affiche le rsultat de l'interfrence cocanal en dB
end

% Calcul de la surface d'un motif :

value_S_reseau_out = isempty(get(handles.S_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_motif = isempty(get(handles.N_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_cellule_out = isempty(get(handles.S_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_motif_out = isempty(get(handles.S_m_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_S_motif_out == 1 % Si la surface d'un motif n'est pas connue
    if value_S_reseau_out == 0 && value_N_motif == 0 % Si la surface du rseau et le nombre de motifs dans le rseau sont connus
        S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la taille d'un motif
        N_motif_value = str2double(get(handles.N_motif,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
        S_motif_km2 = S_reseau_out_value / N_motif_value ; % Calcul de la surface d'un motif
        set(handles.S_m_out,'String',S_motif_km2); % Affiche le rsultat de la surface d'un motif
    elseif value_S_cellule_out == 0 && value_T_motif == 0 % Si la surface d'une cellule et la taille d'un motif sont connues
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule en sortie
        S_motif_km2 = S_cellule_out_value * T_motif_value ; % Calcul de la surface d'un motif
        set(handles.S_m_out,'String',S_motif_km2); % Affiche le rsultat de la surface d'un motif
    end
end

% Calcul du nombre de motifs dans le rseau :

value_S_reseau_out = isempty(get(handles.S_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_motif = isempty(get(handles.N_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_cellule_out = isempty(get(handles.S_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_motif_out = isempty(get(handles.S_m_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_N_motif == 0 % Si le nombre de motifs dans le rseau est pas connu
	N_motif_value = str2double(get(handles.N_motif,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
    N_motif_reseau = N_motif_value;
    set(handles.N_m_out,'String',N_motif_reseau); % Affiche le rsultat du nombre de motifs dans la ville
else
	if value_S_motif_out == 0 && value_S_reseau_out == 0 % Si les surfaces du rseau et du motif sont connues
        S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la surface du rseau en sortie
        S_motif_out_value = str2double(get(handles.S_m_out,'String')); % Rcupration de la valeur de la surface d'un motif en sortie
        N_motif_reseau = round(S_reseau_out_value / S_motif_out_value); % Calcul du nombre de motifs dans le rseau et conservation de la partie entire
        set(handles.N_m_out,'String',N_motif_reseau); % Affiche le rsultat du nombre de motifs dans la ville
	elseif value_S_cellule_out == 0 && value_T_motif == 0 && value_S_reseau_out == 0 % Si la surface d'une cellule, la surface du rseau et la taille d'un motif sont connues
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la surface du rseau en sortie
        S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule en sortie
        N_motif_reseau = round(S_reseau_out_value / (S_cellule_out_value * T_motif_value)) ; % Calcul du nombre de motifs dans le rseau et conservation de la partie entire
        set(handles.N_m_out,'String',N_motif_reseau); % Affiche le rsultat du nombre de motifs dans la ville
	end
end


% Nombre de lignes par cellule :

Type_reseau = get(handles.ChoixSysteme, 'UserData');
value_N = isempty(get(handles.N,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_P_pourcent = isempty(get(handles.P_pourcent,'String'));
value_Q_c = isempty(get(handles.Q_c,'String'));
Choix_Syst = get(handles.ChoixSysteme, 'Value'); % = 1 Si popmenu  l'tat initial


if value_N ==0 && Choix_Syst == 1 % Si le nombre de canaux est connu et le type de rseau non connu
	N_value = str2double(get(handles.N,'String')); % Rcupration de la valeur du nombre de canaux par cellule (en entre)
    N_canaux_cellule = N_value;
    set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
elseif value_N ==0 && Choix_Syst ~= 1 % Si le nombre de canaux et le type de rseau sont connus
	N_value = str2double(get(handles.N,'String')); % Rcupration de la valeur du nombre de canaux par cellule (en entre)
    if Type_reseau == 1 || Type_reseau == 2 % Si type de rseau AMPS ou NAMPS
        N_canaux_cellule = N_value; % Pas de multiplexage
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
    elseif Type_reseau == 3 % Si type de rseau = TDMA/DAMPS
        N_canaux_cellule = N_value * 3; % Multiplexage par 3
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
	elseif Type_reseau == 4 % Si type de rseau = GSM
        N_canaux_cellule = N_value * 8; % Multiplexage par 8
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
    elseif Type_reseau == 5 % Si type de rseau = CDMA
        N_canaux_cellule = N_value * 55; % Multiplexage par 55
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
    end
elseif value_N == 1 && value_P_pourcent == 0 && value_Q_c == 0 % Si le nombre de canaux n'est pas connu et la probabilit de blocage avec le trafic par cellule sont cunnus
	Q_c_value = str2double(get(handles.Q_c,'String')); % Rcupration de la valeur du trafic par cellule
    P_pourcent_value = str2double(get(handles.P_pourcent,'String')); % Rcupration de la valeur de la probabilit de blocage
    P_su = P_pourcent_value / 100;
    N = 0 : 1000;
        tab=[];
        sum2 = 0; % Initialisation du tableau
        i = 0;
        for k=0:1:1000
            i=i+1;
            sum2 = sum2 + (Q_c_value.^(k))./factorial(k); % Calcul de la somme
            tab(i)=sum2; % Rcupration de la valeur pour chaque itration
        end

        denominateur = tab; % Calcul du dnominateur

        numerateur= Q_c_value.^(N) ./ factorial(N); % Calcul du numrateur

        P_calcule = numerateur ./ denominateur; % Calcul de la probabilit de blocage

        diff = abs(P_calcule - P_su);

        indice=find(diff==min(diff)) ; % Rcupration de l'indice pour retrouver la valeur de N

        N_recherche = (indice-1); % Calcul du N recherch
        
        if Choix_Syst ~= 1  % Si le type de rseau est connu
            if Type_reseau == 1 || Type_reseau == 2 % Si type de rseau AMPS ou NAMPS
                N_canaux_cellule = N_recherche; % Pas de multiplexage
                set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
            elseif Type_reseau == 3 % Si type de rseau = TDMA/DAMPS
                N_canaux_cellule = N_recherche * 3; % Multiplexage par 3
                set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
            elseif Type_reseau == 4 % Si type de rseau = GSM
                N_canaux_cellule = N_recherche * 8; % Multiplexage par 8
                set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
            elseif Type_reseau == 5 % Si type de rseau = CDMA
                N_canaux_cellule = N_recherche * 55; % Multiplexage par 55
                set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
            end
        else
            N_canaux_cellule = N_recherche; % Pas de multiplexage
            set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
        end
end

% Calcul bande passante rseau : Si toujours inconnu
value_W_reseau = isempty(get(handles.W_reseau,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_out = isempty(get(handles.N_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
Choix_Syst = get(handles.ChoixSysteme, 'Value'); % = 1 Si popmenu  l'tat initial

if value_W_reseau == 1 % Si la bande passante du rseau n'est pas connue
    if value_N_out ==0 && value_T_motif ==0 && Choix_Syst ~= 1
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        N_out_value = str2double(get(handles.N_out,'String')); % Rcupration de la valeur du nombre de canaux par cellule
        W_reseau_Hz = W_canaux * N_out_value * T_motif_value; % Calcul de la bande passante du rseau en Hz
        W_reseau_MHz = W_reseau_Hz * 10^(-6); % Conversion Bande passante rseau en MHz
        set(handles.W_reseau_out,'String',W_reseau_MHz); % Affiche le rsultat de la bande passante du rseau en sortie
        set(handles.W_m_out,'String',W_reseau_MHz); % Affiche le rsultat de la bande passante du motif en sortie
    end
end
            

% Calcul de la bande passante d'une cellule :

value_W_reseau_out = isempty(get(handles.W_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_out = isempty(get(handles.N_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)


if value_W_reseau_out == 0 && value_T_motif == 0 % Si la bande passante du rseau et la taille des motifs sont connues
    W_reseau_out_value = str2double(get(handles.W_reseau_out,'String')); % Rcupration de la valeur de la bande passante de sortie du rseau
    T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
    W_cellule_MHz = W_reseau_out_value / T_motif_value; % Calcul de la bande passante d'une cellule
    set(handles.W_c_out,'String',W_cellule_MHz); % Affiche le rsultat de la bande passante d'une cellule en sortie
elseif value_N_out ==0 && Choix_Syst ~= 1 % Si le nombre de canaux et le type de rseau sont connus
        N_out_value = str2double(get(handles.N_out,'String')); % Rcupration de la valeur de la taille d'un motif
        if Type_reseau == 1 || Type_reseau == 2 % Si type de rseau AMPS ou NAMPS
            W_cellule_Hz = N_out_value  * W_canaux; % Calcul BP cellule, Pas de multiplexage
            W_cellule_MHz = W_cellule_Hz * 10^(-6); % Conversion BP en MHz
            set(handles.W_c_out,'String',W_cellule_MHz); % Affiche le rsultat de la bande passante d'une cellule en sortie
        elseif Type_reseau == 3 % Si type de rseau = TDMA/DAMPS
            W_cellule_Hz = (N_out_value / 3)  * W_canaux ; % Calcul BP cellule, Pas de multiplexage
            W_cellule_MHz = W_cellule_Hz * 10^(-6); % Conversion BP en MHz
            set(handles.W_c_out,'String',W_cellule_MHz); % Affiche le rsultat de la bande passante d'une cellule en sortie
        elseif Type_reseau == 4 % Si type de rseau = GSM
            W_cellule_Hz = (N_out_value / 8)  * W_canaux; % Calcul BP cellule, Pas de multiplexage
            W_cellule_MHz = W_cellule_Hz * 10^(-6); % Conversion BP en MHz
            set(handles.W_c_out,'String',W_cellule_MHz); % Affiche le rsultat de la bande passante d'une cellule en sortie
        elseif Type_reseau == 5 % Si type de rseau = CDMA
            W_cellule_Hz = (N_out_value /55) * W_canaux; % Calcul BP cellule, Pas de multiplexage
            W_cellule_MHz = W_cellule_Hz * 10^(-6); % Conversion BP en MHz
            set(handles.W_c_out,'String',W_cellule_MHz); % Affiche le rsultat de la bande passante d'une cellule en sortie
        end
end

% Calcul du nombre de canaux par cellule si toujours non connu :

value_W_c_out = isempty(get(handles.W_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_out = isempty(get(handles.N_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
Type_reseau = get(handles.ChoixSysteme, 'UserData');
Choix_Syst = get(handles.ChoixSysteme, 'Value'); % = 1 Si popmenu  l'tat initial

if value_N_out == 1 && value_W_c_out == 0 && Choix_Syst ~=1 % Si le nombre de canaux n'est pas connu et la bande passante d'une cellule et le type de rseau sont connus
	W_c_out_value = str2double(get(handles.W_c_out,'String')); % Rcupration de la valeur de la bande passante d'une cellule en sortie
    W_cellule_Hz = W_c_out_value * 10^(6); % Conversion BP de MHz  Hz
    if Type_reseau == 1 || Type_reseau == 2 % Si type de rseau AMPS ou NAMPS
        N_canaux_cellule = round (W_cellule_Hz / W_canaux); % Pas de multiplexage
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
    elseif Type_reseau == 3 % Si type de rseau = TDMA/DAMPS
        N_canaux_cellule = round ((W_cellule_Hz / W_canaux) * 3); % Multiplexage par 3
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
	elseif Type_reseau == 4 % Si type de rseau = GSM
        N_canaux_cellule = round ((W_cellule_Hz / W_canaux) * 8); % Multiplexage par 8
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
    elseif Type_reseau == 5 % Si type de rseau = CDMA
        N_canaux_cellule = round ((W_cellule_Hz / W_canaux) * 55); % Multiplexage par 55
        set(handles.N_out,'String',N_canaux_cellule); % Affiche le rsultat du nombre de canaux par cellule
    end
end

% Calcul du trafic par cellule (si toujours non connu) :

value_N_out = isempty(get(handles.N_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_P_pourcent = isempty(get(handles.P_pourcent,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_Q_c_out = isempty(get(handles.Q_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_Q_c_out == 1 && value_P_pourcent == 0 && value_N_out == 0 % Si le trafic par cellule est inconnu et la probabilit de blocage avec le nombre de lignes sont connus
    P_pourcent_value = str2double(get(handles.P_pourcent,'String')); % Rcupration de la valeur de la probabilit de blocage en %
    N_out_value = str2double(get(handles.N_out,'String')); % Rcupration du nombre de lignes par cellule en sortie
    P_su = P_pourcent_value / 100 ; % Probabilit de blocage sans unit

    sum1 = 0; % Initialisation de la somme
    Q_E = 0 : 0.001 : 250 ; % Cration d'un tableau avec les valeurs possibles de Q
    
    for i = 0 : N_out_value
        sum1 = sum1 + Q_E.^(i)./factorial(i) ; % Calcul de la somme (Dnominateur de la formule d'Erlang B)
    end
    denominateur = sum1; % Calcul du dnominateur
    numerateur = Q_E.^(N_out_value) ./ factorial(N_out_value); % Calcul du numrateur
    P_calcule = numerateur ./ denominateur; % Calcul de P pour chaque valeur de Q
    
    diff = abs(P_calcule - P_su);
    indice=find(diff==min(diff)) ; % Rcupration de l'indice pour retrouver la valeur de Q
    Q_recherche = (indice-1)*0.001; % Calcul du Q recherch
    
    set(handles.Q_c_out,'String',Q_recherche); % Affiche le rsultat du trafic en Erlang
end

% Calcul du nombre de cellules dans le rseau :

value_S_reseau_out = isempty(get(handles.S_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_m_out = isempty(get(handles.N_m_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_cellule_out = isempty(get(handles.S_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_cellules_reseau_out = isempty(get(handles.N_cellules_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_W_reseau_out = isempty(get(handles.W_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_W_c_out = isempty(get(handles.W_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_N_cellules_reseau_out == 1 % Si le nombre de cellules dans le rseau n'est pas connu
    if value_S_reseau_out == 0 && value_S_cellule_out == 0 % Si les surfaces du rseau et d'une cellule sont connues
        S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la surface du rseau
        S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule
        N_cellules_reseau = round (S_reseau_out_value / S_cellule_out_value) ; % Calcul du nombre de cellules dans le rseau
        set(handles.N_cellules_reseau_out,'String',N_cellules_reseau); % Affiche le rsultat du nombre de cellules dans le rseau
    elseif value_S_cellule_out == 0 && value_T_motif == 0 && value_N_m_out == 0 % Si la surface d'une cellule,la taille d'un motif et le nombre de motifs dans le rseau sont connus
        T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
        N_m_out_value = str2double(get(handles.N_m_out,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
        S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule
        N_cellules_reseau = round (S_cellule_out_value * N_m_out_value * T_motif_value) ; % Calcul du nombre de cellules dans le rseau
        set(handles.N_cellules_reseau_out,'String',N_cellules_reseau); % Affiche le rsultat du nombre de cellules dans le rseau
    elseif value_W_reseau_out == 0 && value_N_m_out == 0 && value_W_c_out == 0 % Si les bandes passantes du rseau et d'une cellule et le nombre de motifs dans le rseau sont connus
        N_m_out_value = str2double(get(handles.N_m_out,'String')); % Rcupration de la valeur du nombre de motifs dans le rseau
        W_reseau_out_value = str2double(get(handles.W_reseau_out,'String')); % Rcupration de la valeur de la bande passante du rseau (et donc d'un motif)
        W_c_out_value = str2double(get(handles.W_c_out,'String')); % Rcupration de la valeur de la bande passante d'une cellule
        N_cellules_reseau = round ((W_reseau_out_value / W_c_out_value) * N_m_out_value) ; % Calcul du nombre de cellules dans le rseau
        set(handles.N_cellules_reseau_out,'String',N_cellules_reseau); % Affiche le rsultat du nombre de cellules dans le rseau
    end
end

% Calcul de la surface d'une cellule si toujours non connue :

value_S_reseau_out = isempty(get(handles.S_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_cellules_reseau_out = isempty(get(handles.N_cellules_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_cellule_out = isempty(get(handles.S_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_S_cellule_out == 1 % Si la surface d'une cellule est toujours non connue
    if value_S_reseau_out == 0 && value_N_cellules_reseau_out == 0 % Si la surface du rseau et le nombre de cellules dans le rseau sont connus
    	S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la surface du rseau
    	N_cellules_reseau_out_value = str2double(get(handles.N_cellules_reseau_out,'String')); % Rcupration de la valeur du nombre de cellules dans le rseau
        S_cellule_km2 = S_reseau_out_value / N_cellules_reseau_out_value ; % Calcul de la surface d'une cellule
        set(handles.S_c_out,'String',S_cellule_km2); % Affiche le rsultat de la surface d'une cellule
    end
end

% Calcul du nombre de canaux par motif :

value_S_m_out = isempty(get(handles.S_m_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_T_motif = isempty(get(handles.T_motif,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_cellule_out = isempty(get(handles.S_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_W_reseau_out = isempty(get(handles.W_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_W_c_out = isempty(get(handles.W_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_out = isempty(get(handles.N_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_T_motif == 0 && value_N_out == 0 % Si la taille d'un motif et le nombre de lignes par cellule sont connus
    T_motif_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur de la taille d'un motif
    N_out_value = str2double(get(handles.N_out,'String')); % Rcupration de la valeur du nombre de lignes par cellule
    N_canaux_motif = round (N_out_value * T_motif_value) ; % Calcul du nombre de canaux par motif
    set(handles.N_canaux_m_out,'String',N_canaux_motif); % Affiche le rsultat du nombre de canaux par motif
          
elseif value_S_m_out == 0 && value_S_cellule_out == 0 && value_N_out == 0 % Si les surfaces du motif et d'une cellule et le nombre de lignes par cellule sont connus
        S_m_out_value = str2double(get(handles.S_m_out,'String')); % Rcupration de la valeur de la surface d'un motif
        N_out_value = str2double(get(handles.N_out,'String')); % Rcupration de la valeur du nombre de lignes par cellule
        S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule
        N_canaux_motif = round (N_out_value * (S_m_out_value / S_cellule_out_value)) ; % Calcul du nombre de canaux par motif
        set(handles.N_canaux_m_out,'String',N_canaux_motif); % Affiche le rsultat du nombre de canaux par motif

elseif value_N_out == 0 && value_W_reseau_out == 0 && value_W_c_out == 0 % Si les BP d'un motif et d'une cellule et le nombre de lignes par cellule sont connus
    W_reseau_out_value = str2double(get(handles.W_reseau_out,'String')); % Rcupration de la valeur de la BP d'un motif
    N_out_value = str2double(get(handles.N_out,'String')); % Rcupration de la valeur du nombre de lignes par cellule
    W_c_out_value = str2double(get(handles.W_c_out,'String')); % Rcupration de la valeur de la BP d'une cellule
    N_canaux_motif = round (N_out_value * (W_reseau_out_value / W_c_out_value)) ; % Calcul du nombre de canaux par motif
    set(handles.N_canaux_m_out,'String',N_canaux_motif); % Affiche le rsultat du nombre de canaux par motif        
end


% Calcul du nombre d'appels moyen par heure et par cellule :

value_C_appel_h = isempty(get(handles.C,'String'));
value_Q_c_out = isempty(get(handles.Q_c_out,'String'));
value_T_su = isempty(get(handles.T,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
Unite_T = get(handles.Choix_Unite_T, 'UserData');

if value_C_appel_h == 0 % Si le nombre moyen d'appels par heure et par cellule a t renseign
	C_appel_h_value = str2double(get(handles.C,'String')); % Rcupration de la valeur du nombre d'appels moyen par heure
    C_appel_h_out = C_appel_h_value;
    set(handles.C_out,'String',C_appel_h_out); % Affiche le rsultat du trafic en Erlang en sortie
else
    if value_Q_c_out == 0 && value_T_su == 0 % Si le trafic par cellule et la dure moyenne d'un appel sont connus
        Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
        if Unite_T == 1
        	C_appel_h_out = round (Q_c_out_value / (T_h)); % Calcul du nombre d'appels par heure moyen et par cellule
            set(handles.C_out,'String',C_appel_h_out); % Affiche le rsultat du trafic en Erlang en sortie
        elseif Unite_T == 2
            C_appel_h_out = round (Q_c_out_value / (T_h)); % Calcul du nombre d'appels par heure moyen et par cellule
            set(handles.C_out,'String',C_appel_h_out); % Affiche le rsultat du trafic en Erlang en sortie
        elseif Unite_T == 3
            C_appel_h_out = round (Q_c_out_value / (T_h)); % Calcul du nombre d'appels par heure moyen et par cellule et conservation de la partie entire
            set(handles.C_out,'String',C_appel_h_out); % Affiche le rsultat du nombre d'appels par heure moyen et par cellule
        else
            errordlg('Choisissez l''unit de la dure d''un appel','File Error');
        end
    end
end

% Calcul du nombre d'appels moyen par heure dans le rseau :

value_C_out = isempty(get(handles.C_out,'String'));
value_N_cellules_reseau_out = isempty(get(handles.N_cellules_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_C_out == 0 && value_N_cellules_reseau_out == 0 % Si le nombre d'appels par heure et par cellule et le nombre de cellules dans le rseau sont connus
	C_out_value = str2double(get(handles.C_out,'String')); % Rcupration de la valeur du nombre d'appels par heure et par cellule
	N_cellules_reseau_out_value = str2double(get(handles.N_cellules_reseau_out,'String')); % Rcupration de la valeur du nombre de cellules dans le rseau
	C_appel_h_reseau_out = C_out_value * N_cellules_reseau_out_value; % Calcul du nombre d'appels par heure moyen dans le rseau
	set(handles.C_reseau_out,'String',C_appel_h_reseau_out); % Affiche le rsultat du nombre d'appels par heure moyen dans le rseau
end

% Calcul de la capacit d'une cellule :

value_Q_c_out = isempty(get(handles.Q_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_cellule_out = isempty(get(handles.S_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_W_c_out = isempty(get(handles.W_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
    
    % Capacit : E/MHz
    
if value_W_c_out == 0 && value_Q_c_out == 0 % Si la BP d'une cellule et le trafic par cellule sont connus
    Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
    W_c_out_value = str2double(get(handles.W_c_out,'String')); % Rcupration de la valeur de la bande passante d'une cellule
    Q_c_E_MHz = Q_c_out_value / W_c_out_value; % Capacit E/MHz
    set(handles.Q_c_E_MHz_out,'String',Q_c_E_MHz); % Affiche le rsultat de la capacit d'une cellule en E/MHz
end

    % Capacit : E/km2
    
if value_S_cellule_out == 0 && value_Q_c_out == 0 % Si la surface d'une cellule et le trafic par cellule sont connus
    Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
    S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule
    Q_c_E_km2 = Q_c_out_value / S_cellule_out_value; % Capacit E/km2
    set(handles.Q_c_E_km2_out,'String',Q_c_E_km2); % Affiche le rsultat de la capacit d'une cellule en E/km2
end

    % Capacit : E/MHz/km2
    
if value_W_c_out == 0 && value_S_cellule_out == 0 && value_Q_c_out == 0 % Si la BP et la surface d'une cellule et le trafic par cellule sont connus
    Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
    W_c_out_value = str2double(get(handles.W_c_out,'String')); % Rcupration de la valeur de la bande passante d'une cellule
    S_cellule_out_value = str2double(get(handles.S_c_out,'String')); % Rcupration de la valeur de la surface d'une cellule
    Q_c_E_MHz_km2 = Q_c_out_value / (W_c_out_value*S_cellule_out_value); % Capacit E/MHz/km2
    set(handles.Q_c_E_MHz_km2_out,'String',Q_c_E_MHz_km2); % Affiche le rsultat de la capacit d'une cellule en E/MHz/km2
end


% Calcul du nombre d'abonns par cellule :

value_Q_c_out = isempty(get(handles.Q_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_Q_abonne = isempty(get(handles.Q_abonne,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_Q_abonne == 0 && value_Q_c_out == 0 % Si le trafic par abonn et le trafic par cellule sont connus
    Q_abonne_value = str2double(get(handles.Q_abonne,'String')); % Rcupration de la valeur du trafic par abonn
    Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
    N_abonne_cellule = round (Q_c_out_value / Q_abonne_value); % Calcul du nombre d'abonns par cellule et rcupration de sa partie entire uniquement
    set(handles.N_abonne_c_out,'String',N_abonne_cellule); % Affiche le rsultat du nombre d'abonns par cellule
end

% Calcul du trafic total :

value_Q_c_out = isempty(get(handles.Q_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_cellules_reseau_out = isempty(get(handles.N_cellules_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_Q_c_out == 0 && value_N_cellules_reseau_out == 0 % Si le trafic par cellule et le nombre de cellules dans le rseau sont connus
	Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
	N_cellules_reseau_out_value = str2double(get(handles.N_cellules_reseau_out,'String')); % Rcupration de la valeur du nombre de cellules dans le rseau
    Q_tot = Q_c_out_value * N_cellules_reseau_out_value; % Calcul du trafic total
    set(handles.Q_reseau_E_out,'String',Q_tot); % Affiche le rsultat du trafic total en Erlangs
end

% Calcul de la capacit totale :

value_Q_reseau_E_out = isempty(get(handles.Q_reseau_E_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_S_reseau_out = isempty(get(handles.S_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_W_reseau_out = isempty(get(handles.W_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
    
    % Capacit : E/MHz
    
if value_W_reseau_out == 0 && value_Q_reseau_E_out == 0 % Si la BP du rseau et le trafic total sont connus
    Q_reseau_E_out_value = str2double(get(handles.Q_reseau_E_out,'String')); % Rcupration de la valeur du trafic total
    W_reseau_out_value = str2double(get(handles.W_reseau_out,'String')); % Rcupration de la valeur de la bande passante du rseau (et donc d'un motif)
    Q_tot_E_MHz = Q_reseau_E_out_value / W_reseau_out_value; % Capacit totale E/MHz
    set(handles.Q_reseau_E_MHz_out,'String',Q_tot_E_MHz); % Affiche le rsultat de la capacit totale en E/MHz
end

    % Capacit : E/km2
    
if value_S_reseau_out == 0 && value_Q_reseau_E_out == 0 % Si la surface du rseau et le trafic total sont connus
    Q_reseau_E_out_value = str2double(get(handles.Q_reseau_E_out,'String')); % Rcupration de la valeur du trafic total
    S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la surface du rseau
    Q_tot_E_km2 = Q_reseau_E_out_value / S_reseau_out_value; % Capacit totale E/km2
    set(handles.Q_reseau_E_km2_out,'String',Q_tot_E_km2); % Affiche le rsultat de la capacit totale en E/km2
end

    % Capacit : E/MHz/km2
    
if value_W_reseau_out == 0 && value_S_reseau_out == 0 && value_Q_reseau_E_out == 0 % Si la BP et la surface du rseau et le trafic total sont connus
    Q_reseau_E_out_value = str2double(get(handles.Q_reseau_E_out,'String')); % Rcupration de la valeur du trafic total
    W_reseau_out_value = str2double(get(handles.W_reseau_out,'String')); % Rcupration de la valeur de la bande passante du rseau (et donc d'un motif)
    S_reseau_out_value = str2double(get(handles.S_out,'String')); % Rcupration de la valeur de la surface du rseau
    Q_tot_E_MHz_km2 = Q_reseau_E_out_value / (W_reseau_out_value * S_reseau_out_value); % Capacit totale E/MHz/km2
    set(handles.Q_reseau_E_MHz_km2_out,'String',Q_tot_E_MHz_km2); % Affiche le rsultat de la capacit totale en E/MHz/km2
end


% Calcul du nombre d'abonns total (dans le rseau) :

value_Q_c_out = isempty(get(handles.Q_c_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_Q_abonne = isempty(get(handles.Q_abonne,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)
value_N_cellules_reseau_out = isempty(get(handles.N_cellules_reseau_out,'String')); % Valeur = 1 (cellule vide) ou 0 (cellule non vide)

if value_Q_abonne == 0 && value_Q_c_out == 0 && value_N_cellules_reseau_out == 0 % Si le trafic par abonn et le trafic par cellule et le nombre de cellules dans le rseau sont connus
    Q_abonne_value = str2double(get(handles.Q_abonne,'String')); % Rcupration de la valeur du trafic par abonn
    Q_c_out_value = str2double(get(handles.Q_c_out,'String')); % Rcupration de la valeur du trafic par cellule
    N_cellules_reseau_out_value = str2double(get(handles.N_cellules_reseau_out,'String')); % Rcupration de la valeur du nombre de cellules dans le rseau
    N_abonne_reseau = round ((Q_c_out_value / Q_abonne_value) * N_cellules_reseau_out_value ); % Calcul du nombre d'abonns total et rcupration de sa partie entire uniquement
    set(handles.N_abonne_out,'String',N_abonne_reseau); % Affiche le rsultat du nombre d'abonns total
end

% Vrification de la valeur du nombre de cellules par motif (Acceptable ou non) :

value_T_motif = isempty(get(handles.T_motif,'String')); % Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :


if value_T_motif == 0 % Si le nombre de cellules par motif est connu
    T_m_value = str2double(get(handles.T_motif,'String')); % Rcupration de la valeur du nombre de cellules par motif
    
    if T_m_value == 1
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 3
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 4
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 7
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 9 
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 12 
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 13 
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 16 
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 19
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 21 
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 28 
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif T_m_value == 29
        set(handles.Accept_N,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    else
        set(handles.Accept_N,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % N non acceptable   
    end
end


% Vrification si la distance entre deux cellules utilisant la mme frquence est acceptable ou non :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_D_min_km = isempty(get(handles.D_min_km_out,'String'));
value_D_km = isempty(get(handles.D_km,'String'));


if value_D_km == 0 && value_D_min_km ==0 % Si la distance et la distance min entre cellules de mme frquence sont connues
    
    D_min_km = str2double(get(handles.D_min_km_out,'String')); % Rcupration de la valeur de la distance min entre cellules de mme frquence
    D_km = str2double(get(handles.D_km,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
    
    if D_km < D_min_km
        set(handles.Accept_D,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % D non acceptable      
    else
        set(handles.Accept_D,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % D acceptable
    end
end


% Vrification si le rapport C/I est acceptable ou non :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_CI_seuil_dB = isempty(get(handles.C_I_seuil_dB,'String'));
value_CI_dB = isempty(get(handles.C_I_dB_out,'String'));


if value_CI_dB == 0 && value_CI_seuil_dB ==0 % Si l'interfrence co-canal et l'interfrence co-canal minimale sont connues
    
    CI_seuil_dB = str2double(get(handles.C_I_seuil_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal minimale
    CI_dB = str2double(get(handles.C_I_dB_out,'String')); % Rcupration de la valeur de l'interfrence co-canal
    
    if CI_dB < CI_seuil_dB
        set(handles.Accept_C_I,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % C/I non acceptable      
    else
        set(handles.Accept_C_I,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % C/I acceptable
    end
end



% --- Executes on button press in Effacer.
function Effacer_Callback(hObject, eventdata, handles)
% hObject    handle to Effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entre :

set(handles.S_reseau, 'String', ''); % Efface la valeur de la surface du rseau d'entre
set(handles.W_reseau, 'String', ''); % Efface la valeur de la bande passante du rseau
set(handles.N_motif, 'String', ''); % Efface la valeur du nombre de motifs dans le rseau
set(handles.T_motif, 'String', ''); % Efface la valeur du nombre de cellules par motif
set(handles.S_cellule, 'String', ''); % Efface la valeur de la surface d'une cellule
set(handles.R_cellule, 'String', ''); % Efface la valeur du rayon d'une cellule
set(handles.ChoixSysteme, 'Value', 1); % Remet le popumenu "Choix systme"  l'tat initial
set(handles.Choix_Unite_T, 'Value', 1); % Remet le popumenu "Choix unit"  l'tat initial
set(handles.N, 'String', ''); % Efface la valeur du nombre de canaux par cellule
set(handles.P_pourcent, 'String', ''); % Efface la valeur de la probabilit de blocage
set(handles.Q_c, 'String', ''); % Efface la valeur du trafic par cellule
set(handles.C, 'String', ''); % Efface la valeur du nombre moyen d'appels par heure
set(handles.T, 'String', ''); % Efface la valeur de la dure moyenne par heure d'une communication
set(handles.C_I_seuil_dB, 'String', ''); % Efface la valeur du rapport d'interfrence co-canal dsir en dB
set(handles.D_km, 'String', ''); % Efface la valeur de la distance entre cellules de mme frquence
set(handles.Q_abonne, 'String', ''); % Efface la valeur du trafic par abonn


% Effacer les valeurs de sortie :

set(handles.S_out, 'String', ''); % Efface la valeur de la surface du rseau
set(handles.W_reseau_out, 'String', ''); % Efface la valeur de la bande passante du rseau
set(handles.Q_reseau_E_out, 'String', ''); % Efface la valeur du trafic du rseau en E
set(handles.Q_reseau_E_MHz_out, 'String', ''); % Efface la valeur du trafic du rseau en E/MHz
set(handles.Q_reseau_E_km2_out, 'String', ''); % Efface la valeur du trafic du rseau en E/km2
set(handles.Q_reseau_E_MHz_km2_out, 'String', ''); % Efface la valeur du trafic du rseau en E/MHz/km2
set(handles.C_reseau_out, 'String', ''); % Efface la valeur du nombre d'appels par heure dans le rseau
set(handles.N_abonne_out, 'String', ''); % Efface la valeur du nombre d'abonns dans le rseau
set(handles.N_cellules_reseau_out, 'String', ''); % Efface la valeur du nombre de cellules dans le rseau
set(handles.S_m_out, 'String', ''); % Efface la valeur de la surface du motif
set(handles.W_m_out, 'String', ''); % Efface la valeur de la bande passante du motif
set(handles.N_m_out, 'String', ''); % Efface la valeur du nombre de motifs dans le rseau
set(handles.N_canaux_m_out, 'String', ''); % Efface la valeur du nombre de canaux par motif
set(handles.S_c_out, 'String', ''); % Efface la valeur de la surface d'une cellule
set(handles.W_c_out, 'String', ''); % Efface la valeur de la bande passante d'une cellule
set(handles.D_min_km_out, 'String', ''); % Efface la valeur de la distance minimale entre cellules de mme frquence
set(handles.Accept_D, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' distance entre cellules de mme frquence
set(handles.Accept_C_I, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' rapport interfrence co-canal
set(handles.Accept_N, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' taille motif
set(handles.C_I_dB_out, 'String', ''); % Efface la valeur du rapport d'interfrence co-canal en dB
set(handles.N_out, 'String', ''); % Efface la valeur du nombre de canaux par cellule
set(handles.Q_c_out, 'String', ''); % Efface la valeur du trafic par cellule en E
set(handles.Q_c_E_MHz_out, 'String', ''); % Efface la valeur du trafic par cellule en E/MHz
set(handles.Q_c_E_km2_out, 'String', ''); % Efface la valeur du trafic par cellule en E/km2
set(handles.Q_c_E_MHz_km2_out, 'String', ''); % Efface la valeur du trafic par cellule en E/MHz/km2
set(handles.C_out, 'String', ''); % Efface la valeur du nombre d'appels par heure par cellule
set(handles.N_abonne_c_out, 'String', ''); % Efface la valeur du nombre d'abonns par cellule



% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all;


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal
close Dimensionnement_reseau_cellulaire
