function varargout = Dim_DistanceMin_Ncellules(varargin)
% Liaisons_fixes MATLAB code for Liaisons_fixes.fig
%      Liste des programmes :
%           - Premire interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilit
%           - Temprature et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des rseaux cellulaires
%           - Dbit maximal 
%      Liaisons_fixes, by itself, creates a new Dim_DistanceMin_Ncellules or raises the existing
%      singleton*.
%
%      H = Liaisons_fixes returns the handle to a new Dim_DistanceMin_Ncellules or the handle to
%      the existing singleton*.
%
%      Dim_DistanceMin_Ncellules('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Liaisons_fixes.M with the given input arguments.
%
%      Dim_DistanceMin_Ncellules('Property','Value',...) creates a new Liaisons_fixes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Dim_DistanceMin_Ncellules_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Liaisons_fixes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Dim_DistanceMin_Ncellules
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 05-Apr-2019 23:33:26

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Dim_DistanceMin_Ncellules_OpeningFcn, ...
                   'gui_OutputFcn',  @Dim_DistanceMin_Ncellules_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Dim_DistanceMin_Ncellules is made visible.
function Dim_DistanceMin_Ncellules_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Dim_DistanceMin_Ncellules (see VARARGIN)

% Choose default command line output for Dim_DistanceMin_Ncellules
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

imshow('Dim_Reseau_Cell.png','Parent', handles.image_Dim_reseau_Cell, 'InitialMagnification','fit')




% UIWAIT makes Dim_DistanceMin_Ncellules wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Dim_DistanceMin_Ncellules_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% 1er sous-programme : Calcul du trafic

function R_c_Callback(hObject, eventdata, handles)
% hObject    handle to R_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of R_c as text
%        str2double(get(hObject,'String')) returns contents of R_c as a double


% --- Executes during object creation, after setting all properties.
function R_c_CreateFcn(hObject, eventdata, handles)
% hObject    handle to R_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function S_c_Callback(hObject, eventdata, handles)
% hObject    handle to S_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_c as text
%        str2double(get(hObject,'String')) returns contents of S_c as a double


% --- Executes during object creation, after setting all properties.
function S_c_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_c_Callback(hObject, eventdata, handles)
% hObject    handle to N_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_c as text
%        str2double(get(hObject,'String')) returns contents of N_c as a double


% --- Executes during object creation, after setting all properties.
function N_c_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_c (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function D_min_Callback(hObject, eventdata, handles)
% hObject    handle to D_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of D_min as text
%        str2double(get(hObject,'String')) returns contents of D_min as a double


% --- Executes during object creation, after setting all properties.
function D_min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to D_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function D_Callback(hObject, eventdata, handles)
% hObject    handle to D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of D as text
%        str2double(get(hObject,'String')) returns contents of D as a double


% --- Executes during object creation, after setting all properties.
function D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_I_dB_Callback(hObject, eventdata, handles)
% hObject    handle to C_I_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_I_dB as text
%        str2double(get(hObject,'String')) returns contents of C_I_dB as a double


% --- Executes during object creation, after setting all properties.
function C_I_dB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_I_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_N_cellule_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_N_cellule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_N_cellule as text
%        str2double(get(hObject,'String')) returns contents of Accept_N_cellule as a double


% --- Executes during object creation, after setting all properties.
function Accept_N_cellule_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_N_cellule (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function C_I_min_dB_Callback(hObject, eventdata, handles)
% hObject    handle to C_I_min_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of C_I_min_dB as text
%        str2double(get(hObject,'String')) returns contents of C_I_min_dB as a double


% --- Executes during object creation, after setting all properties.
function C_I_min_dB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to C_I_min_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_C_I_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_C_I (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_C_I as text
%        str2double(get(hObject,'String')) returns contents of Accept_C_I as a double


% --- Executes during object creation, after setting all properties.
function Accept_C_I_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_C_I (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Accept_D_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_D as text
%        str2double(get(hObject,'String')) returns contents of Accept_D as a double


% --- Executes during object creation, after setting all properties.
function Accept_D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% Calcul du rayon d'une cellule :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_S_c_km2 = isempty(get(handles.S_c,'String'));
value_R_c_km = isempty(get(handles.R_c,'String'));
value_D_min_km = isempty(get(handles.D_min,'String'));
value_D_km = isempty(get(handles.D,'String'));
value_N_cell = isempty(get(handles.N_c,'String'));
value_CI_dB = isempty(get(handles.C_I_dB,'String'));
value_CI_min_dB = isempty(get(handles.C_I_min_dB,'String'));

if value_R_c_km == 1 % Si le rayon d'une cellule est non renseign
    if value_S_c_km2 == 0 % Si la surface est renseigne
        S_c_km2 = str2double(get(handles.S_c,'String')); % Rcupration de la valeur de la surface d'une cellule
        R_km = (S_c_km2 / pi )^(1/2); % Calcul du rayon d'une cellule
        set(handles.R_c,'String',R_km); % Affiche le rsultat du rayon d'une cellule

    elseif value_D_km ==0 && value_N_cell ==0 % Si la distance entre cellules de mm freq et le nombre de cellules/motif sont connus
        D_km = str2double(get(handles.D,'String')); % Rcupration de la valeur de la distance entre deux cellules de mme frquence    
        N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif    
        R_km = D_km / ((N_cell)^(1/2)); % Calcul du rayon d'une cellule
        set(handles.R_c,'String',R_km); % Affiche le rsultat du rayon d'une cellule 

    elseif value_D_km ==0 && value_CI_dB ==0 % Si le rayon est non renseign et la distance entre cellules de mm freq et l'interfrence co-canal connues
        D_km = str2double(get(handles.D,'String')); % Rcupration de la valeur de la distance entre deux cellules de mme frquence    
        CI_dB = str2double(get(handles.C_I_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal en dB    
        CI_su = 10^(CI_dB/10); % Conversion C/I en linaire
        R_km = D_km / ((CI_su)^(1/3.52)); % Calcul du rayon d'une cellule
        set(handles.R_c,'String',R_km); % Affiche le rsultat du rayon d'une cellule

	elseif value_D_min_km ==0 && value_CI_min_dB ==0 % Si le rayon est non renseign et la distance min entre cellules de mm freq et l'interfrence co-canal min connues
        D_min_km = str2double(get(handles.D_min,'String')); % Rcupration de la valeur de la distance min entre deux cellules de mme frquence    
        CI_min_dB = str2double(get(handles.C_I_min_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal min en dB    
        CI_min_su = 10^(CI_min_dB/10); % Conversion C/I en linaire
        R_km = D_min_km / ((CI_min_su)^(1/3.52)); % Calcul du rayon d'une cellule
        set(handles.R_c,'String',R_km); % Affiche le rsultat du rayon d'une cellule
        
    elseif value_D_min_km ==0 && value_N_cell ==0 % Si le rayon est non renseign et la distance min entre cellules de mm freq et le nombre de cellules/motif sont connus
        D_min_km = str2double(get(handles.D_min,'String')); % Rcupration de la valeur de la distance entre deux cellules de mme frquence    
        N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif    
        R_km = D_min_km / ((N_cell)^(1/2)); % Calcul du rayon d'une cellule
        set(handles.R_c,'String',R_km); % Affiche le rsultat du rayon d'une cellule
    end
end


% Calcul de l'interfrence co-canal :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_R_c_km = isempty(get(handles.R_c,'String'));
value_D_km = isempty(get(handles.D,'String'));
value_N_cell = isempty(get(handles.N_c,'String'));
value_CI_dB = isempty(get(handles.C_I_dB,'String'));

if value_CI_dB == 1 % Si l'interfrence co-canal n'est pas connue
	if value_N_cell == 0 % Si le nombre de cellules par motif est renseign
        N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif 
        CI_su = (3 * N_cell)^(3.52/2) ; % Calcul de l'interfrence co-canal sans unit
        CI_dB = 10*log10(CI_su); % Conversion en dB
        set(handles.C_I_dB,'String',CI_dB); % Affiche le rsultat de l'interfrence co-canal en dB

	elseif value_D_km ==0 && value_R_c_km ==0 % Si le rayon et la distance entre cellules de mme frquence sont renseigns
        D_km = str2double(get(handles.D,'String')); % Rcupration de la valeur de la distance entre deux cellules de mme frquence    
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        CI_su = (D_km/R_c_km)^(3.52) ; % Calcul de l'interfrence co-canal sans unit
        CI_dB = 10*log10(CI_su); % Conversion en dB
        set(handles.C_I_dB,'String',CI_dB); % Affiche le rsultat de l'interfrence co-canal en dB
	end
end



% Calcul de l'interfrence co-canal minimale :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_R_c_km = isempty(get(handles.R_c,'String'));
value_D_min_km = isempty(get(handles.D_min,'String'));
value_N_cell = isempty(get(handles.N_c,'String'));
value_CI_min_dB = isempty(get(handles.C_I_min_dB,'String'));

if value_CI_min_dB == 1 % Si l'interfrence co-canal minimale n'est pas connue
	if value_N_cell == 0 % Si le nombre de cellules par motif est renseign
        N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif 
        CI_min_su = (3 * N_cell)^(3.52/2) ; % Calcul de l'interfrence co-canal minimale sans unit
        CI_min_dB = 10*log10(CI_min_su); % Conversion en dB
        set(handles.C_I_min_dB,'String',CI_min_dB); % Affiche le rsultat de l'interfrence co-canal min en dB

	elseif value_D_min_km ==0 && value_R_c_km ==0 % Si le rayon et la distance min entre cellules de mme frquence sont renseigns
        D_min_km = str2double(get(handles.D_min,'String')); % Rcupration de la valeur de la distance min entre deux cellules de mme frquence    
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        CI_min_su = (D_min_km/R_c_km)^(3.52) ; % Calcul de l'interfrence co-canal min sans unit
        CI_min_dB = 10*log10(CI_min_su); % Conversion en dB
        set(handles.C_I_min_dB,'String',CI_min_dB); % Affiche le rsultat de l'interfrence co-canal min en dB
	end
end

% Calcul de la distance entre cellules de mme frquence :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_N_cell = isempty(get(handles.N_c,'String'));
value_R_c_km = isempty(get(handles.R_c,'String'));
value_D_km = isempty(get(handles.D,'String'));
value_CI_dB = isempty(get(handles.C_I_dB,'String'));

if value_D_km == 1 % Si la distance n'est pas connue
	if value_CI_dB == 0 && value_R_c_km ==0 % Si l'interfrence co-canal et le rayon d'une cellule sont connus
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        CI_dB = str2double(get(handles.C_I_dB,'String')); % Rcupration de l'interfrence co-canal en dB    
        CI_su = 10^(CI_dB/10); % Conversion C/I en linaire
        D_km = R_c_km * ((CI_su)^(1/3.52)); % Calcul du rayon d'une cellule
        set(handles.D,'String',D_km); % Affiche le rsultat de la distance
        
	elseif value_R_c_km ==0 && value_N_cell == 0 % Si le rayon d'une cellule et le nombre de cellules/motif sont connus 
        N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        D_km = sqrt ( 3 * N_cell) * R_c_km ; % Calcul de la distance entre cellules de mme frquence
        set(handles.D,'String',D_km); % Affiche le rsultat de la distance
	end
end




% Calcul du nombre de cellules par motif :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_R_c_km = isempty(get(handles.R_c,'String'));
value_D_min_km = isempty(get(handles.D_min,'String'));
value_D_km = isempty(get(handles.D,'String'));
value_N_cell = isempty(get(handles.N_c,'String'));
value_CI_dB = isempty(get(handles.C_I_dB,'String'));
value_CI_min_dB = isempty(get(handles.C_I_min_dB,'String'));

if value_N_cell == 1 % Si le nombre de cellules par motif n'est pas renseign
    if value_D_km ==0 && value_R_c_km ==0 % Si la distance entre cellules de mm freq et le rayon d'une cellule sont connus
        D_km = str2double(get(handles.D,'String')); % Rcupration de la valeur de la distance entre deux cellules de mme frquence    
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        N_cell = (1/3) * ((D_km / R_c_km )^2) ; % Calcul du nombre de cellules par motif
        set(handles.N_c,'String',N_cell); % Affiche le rsultat du nombre de cellules par motif 

    elseif value_D_min_km ==0 && value_R_c_km ==0 % Si la distance min entre cellules de mm freq et le rayon d'une cellule sont connus
        D_min_km = str2double(get(handles.D_min,'String')); % Rcupration de la valeur de la distance min entre deux cellules de mme frquence    
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        N_cell = (1/3) * ((D_min_km / R_c_km )^2) ; % Calcul du nombre de cellules par motif
        set(handles.N_c,'String',N_cell); % Affiche le rsultat du nombre de cellules par motif
        
    elseif value_CI_dB ==0 % Si l'interfrence co-canal est connue
        CI_dB = str2double(get(handles.C_I_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal en dB    
        CI_su = 10^(CI_dB/10); % Conversion C/I en linaire
        N_cell = (1/3) * ((CI_su)^(2/3.52)); % Calcul du nombre de cellules par motif
        set(handles.N_c,'String',N_cell); % Affiche le rsultat du nombre de cellules par motif
    
    elseif value_CI_min_dB ==0 % Si l'interfrence co-canal minimale est connue
        CI_min_dB = str2double(get(handles.C_I_min_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal minimale en dB    
        CI_min_su = 10^(CI_min_dB/10); % Conversion C/I en linaire
        N_cell = (1/3) * ((CI_min_su)^(2/3.52)); % Calcul du nombre de cellules par motif
        set(handles.N_c,'String',N_cell); % Affiche le rsultat du nombre de cellules par motif
    end
end



% Calcul de la distance minimale entre cellules de mme frquence :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_N_cell = isempty(get(handles.N_c,'String'));
value_R_c_km = isempty(get(handles.R_c,'String'));
value_D_min_km = isempty(get(handles.D_min,'String'));
value_CI_min_dB = isempty(get(handles.C_I_min_dB,'String'));

if value_D_min_km == 1 % Si la distance min n'est pas connue
	if value_CI_min_dB == 0 && value_R_c_km ==0 % Si l'interfrence co-canal minimale et le rayon d'une cellule sont connus
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        CI_min_dB = str2double(get(handles.C_I_min_dB,'String')); % Rcupration de l'interfrence minimale co-canal en dB    
        CI_min_su = 10^(CI_min_dB/10); % Conversion C/I en linaire
        D_min_km = R_c_km * ((CI_min_su)^(1/3.52)); % Calcul du rayon d'une cellule
        set(handles.D_min,'String',D_min_km); % Affiche le rsultat de la distance min
        
    elseif value_R_c_km ==0 && value_N_cell == 0 % Si le rayon d'une cellule et le nombre de cellules/motif sont connus 
        N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        D_min_km = sqrt ( 3 * N_cell) * R_c_km ; % Calcul de la distance minimale entre cellules de mme frquence
        set(handles.D_min,'String',D_min_km); % Affiche le rsultat de la distance minimale
	end
end


    
% Calcul de la surface d'une cellule en fonction du rayon d'une cellule :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_S_c_km2 = isempty(get(handles.S_c,'String'));
value_R_c_km = isempty(get(handles.R_c,'String'));


if value_S_c_km2 == 1 % Si la surface n'est pas renseigne
    if value_R_c_km == 0 % Si le rayon d'une cellule est renseign
        R_c_km = str2double(get(handles.R_c,'String')); % Rcupration de la valeur du rayon d'une cellule
        S_c_km2 = pi * ((R_c_km)^2) ; % Calcul de la surface d'une cellule
        set(handles.S_c,'String',S_c_km2); % Affiche le rsultat de la surface d'une cellule en km2
    end
end


% Vrification de la valeur du nombre de cellules par motif (Acceptable ou non) :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_N_cell = isempty(get(handles.N_c,'String'));


if value_N_cell == 0 % Si le nombre de cellules par motif est connu
    N_cell = str2double(get(handles.N_c,'String')); % Rcupration de la valeur du nombre de cellules par motif
    
    if N_cell == 1
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 3
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 4
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 7
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 9 
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 12 
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 13 
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 16 
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 19
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 21 
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 28 
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    elseif N_cell == 29
        set(handles.Accept_N_cellule,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % N acceptable
    else
        set(handles.Accept_N_cellule,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % N non acceptable   
    end
end


% Vrification si la distance entre deux cellules utilisant la mme frquence est acceptable ou non :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_D_min_km = isempty(get(handles.D_min,'String'));
value_D_km = isempty(get(handles.D,'String'));


if value_D_km == 0 && value_D_min_km ==0 % Si la distance et la distance min entre cellules de mme frquence sont connues
    
    D_min_km = str2double(get(handles.D_min,'String')); % Rcupration de la valeur de la distance min entre cellules de mme frquence
    D_km = str2double(get(handles.D,'String')); % Rcupration de la valeur de la distance entre cellules de mme frquence
    
    if D_km < D_min_km
        set(handles.Accept_D,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % D non acceptable      
    else
        set(handles.Accept_D,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % D acceptable
    end
end


% Vrification de le rapport C/I est acceptable ou non :


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_CI_min_dB = isempty(get(handles.C_I_min_dB,'String'));
value_CI_dB = isempty(get(handles.C_I_dB,'String'));


if value_CI_dB == 0 && value_CI_min_dB ==0 % Si l'interfrence co-canal et l'interfrence co-canal minimale sont connues
    
    CI_min_dB = str2double(get(handles.C_I_min_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal minimale
    CI_dB = str2double(get(handles.C_I_dB,'String')); % Rcupration de la valeur de l'interfrence co-canal
    
    if CI_dB < CI_min_dB
        set(handles.Accept_C_I,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % C/I non acceptable      
    else
        set(handles.Accept_C_I,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % C/I acceptable
    end
end




% --- Executes on button press in effacer.
function effacer_Callback(hObject, eventdata, handles)
% hObject    handle to effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs du programme :

set(handles.S_c, 'String', ''); % Efface la valeur de la surface des cellules
set(handles.R_c, 'String', ''); % Efface la valeur du rayon des cellules
set(handles.N_c, 'String', ''); % Efface la valeur du nombre de cellules par motif
set(handles.D, 'String', ''); % Efface la valeur de la distance entre cellules de mme frquence
set(handles.D_min, 'String', ''); % Efface la valeur de la distance min entre cellules de mme frquence
set(handles.C_I_dB, 'String', ''); % Efface la valeur de l'interfrence co-canal
set(handles.C_I_min_dB, 'String', ''); % Efface la valeur de l'interfrence co-canal min
set(handles.Accept_N_cellule, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' Nb cellules
set(handles.Accept_D, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' Distance
set(handles.Accept_C_I, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' C/I



% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all; % Fermeture du programme au complet


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal % Retour au menu principal
close Dim_DistanceMin_Ncellules % Fermeture du programme 'Dim_DistanceMin_Ncellules'
