function varargout = Liaisons_fixes_BilanLiaison(varargin)
% Liaisons_fixes MATLAB code for Liaisons_fixes.fig
%      Liste des programmes :
%           - Premire interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilit
%           - Temprature et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des rseaux cellulaires
%           - Dbit maximal 
%
%      Liaisons_fixes, by itself, creates a new Liaisons_fixes_BilanLiaison or raises the existing
%      singleton*.
%
%      H = Liaisons_fixes returns the handle to a new Liaisons_fixes_BilanLiaison or the handle to
%      the existing singleton*.
%
%      Liaisons_fixes_BilanLiaison('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Liaisons_fixes.M with the given input arguments.
%
%      Liaisons_fixes_BilanLiaison('Property','Value',...) creates a new Liaisons_fixes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Liaisons_fixes_BilanLiaison_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Liaisons_fixes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Liaisons_fixes_BilanLiaison
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 21-Feb-2019 19:47:10

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Liaisons_fixes_BilanLiaison_OpeningFcn, ...
                   'gui_OutputFcn',  @Liaisons_fixes_BilanLiaison_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Liaisons_fixes_BilanLiaison is made visible.
function Liaisons_fixes_BilanLiaison_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Liaisons_fixes_BilanLiaison (see VARARGIN)

% Choose default command line output for Liaisons_fixes_BilanLiaison
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);




% UIWAIT makes Liaisons_fixes_BilanLiaison wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Liaisons_fixes_BilanLiaison_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function PTX_Callback(hObject, eventdata, handles)
% hObject    handle to PTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PTX as text
%        str2double(get(hObject,'String')) returns contents of PTX as a double


% --- Executes during object creation, after setting all properties.
function PTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in UnitePuissanceTX.
function UnitePuissanceTX_Callback(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch get(handles.UnitePuissanceTX,'Value')   
	case 2
        Unite_P_TX = 1; % Unit de la puissance de transmission en dBm
	case 3
        Unite_P_TX = 2; % Unit de la puissance de transmission en W
    otherwise
        errordlg('Choisissez l''unit de PTX','File Error');
end
set(handles.UnitePuissanceTX, 'UserData', Unite_P_TX);

% Hints: contents = cellstr(get(hObject,'String')) returns UnitePuissanceTX contents as cell array
%        contents{get(hObject,'Value')} returns selected item from UnitePuissanceTX


% --- Executes during object creation, after setting all properties.
function UnitePuissanceTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function distance_Callback(hObject, eventdata, handles)
% hObject    handle to distance (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of distance as text
%        str2double(get(hObject,'String')) returns contents of distance as a double


% --- Executes during object creation, after setting all properties.
function distance_CreateFcn(hObject, eventdata, handles)
% hObject    handle to distance (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function BP_Callback(hObject, eventdata, handles)
% hObject    handle to BP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BP as text
%        str2double(get(hObject,'String')) returns contents of BP as a double


% --- Executes during object creation, after setting all properties.
function BP_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SNSeuil_Callback(hObject, eventdata, handles)
% hObject    handle to SNSeuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNSeuil as text
%        str2double(get(hObject,'String')) returns contents of SNSeuil as a double


% --- Executes during object creation, after setting all properties.
function SNSeuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNSeuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PuissanceRXdBm_Callback(hObject, eventdata, handles)
% hObject    handle to PuissanceRXdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PuissanceRXdBm as text
%        str2double(get(hObject,'String')) returns contents of PuissanceRXdBm as a double


% --- Executes during object creation, after setting all properties.
function PuissanceRXdBm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PuissanceRXdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PuissanceRXW_Callback(hObject, eventdata, handles)
% hObject    handle to PuissanceRXW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PuissanceRXW as text
%        str2double(get(hObject,'String')) returns contents of PuissanceRXW as a double


% --- Executes during object creation, after setting all properties.
function PuissanceRXW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PuissanceRXW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function GM_Callback(hObject, eventdata, handles)
% hObject    handle to GM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GM as text
%        str2double(get(hObject,'String')) returns contents of GM as a double


% --- Executes during object creation, after setting all properties.
function GM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function FM_Callback(hObject, eventdata, handles)
% hObject    handle to FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FM as text
%        str2double(get(hObject,'String')) returns contents of FM as a double


% --- Executes during object creation, after setting all properties.
function FM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PRXmindBm_Callback(hObject, eventdata, handles)
% hObject    handle to PRXmindBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PRXmindBm as text
%        str2double(get(hObject,'String')) returns contents of PRXmindBm as a double


% --- Executes during object creation, after setting all properties.
function PRXmindBm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PRXmindBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PRXminW_Callback(hObject, eventdata, handles)
% hObject    handle to PRXminW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PRXminW as text
%        str2double(get(hObject,'String')) returns contents of PRXminW as a double


% --- Executes during object creation, after setting all properties.
function PRXminW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PRXminW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PbruitdBm_Callback(hObject, eventdata, handles)
% hObject    handle to PbruitdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PbruitdBm as text
%        str2double(get(hObject,'String')) returns contents of PbruitdBm as a double


% --- Executes during object creation, after setting all properties.
function PbruitdBm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PbruitdBm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function PbruitW_Callback(hObject, eventdata, handles)
% hObject    handle to PbruitW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PbruitW as text
%        str2double(get(hObject,'String')) returns contents of PbruitW as a double


% --- Executes during object creation, after setting all properties.
function PbruitW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PbruitW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SN_Callback(hObject, eventdata, handles)
% hObject    handle to SN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SN as text
%        str2double(get(hObject,'String')) returns contents of SN as a double


% --- Executes during object creation, after setting all properties.
function SN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function Acceptable_SN_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Acceptable_SN_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function freq_Callback(hObject, eventdata, handles)
% hObject    handle to freq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of freq as text
%        str2double(get(hObject,'String')) returns contents of freq as a double


% --- Executes during object creation, after setting all properties.
function freq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to freq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function hTX_Callback(hObject, eventdata, handles)
% hObject    handle to hTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hTX as text
%        str2double(get(hObject,'String')) returns contents of hTX as a double


% --- Executes during object creation, after setting all properties.
function hTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function hRX_Callback(hObject, eventdata, handles)
% hObject    handle to hRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hRX as text
%        str2double(get(hObject,'String')) returns contents of hRX as a double


% --- Executes during object creation, after setting all properties.
function hRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ChoixEspace.
function ChoixEspace_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixEspace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch get(handles.ChoixEspace,'Value')   
	case 2
        Espace = 1; % Espace libre slectionn

	case 3
        Espace = 2; % Milieu urbain slectionn

    otherwise
        errordlg('Choisissez le milieu de propagation','File Error');
end
set(handles.ChoixEspace, 'UserData', Espace);

% Hints: contents = cellstr(get(hObject,'String')) returns ChoixEspace contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ChoixEspace


% --- Executes during object creation, after setting all properties.
function ChoixEspace_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChoixEspace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function GTX_Callback(hObject, eventdata, handles)
% hObject    handle to GTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GTX as text
%        str2double(get(hObject,'String')) returns contents of GTX as a double


% --- Executes during object creation, after setting all properties.
function GTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function GRX_Callback(hObject, eventdata, handles)
% hObject    handle to GRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of GRX as text
%        str2double(get(hObject,'String')) returns contents of GRX as a double


% --- Executes during object creation, after setting all properties.
function GRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Accept_PRX_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_PRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_PRX as text
%        str2double(get(hObject,'String')) returns contents of Accept_PRX as a double


% --- Executes during object creation, after setting all properties.
function Accept_PRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_PRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Accept_FM_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_FM as text
%        str2double(get(hObject,'String')) returns contents of Accept_FM as a double


% --- Executes during object creation, after setting all properties.
function Accept_FM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_FM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Lp_Callback(hObject, eventdata, handles)
% hObject    handle to Lp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Lp as text
%        str2double(get(hObject,'String')) returns contents of Lp as a double


% --- Executes during object creation, after setting all properties.
function Lp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Lp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function LCTX_Callback(hObject, eventdata, handles)
% hObject    handle to LCTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LCTX as text
%        str2double(get(hObject,'String')) returns contents of LCTX as a double


% --- Executes during object creation, after setting all properties.
function LCTX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LCTX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function LCRX_Callback(hObject, eventdata, handles)
% hObject    handle to LCRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LCRX as text
%        str2double(get(hObject,'String')) returns contents of LCRX as a double


% --- Executes during object creation, after setting all properties.
function LCRX_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LCRX (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function La_Callback(hObject, eventdata, handles)
% hObject    handle to La (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of La as text
%        str2double(get(hObject,'String')) returns contents of La as a double


% --- Executes during object creation, after setting all properties.
function La_CreateFcn(hObject, eventdata, handles)
% hObject    handle to La (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Accept_SN_Seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Accept_SN_Seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Accept_SN_Seuil as text
%        str2double(get(hObject,'String')) returns contents of Accept_SN_Seuil as a double


% --- Executes during object creation, after setting all properties.
function Accept_SN_Seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Accept_SN_Seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function PXRMin_Callback(hObject, eventdata, handles)
% hObject    handle to PXRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PXRMin as text
%        str2double(get(hObject,'String')) returns contents of PXRMin as a double


% --- Executes during object creation, after setting all properties.
function PXRMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PXRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in UnitePuissancePRMin.
function UnitePuissancePRMin_Callback(hObject, eventdata, handles)
% hObject    handle to UnitePuissancePRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns UnitePuissancePRMin contents as cell array
%        contents{get(hObject,'Value')} returns selected item from UnitePuissancePRMin
switch get(handles.UnitePuissancePRMin,'Value')   
	case 2
        Unite_P_RX_min = 1; % Unit de la puissance de transmission en dBm
	case 3
        Unite_P_RX_min = 2; % Unit de la puissance de transmission en W
    otherwise
        errordlg('Choisissez l''unit de PRX min','File Error');
end
set(handles.UnitePuissancePRMin, 'UserData', Unite_P_RX_min);


% --- Executes during object creation, after setting all properties.
function UnitePuissancePRMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UnitePuissancePRMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function SN_Seuil_sortie_Callback(hObject, eventdata, handles)
% hObject    handle to SN_Seuil_sortie (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SN_Seuil_sortie as text
%        str2double(get(hObject,'String')) returns contents of SN_Seuil_sortie as a double


% --- Executes during object creation, after setting all properties.
function SN_Seuil_sortie_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SN_Seuil_sortie (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Pbruit_Callback(hObject, eventdata, handles)
% hObject    handle to Pbruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Pbruit as text
%        str2double(get(hObject,'String')) returns contents of Pbruit as a double


% --- Executes during object creation, after setting all properties.
function Pbruit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Pbruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in UnitePuissanceBruit.
function UnitePuissanceBruit_Callback(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceBruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch get(handles.UnitePuissanceBruit,'Value')   
	case 2
        Unite_N = 1; % Unit de la puissance de bruit en dBm
	case 3
        Unite_N = 2; % Unit de la puissance de bruit en W
    otherwise
        errordlg('Choisissez l''unit de la puissance de bruit','File Error');
end
set(handles.UnitePuissanceBruit, 'UserData', Unite_N);

% Hints: contents = cellstr(get(hObject,'String')) returns UnitePuissanceBruit contents as cell array
%        contents{get(hObject,'Value')} returns selected item from UnitePuissanceBruit


% --- Executes during object creation, after setting all properties.
function UnitePuissanceBruit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to UnitePuissanceBruit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Temp_Callback(hObject, eventdata, handles)
% hObject    handle to Temp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Temp as text
%        str2double(get(hObject,'String')) returns contents of Temp as a double


% --- Executes during object creation, after setting all properties.
function Temp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Temp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Acceptable_SN_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Acceptable_SN_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Acceptable_SN_seuil as text
%        str2double(get(hObject,'String')) returns contents of Acceptable_SN_seuil as a double


% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Calcul Puissance de Rception :

Espace = get(handles.ChoixEspace, 'UserData');
Unite_P_TX = get(handles.UnitePuissanceTX, 'UserData');
P_TX_value = str2double(get(handles.PTX,'String'));
d_m = str2double(get(handles.distance,'String'));
h_TX_m = str2double(get(handles.hTX,'String'));
h_RX_m = str2double(get(handles.hRX,'String'));
G_TX_dB = str2double(get(handles.GTX,'String'));
G_RX_dB = str2double(get(handles.GRX,'String'));
Lp_dB = str2double(get(handles.Lp,'String'));
L_CTX_dB = str2double(get(handles.LCTX,'String'));
L_CRX_dB = str2double(get(handles.LCRX,'String'));
La_dB = str2double(get(handles.La,'String'));
f_MHz = str2double(get(handles.freq,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_Lp = isempty(get(handles.Lp,'String'));
value_hTX = isempty(get(handles.hTX,'String'));
value_hRX = isempty(get(handles.hRX,'String'));
value_d = isempty(get(handles.distance,'String'));
value_f = isempty(get(handles.freq,'String'));
value_LCTX = isempty(get(handles.LCTX,'String'));
value_LCRX = isempty(get(handles.LCRX,'String'));
value_La = isempty(get(handles.La,'String'));
value_PTX = isempty(get(handles.PTX,'String'));
value_GTX = isempty(get(handles.GTX,'String'));
value_GRX = isempty(get(handles.GRX,'String'));


% Constantes :

c = 3.00 * 10^(8); % Vitesse de la lumire en m/s
k = physconst('Boltzmann'); % Constante de Boltzmann

% Conversions :

if value_f ~=1
    f_Hz = f_MHz * 10^(6); % Frquence en Hz
end

% Calcul de la puissance de rception :

% Si LCTX et LCRX non renseignes :

if value_LCTX == 1
    set(handles.LCTX, 'String', 0); % On affiche 0 dans l'interface
    L_CTX_dB = 0; % On fixe L_CRX  0 dB;
end

if value_LCRX == 1
    set(handles.LCRX, 'String', 0); % On affiche 0 dans l'interface
    L_CRX_dB = 0; % On fixe L_CRX  0 dB;
end

% Si La non renseigne :

if value_La == 1
    set(handles.La, 'String', 0); % On affiche 0 dans l'interface
    La_dB = 0; % On fixe La  0 dB;
end

% Si GTX et GRX non renseigns :

if value_GTX == 1
    set(handles.GTX, 'String', 0); % On affiche 0 dans l'interface
    G_TX_dB = 0; % On fixe L_CRX  0 dB;
end

if value_GRX == 1
    set(handles.GRX, 'String', 0); % On affiche 0 dans l'interface
    G_RX_dB = 0; % On fixe L_CRX  0 dB;
end

if Espace == 1  % En espace libre
    if value_Lp == 1 % Lp n'a pas t renseigne par l'utilisateur
        if value_d == 1 || value_f ==1 % La distance et/ou la frquence n'ont pas t renseignes par l'utilisateur
            errordlg('Rentrer une valeur de Lp ou Rentrer les valeurs de d et de f','File Error');
        else
            Lp_dB = 20*log10((4 * pi * d_m * f_Hz)/c); % Calcul des pertes de propagation en dB en espace libre
            if value_PTX == 0 % Si l'utilisateur a renseign une valeur de P_TX
                if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                	P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CRX_dB - L_CTX_dB - La_dB; % Calcul de la puissance de rception en dBm
                    P_RX_W = 10.^(P_RX_dBm/10).*10^(-3); % Conversion de la puissance de rception en W
                elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                    P_RX_W = (P_TX_value * 10^(G_RX_dB/10) * 10^(G_TX_dB/10))/ ((10^(Lp_dB/10))*(10^(L_CRX_dB/10))*(10^(L_CTX_dB/10)) * (10^(La_dB/10))); % Calcul de la puissance de rception en W
                    P_RX_dBm = 10*log10(P_RX_W * 10^(3)); % Conversion de la puissance de rception en dBm
                else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                    errordlg('Choisissez l''unit de PTX','File Error');
                end
                set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
                set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W
            end
            
            set(handles.Lp,'String',Lp_dB);
        end
          
    else
        if value_PTX == 0 % Si l'utilisateur a renseign une valeur de P_TX
            if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CRX_dB - L_CTX_dB - La_dB; % Calcul de la puissance de rception en dBm
                P_RX_W = 10.^(P_RX_dBm/10).*10^(-3); % Conversion de la puissance de rception en W 
            elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                P_RX_W = (P_TX_value * 10^(G_RX_dB/10) * 10^(G_TX_dB/10))/ (10^(Lp_dB/10)*(10^(L_CRX_dB/10))*(10^(L_CTX_dB/10))* (10^(La_dB/10))); % Calcul de la puissance de rception en W
                P_RX_dBm = 10*log10(P_RX_W * 10^(3)); % Conversion de la puissance de rception en dBm
            else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                errordlg('Choisissez l''unit de PTX','File Error');
            end
            
            set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
            set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W    
        end
        
 
    end

elseif Espace == 2 % En milieu urbain
    if value_Lp == 1
        if value_hTX == 1 || value_hRX ==1 || value_d == 1
            errordlg('Rentrer les valeurs des hauteurs d''antennes et/ou la distance entre Tx et RX ou rentrer une valeur de Lp','File Error');
        else
            if value_PTX == 0 % Si l'utilisateur a rentr une valeur de P_TX
                if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                    P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB  - L_CTX_dB - L_CRX_dB - La_dB + 20*log10(h_TX_m*h_RX_m) - 40*log10(d_m);
                    P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
                elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                    P_TX_value = 10*log10(P_TX_value * 10^(3));
                    P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - L_CTX_dB - L_CRX_dB - La_dB + 20*log10(h_TX_m*h_RX_m) - 40*log10(d_m);
                    P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
                else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                    errordlg('Choisissez l''unit de PTX','File Error');
                end
                set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
                set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W
            end

            
        end
        
    else % Si Lp a t renseign par l'utilisateur
        if value_PTX == 0 % Si l'utilisateur a rentr une valeur de P_TX
            if Unite_P_TX == 1 % Si P_TX a t renseigne en dBm
                P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CTX_dB - L_CRX_dB - La_dB; % Calcul de P_RX en dBm en milieu urbain
                P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
            elseif Unite_P_TX == 2 % Si P_TX a t renseigne en W
                P_TX_value = 10*log10(P_TX_value * 10^(3));
                P_RX_dBm = P_TX_value + G_RX_dB + G_TX_dB - Lp_dB - L_CTX_dB - L_CRX_dB - La_dB; % Calcul de P_RX en dBm en milieu urbain
                P_RX_W = 10.^(P_RX_dBm/10).*10^(-3);
            else % Si l'utilisateur a oubli de renseigner l'unit de P_TX
                errordlg('Choisissez l''unit de PTX','File Error');
            end
            set(handles.PuissanceRXdBm,'String',P_RX_dBm); % Affiche le rsultat de P_RX en dBm
            set(handles.PuissanceRXW,'String',P_RX_W); % Affiche le rsultat de P_RX en W
        end
        
        
    end
else % Si le milieu de propagation n'a pas t slectionn par l'utilisateur
    errordlg('Choisissez le milieu de propagation','File Error');
end

% Calcul de la puissance de bruit :

N_value = str2double(get(handles.Pbruit,'String'));
Temp_value = str2double(get(handles.Temp,'String'));
W_value = str2double(get(handles.BP,'String'));
Unite_N = get(handles.UnitePuissanceBruit,'UserData');

% Conversions :

T_Kelvin = Temp_value + 273; % Temprature de C en degr Kelvin
W_Hz = W_value * 10^(6); % Bande passante de MHz en Hz

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_N = isempty(get(handles.Pbruit,'String'));
value_Temp = isempty(get(handles.Temp,'String'));
value_W = isempty(get(handles.BP,'String'));

if value_N == 1 % Si l'utilisateur ne rentre pas une valeur de puissance de bruit
    if value_W == 0 && value_Temp == 0 % Si la bande passante et la temprature sont connues
        N_W = k * T_Kelvin * W_Hz; % Calcul de la puissance de bruit en W
        N_dBm = 10*log10(N_W * 10^(3)); % Calcul de la puissance de bruit en dBm
        set(handles.PbruitdBm,'String',N_dBm); % Affiche le rsultat de la puissance de bruit en dBm
        set(handles.PbruitW,'String',N_W); % Affiche le rsultat de la puissance de bruit en W
    end

else % Si l'utilisateur a rentr une valeur de N 
    if Unite_N == 1 % Si l'unit de N est dBm
        N_dBm = N_value;
        N_W = 10^(N_dBm/10) * 10^(-3); % Conversion de N en W
    elseif Unite_N == 2 % Si l'unit de N est W
        N_W = N_value;
        N_dBm = 10*log10(N_W * 10^(3)); % Conversion de N en dBm
    else % Si l'utilisateur n'a pas choisi l'unit de N
        errordlg('Choisissez l''unit de la puissance de bruit','File Error');
    end 
    set(handles.PbruitdBm,'String',N_dBm); % Affiche le rsultat de la puissance de bruit en dBm
    set(handles.PbruitW,'String',N_W); % Affiche le rsultat de la puissance de bruit en W
end

% Calcul de la sensibilit du rcepteur P_RX_min :

PXRMin_value = str2double(get(handles.PXRMin,'String'));
Unite_P_RX_min = get(handles.UnitePuissancePRMin,'UserData');
SNSeuil_value = str2double(get(handles.SNSeuil,'String'));
N_dBm_out_value = str2double(get(handles.PbruitdBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_P_RX_min = isempty(get(handles.PXRMin,'String'));
value_SNSeuil = isempty(get(handles.SNSeuil,'String'));
value_PbruitdBm_out = isempty(get(handles.PbruitdBm,'String'));

if value_P_RX_min == 0 % Si l'utilisateur a rentr une valeur de puissance de rception minimale
    if Unite_P_RX_min == 1 % Si l'unit de PRXmin est dBm
        PXRMin_dBm = PXRMin_value;
        PXRMin_W = 10^(PXRMin_dBm/10) * 10^(-3); % Conversion de PRXmin en W
    elseif Unite_P_RX_min == 2 % Si l'unit de PRXmin est W
        PXRMin_W = PXRMin_value;
        PXRMin_dBm = 10*log10(PXRMin_W * 10^(3)); % Conversion de PRXmin en dBm
    else % Si l'utilisateur n'a pas choisi l'unit de PRXmin
        errordlg('Choisissez l''unit de la sensibilit du rcepteur','File Error');
    end 
    set(handles.PRXmindBm,'String',PXRMin_dBm); % Affiche le rsultat de la puissance de rception minimale en dBm
    set(handles.PRXminW,'String',PXRMin_W); % Affiche le rsultat de la puissance de rception minimale en W

else % Si l'utilisateur ne rentre pas une valeur de puissance de rception minimale
    if value_SNSeuil == 0 && value_PbruitdBm_out == 0 % Si le rapport S/N seuil et la puissance de bruit sont connus
        PXRMin_dBm = SNSeuil_value + N_dBm_out_value; % Calcul de la puissance de rception minimale en dBm
        PXRMin_W = 10^(PXRMin_dBm/10) * 10^(-3); % % Conversion de PRXmin en W
        set(handles.PRXmindBm,'String',PXRMin_dBm); % Affiche le rsultat de la puissance de rception minimale en dBm
        set(handles.PRXminW,'String',PXRMin_W); % Affiche le rsultat de la puissance de rception minimale en W
    end
          
end

% Calcul rapport sur bruit seuil :

PRXMin_dBM_out_value = str2double(get(handles.PRXmindBm,'String'));
SNSeuil_value = str2double(get(handles.SNSeuil,'String'));
N_dBm_out_value = str2double(get(handles.PbruitdBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PRXMin_dBM_out = isempty(get(handles.PRXmindBm,'String'));
value_SNSeuil = isempty(get(handles.SNSeuil,'String'));
value_PbruitdBm_out = isempty(get(handles.PbruitdBm,'String'));

if value_SNSeuil == 0 % Si l'utilisateur a rentr une valeur de S/N seuil
    SNSeuil_dB = SNSeuil_value;
    if SNSeuil_dB > 0 % Si SN seuil >0 dB
        set(handles.Accept_SN_Seuil,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
    else % Si SN seuil <0 dB
        set(handles.Accept_SN_Seuil,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
    end
    set(handles.SN_Seuil_sortie,'String',SNSeuil_dB); % Affiche le rsultat du rapport S/N seuil en dB

else % Si l'utilisateur ne rentre pas une valeur de rapport S/N seuil
    if value_PRXMin_dBM_out == 0 && value_PbruitdBm_out == 0 % Si la sensibilit du rcepteur et la puissance de bruit sont connues
        SNSeuil_dB = PRXMin_dBM_out_value - N_dBm_out_value; % Calcul du rapport S/N seuil en dB
        set(handles.SN_Seuil_sortie,'String',SNSeuil_dB); % Affiche le rsultat du rapport S/N seuil en dB
        if SNSeuil_dB > 0 % Si SN seuil >0 dB
            set(handles.Accept_SN_Seuil,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
        else % Si SN seuil <0 dB
            set(handles.Accept_SN_Seuil,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
        end
    end
          
end

% Calcul rapport sur bruit :

PRX_dBM_out_value = str2double(get(handles.PuissanceRXdBm,'String'));
N_dBm_out_value = str2double(get(handles.PbruitdBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PRX_dBM_out = isempty(get(handles.PuissanceRXdBm,'String'));
value_PbruitdBm_out = isempty(get(handles.PbruitdBm,'String'));

if value_PRX_dBM_out == 0 && value_PbruitdBm_out == 0 % Si la puissance de rception et la puissance de bruit sont connues
	SN_dB = PRX_dBM_out_value - N_dBm_out_value; % Calcul du rapport S/N en dB
	set(handles.SN,'String',SN_dB); % Affiche le rsultat du rapport S/N en dB
end

% Calcul marge de gain :

PTX_dBM_out_value = str2double(get(handles.PTX,'String'));
PRXMin_dBM_out_value = str2double(get(handles.PRXmindBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PTX_dBM_out = isempty(get(handles.PTX,'String'));
value_PRXMin_dBM_out = isempty(get(handles.PRXmindBm,'String'));

if value_PTX_dBM_out == 0 && value_PRXMin_dBM_out == 0 % Si la puissance de transmission et la puissance de rception minimale sont connues
	GM_dB = PTX_dBM_out_value - PRXMin_dBM_out_value; % Calcul de la marge de gain en dB
	set(handles.GM,'String',GM_dB); % Affiche le rsultat de la marge de gain en dB
end

% Calcul marge d'vanouissement :

PRX_dBM_out_value = str2double(get(handles.PuissanceRXdBm,'String'));
PRXMin_dBM_out_value = str2double(get(handles.PRXmindBm,'String'));

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_PRX_dBM_out = isempty(get(handles.PuissanceRXdBm,'String'));
value_PRXMin_dBM_out = isempty(get(handles.PRXmindBm,'String'));

if value_PRX_dBM_out == 0 && value_PRXMin_dBM_out == 0 % Si la puissance de rception et la puissance de rception minimale sont connues
	FM_dB = PRX_dBM_out_value - PRXMin_dBM_out_value; % Calcul de la marge d'vanouissement en dB
	set(handles.FM,'String',FM_dB); % Affiche le rsultat de la marge d'vanouissement en dB
    if FM_dB > 0 % Si FM >0 dB
    	set(handles.Accept_FM,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
    else % Si SN seuil <0 dB
        set(handles.Accept_FM,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
    end
end

% Calcul qualit de liaison Puissance de rception :
if value_PRX_dBM_out == 0 && value_PRXMin_dBM_out == 0 % Si la puissance de rception et la puissance de rception minimale sont connues
    if abs(PRX_dBM_out_value - value_PRXMin_dBM_out) > 0 % Si puissance reue > puissance de rception minimale en dBm
        set(handles.Accept_PRX,'String','Acceptable','BackgroundColor','green','fontweight', 'bold'); % Qualit de la liaison acceptable
    else % Si puissance reue < puissance de rception minimale en dBm
        set(handles.Accept_PRX,'String','Non Acceptable','BackgroundColor','red','fontweight', 'bold'); % Qualit de la liaison non acceptable
    end
end

% Vrification du choix du milieu de propagation :

if value_PTX_dBM_out == 0 % Si l'utilisateur a rentr une valeur de puissance de transmission
    if Espace ~= 2 % si l'utilisateur n'a pas renseign le milieu de propagation
        if Espace ~= 1
            errordlg('Choisissez le milieu de propagation','File Error'); % Retourne un message d'erreur pour choisir le milieu de propagation
        end
    end
    
    if Unite_P_TX ~= 1 % si l'utilisateur n'a pas renseign l'unit de la puissance de transmission
        if Unite_P_TX ~= 2
            errordlg('Choisissez l''unit de PTX','File Error'); % Retourne un message d'erreur pour choisir l'unit de la puissance de transmission
        end
    end      
end
        



% --- Executes on button press in Effacer.
function Effacer_Callback(hObject, eventdata, handles)
% hObject    handle to Effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entre :

set(handles.PTX, 'String', ''); % Efface la valeur de la puissance de transmission
set(handles.distance, 'String', ''); % Efface la valeur de la distance
set(handles.hTX, 'String', ''); % Efface la valeur de la hauteur d'antenne TX
set(handles.hRX, 'String', ''); % Efface la valeur de la hauteur d'antenne RX
set(handles.GTX, 'String', ''); % Efface la valeur du gain d'antenne TX
set(handles.GRX, 'String', ''); % Efface la valeur du gain d'antenne RX
set(handles.Lp, 'String', ''); % Efface la valeur des pertes de propagation
set(handles.LCTX, 'String', ''); % Efface la valeur des pertes de connexion LCTX
set(handles.LCRX, 'String', ''); % Efface la valeur des pertes de connexion LCRX
set(handles.La, 'String', ''); % Efface la valeur des pertes atmosphriques
set(handles.Pbruit, 'String', ''); % Efface la valeur des pertes de bruit
set(handles.Temp, 'String', ''); % Efface la valeur de la temprature
set(handles.BP, 'String', ''); % Efface la valeur de la bande passante
set(handles.SNSeuil, 'String', ''); % Efface la valeur du rapport S/N seuil
set(handles.freq, 'String', ''); % Efface la valeur de la frquence
set(handles.PXRMin, 'String', ''); % Efface la valeur de la puissance de rception minimale
set(handles.UnitePuissanceTX, 'Value', 1); % Remet le popumenu "Unit PTX"  l'tat initial
set(handles.ChoixEspace, 'Value', 1); % Remet le popumenu "Choix espace"  l'tat initial
set(handles.UnitePuissanceBruit, 'Value', 1); % Remet le popumenu "Unit N"  l'tat initial
set(handles.UnitePuissancePRMin, 'Value', 1); % Remet le popumenu "Unit PRXmin"  l'tat initial


% Effacer les valeurs de sortie :

set(handles.PuissanceRXdBm, 'String', ''); % Efface la valeur de P_RX_dBm
set(handles.PuissanceRXW, 'String', ''); % Efface la valeur de P_RX_W
set(handles.PbruitdBm, 'String', ''); % Efface la valeur de N_dBm
set(handles.PbruitW, 'String', ''); % Efface la valeur de N_W
set(handles.PRXmindBm, 'String', ''); % Efface la valeur de P_RX_dBm minimale
set(handles.PRXminW, 'String', ''); % Efface la valeur de P_RX_W minimale
set(handles.SN, 'String', ''); % Efface la valeur du rapport S/N
set(handles.SN_Seuil_sortie, 'String', ''); % Efface la valeur du rapport S/N seuil
set(handles.GM, 'String', ''); % Efface la valeur de la marge de gain
set(handles.FM, 'String', ''); % Efface la valeur de la marge d'vanouissement
set(handles.Accept_SN_Seuil, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' SN_seuil
set(handles.Accept_PRX, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' PRX
set(handles.Accept_FM, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'Acceptable ou non' FM

% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all;


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal
close Liaisons_fixes_BilanLiaison
