function varargout = Dim_ProbaBlocage_Nlignes_Qtrafic(varargin)
% Liaisons_fixes MATLAB code for Liaisons_fixes.fig
%      Liste des programmes :
%           - Première interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilité
%           - Température et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des réseaux cellulaires
%           - Débit maximal
%
%      Liaisons_fixes, by itself, creates a new Dim_ProbaBlocage_Nlignes_Qtrafic or raises the existing
%      singleton*.
%
%      H = Liaisons_fixes returns the handle to a new Dim_ProbaBlocage_Nlignes_Qtrafic or the handle to
%      the existing singleton*.
%
%      Dim_ProbaBlocage_Nlignes_Qtrafic('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Liaisons_fixes.M with the given input arguments.
%
%      Dim_ProbaBlocage_Nlignes_Qtrafic('Property','Value',...) creates a new Liaisons_fixes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Dim_ProbaBlocage_Nlignes_Qtrafic_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Liaisons_fixes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Dim_ProbaBlocage_Nlignes_Qtrafic
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 23-Aug-2020 22:41:54

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Dim_ProbaBlocage_Nlignes_Qtrafic_OpeningFcn, ...
                   'gui_OutputFcn',  @Dim_ProbaBlocage_Nlignes_Qtrafic_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Dim_ProbaBlocage_Nlignes_Qtrafic is made visible.
function Dim_ProbaBlocage_Nlignes_Qtrafic_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Dim_ProbaBlocage_Nlignes_Qtrafic (see VARARGIN)

% Choose default command line output for Dim_ProbaBlocage_Nlignes_Qtrafic
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);




% UIWAIT makes Dim_ProbaBlocage_Nlignes_Qtrafic wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Dim_ProbaBlocage_Nlignes_Qtrafic_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% 1er sous-programme : Calcul du trafic

function Prog1_N_Callback(hObject, eventdata, handles)
% hObject    handle to Prog1_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog1_N as text
%        str2double(get(hObject,'String')) returns contents of Prog1_N as a double


% --- Executes during object creation, after setting all properties.
function Prog1_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog1_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog1_P_Pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Prog1_P_Pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog1_P_Pourcent as text
%        str2double(get(hObject,'String')) returns contents of Prog1_P_Pourcent as a double


% --- Executes during object creation, after setting all properties.
function Prog1_P_Pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog1_P_Pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog1_Q_Callback(hObject, eventdata, handles)
% hObject    handle to Prog1_Q (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog1_Q as text
%        str2double(get(hObject,'String')) returns contents of Prog1_Q as a double


% --- Executes during object creation, after setting all properties.
function Prog1_Q_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog1_Q (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Prog1_P_pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Prog1_P_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog1_P_pourcent as text
%        str2double(get(hObject,'String')) returns contents of Prog1_P_pourcent as a double


% --- Executes during object creation, after setting all properties.
function Prog1_P_pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog1_P_pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in Choix_modele_stat.
function Choix_modele_stat_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_modele_stat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_modele_stat contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_modele_stat
switch get(handles.Choix_modele_stat,'Value')   
	case 2
        Choix_mod_stat = 1; % Modèle Erlang B
        
	case 3
        Choix_mod_stat = 2; % Modèle Erlang C
        
	case 4
        Choix_mod_stat = 3; % Modèle Poisson
        
    otherwise
        errordlg('Choisissez le modèle statistique','File Error');
end
set(handles.Choix_modele_stat, 'UserData', Choix_mod_stat);

% --- Executes during object creation, after setting all properties.
function Choix_modele_stat_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_modele_stat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Prog1_calculer.
function Prog1_calculer_Callback(hObject, eventdata, handles)
% hObject    handle to Prog1_calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% Calcul Trafic en Erlang selon le modèle d'Erlang B :

Prog1_P_Pourcentage = str2double(get(handles.Prog1_P_Pourcent,'String'));
Prog1_N_lignes = str2double(get(handles.Prog1_N,'String'));


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_Prog1_P_Pourcentage = isempty(get(handles.Prog1_P_Pourcent,'String'));
value_Prog1_N_lignes = isempty(get(handles.Prog1_N,'String'));


% Conversions :

if value_Prog1_P_Pourcentage ~=1 % Si la cellule de probabilitÃ© de blocage est non vide
    Prog1_P_su = Prog1_P_Pourcentage / 100; % ProbabilitÃ© de blocage sans unitÃ©
end

if value_Prog1_P_Pourcentage ==0 && value_Prog1_N_lignes ==0 % Si la probabilitÃ© de blocage et le nombre de lignes ont Ã©tÃ© renseignÃ©s
    sum1 = 0; % Initialisation de la somme
    Q_E = 0 : 0.001 : 250 ; % CrÃ©ation d'un tableau avec les valeurs possibles de Q
    
    for i = 0 : Prog1_N_lignes
        sum1 = sum1 + Q_E.^(i)./factorial(i) ; % Calcul de la somme (DÃ©nominateur de la formule d'Erlang B)
    end
    denominateur = sum1; % Calcul du dÃ©nominateur
    numerateur = Q_E.^(Prog1_N_lignes) ./ factorial(Prog1_N_lignes); % Calcul du numÃ©rateur
    P_calcule = numerateur ./ denominateur; % Calcul de P pour chaque valeur de Q
    
    diff = abs(P_calcule - Prog1_P_su);
    indice=find(diff==min(diff)) ; % RÃ©cupÃ©ration de l'indice pour retrouver la valeur de Q
    Q_recherche = (indice-1)*0.001; % Calcul du Q recherchÃ©
    
    set(handles.Prog1_Q,'String',Q_recherche); % Affiche le rÃ©sultat du trafic en Erlang

else
    
    if value_Prog1_P_Pourcentage == 1 % La probabilitÃ© de blocage n'a pas Ã©tÃ© renseignÃ©e
        errordlg('Rentrer une valeur de probabilitÃ© de blocage','File Error');
    else % Le nombre de lignes n'a pas Ã©tÃ© renseignÃ©
       errordlg('Rentrer un nombre de lignes','File Error'); 
    end
end



% --- Executes on button press in Prog1_effacer.
function Prog1_effacer_Callback(hObject, eventdata, handles)
% hObject    handle to Prog1_effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entrÃ©e du 1er sous-programme :


set(handles.Prog1_P_Pourcent, 'String', ''); % Efface la valeur de la probabilitÃ© de blocage
set(handles.Prog1_N, 'String', ''); % Efface la valeur du nombre de lignes

% Effacer les valeurs de sortie du 1er sous-programme :

set(handles.Prog1_Q, 'String', ''); % Efface la valeur du trafic



% 2Ã¨me sous-programme : Calcul du nombre de lignes

function Prog2_Q_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_Q (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog2_Q as text
%        str2double(get(hObject,'String')) returns contents of Prog2_Q as a double


% --- Executes during object creation, after setting all properties.
function Prog2_Q_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog2_Q (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog2_P_Pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_P_Pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog2_P_Pourcent as text
%        str2double(get(hObject,'String')) returns contents of Prog2_P_Pourcent as a double


% --- Executes during object creation, after setting all properties.
function Prog2_P_Pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog2_P_Pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Prog2_C_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog2_C as text
%        str2double(get(hObject,'String')) returns contents of Prog2_C as a double


% --- Executes during object creation, after setting all properties.
function Prog2_C_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog2_C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog2_T_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog2_T as text
%        str2double(get(hObject,'String')) returns contents of Prog2_T as a double


% --- Executes during object creation, after setting all properties.
function Prog2_T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog2_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_Prog2_Unite_T.
function Choix_Prog2_Unite_T_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_Prog2_Unite_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_Prog2_Unite_T contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_Prog2_Unite_T

switch get(handles.Choix_Prog2_Unite_T,'Value')   
	case 2
        Unite_Prog2_T = 1; % UnitÃ© de la durÃ©e d'un appel en secondes
	case 3
        Unite_Prog2_T = 2; % UnitÃ© de la durÃ©e d'un appel en minutes
    case 4
        Unite_Prog2_T = 3; % UnitÃ© de la durÃ©e d'un appel en heures
    otherwise
        errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
end
set(handles.Choix_Prog2_Unite_T, 'UserData', Unite_Prog2_T);

% --- Executes during object creation, after setting all properties.
function Choix_Prog2_Unite_T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_Prog2_Unite_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Prog2_N_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog2_N as text
%        str2double(get(hObject,'String')) returns contents of Prog2_N as a double


% --- Executes during object creation, after setting all properties.
function Prog2_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog2_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Prog2_calculer.
function Prog2_calculer_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Calcul Nombre de lignes selon le modÃ¨le d'Erlang B :

Prog2_P_Pourcentage = str2double(get(handles.Prog2_P_Pourcent,'String'));
Unite_Prog2_T = get(handles.Choix_Prog2_Unite_T, 'UserData');
Prog2_Q_E = str2double(get(handles.Prog2_Q,'String'));
Prog2_C_appel_h = str2double(get(handles.Prog2_C,'String'));
Prog2_T_su = str2double(get(handles.Prog2_T,'String'));


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_Prog2_P_Pourcentage = isempty(get(handles.Prog2_P_Pourcent,'String'));
value_Prog2_Q_E = isempty(get(handles.Prog2_Q,'String'));
value_Prog2_C_appel_h = isempty(get(handles.Prog2_C,'String'));
value_Prog2_T_su = isempty(get(handles.Prog2_T,'String'));


% Conversion :

if value_Prog2_P_Pourcentage ~=1 % Si la cellule de probabilitÃ© de blocage est non vide
    Prog2_P_su = Prog2_P_Pourcentage / 100; % ProbabilitÃ© de blocage sans unitÃ©
end
 
% Conversion de la durÃ©e d'un appel en heure si la valeur a Ã©tÃ© renseignÃ©e:

if value_Prog2_T_su == 0 % Si une durÃ©e a Ã©tÃ© renseignÃ©e
    if Unite_Prog2_T ==1 % Si l'unitÃ© de la durÃ©e est en secondes
        Prog2_T_h = Prog2_T_su / (3600); % Conversion de la durÃ©e en h
    elseif Unite_Prog2_T ==2 % Si l'unitÃ© de la durÃ©e est en minutes
        Prog2_T_h = Prog2_T_su / (60); % Conversion de la durÃ©e en h
    elseif Unite_Prog2_T ==3 % Si l'unitÃ© de la durÃ©e est en heures
        Prog2_T_h = Prog2_T_su; % Affectation de la valeur utilisateur dans la variable
    else % Si aucune unitÃ© n'a Ã©tÃ© choisie
        errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
    end
end

   
% Calcul du trafic : 


if value_Prog2_Q_E ==1 % Si le trafic n'a pas Ã©tÃ© renseignÃ©
    if value_Prog2_C_appel_h ==1 && value_Prog2_T_su ==1
        errordlg('Rentrer une valeur d''intensitÃ© de trafic ou le nombre d''appel par heure avec la durÃ©e d''un appel','File Error');
    elseif value_Prog2_C_appel_h ==0 && value_Prog2_T_su ==0 % Si le nombre d'appels et la durÃ©e d'un appel ont Ã©tÃ© renseignÃ©s
        if Unite_Prog2_T == 1
            Prog2_Q_E = Prog2_C_appel_h * Prog2_T_h; % Calcul du trafic en Erlangs
            set(handles.Prog2_Q,'String',Prog2_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
        elseif Unite_Prog2_T == 2
            Prog2_Q_E = Prog2_C_appel_h * Prog2_T_h; % Calcul du trafic en Erlangs
            set(handles.Prog2_Q,'String',Prog2_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
        elseif Unite_Prog2_T == 3
            Prog2_Q_E = Prog2_C_appel_h * Prog2_T_h; % Calcul du trafic en Erlangs
            set(handles.Prog2_Q,'String',Prog2_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
        else
            errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
        end
    elseif value_Prog2_C_appel_h ==1 && value_Prog2_T_su ==0
        errordlg('Rentrer un nombre moyen d''appel par heure','File Error');
    else
        errordlg('Rentrer la durÃ©e moyenne d''un appel','File Error');
    end

    value_Prog2_Q_E = isempty(get(handles.Prog2_Q,'String'));
    if value_Prog2_Q_E ==0 && value_Prog2_P_Pourcentage == 0 % Si le trafic calculÃ© et la probabilitÃ© de blocage sont connus
        N = 0 : 1000;
        tab=[];
        sum2 = 0; % Initialisation du tableau
        i = 0;
        for k=0:1:1000
            i=i+1;
            sum2 = sum2 + (Prog2_Q_E.^(k))./factorial(k); % Calcul de la somme
            tab(i)=sum2; % RÃ©cupÃ©ration de la valeur pour chaque itÃ©ration
        end

        denominateur = tab; % Calcul du dÃ©nominateur

        numerateur= Prog2_Q_E.^(N) ./ factorial(N); % Calcul du numÃ©rateur

        P_calcule = numerateur ./ denominateur; % Calcul de la probabilitÃ© de blocage

        diff = abs(P_calcule - Prog2_P_su);

        indice=find(diff==min(diff)) ; % RÃ©cupÃ©ration de l'indice pour retrouver la valeur de N

        N_recherche = (indice-1); % Calcul du N recherchÃ©
        
        set(handles.Prog2_N,'String',N_recherche); % Affiche le rÃ©sultat du nombre de lignes

    end
        

    
else % Le trafic a Ã©tÃ© renseignÃ©
    if value_Prog2_C_appel_h ==0 && value_Prog2_T_su ==0
        Prog2_Q_E = Prog2_C_appel_h * Prog2_T_h;
        set(handles.Prog2_Q,'String',Prog2_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
    end 
    if value_Prog2_P_Pourcentage == 1 % Si la probabilitÃ© de blocage n'a pas Ã©tÃ© renseignÃ©e
        errordlg('Rentrer une valeur de probabilitÃ© de blocage','File Error');
    else
        N = 0 : 1000;
        tab=[];
        sum2 = 0; % Initialisation du tableau
        i = 0;
        for k=0:1:1000
            i=i+1;
            sum2 = sum2 + (Prog2_Q_E.^(k))./factorial(k); % Calcul de la somme
            tab(i)=sum2; % RÃ©cupÃ©ration de la valeur pour chaque itÃ©ration
        end

        denominateur = tab; % Calcul du dÃ©nominateur

        numerateur= Prog2_Q_E.^(N) ./ factorial(N); % Calcul du numÃ©rateur

        P_calcule = numerateur ./ denominateur; % Calcul de la probabilitÃ© de blocage

        diff = abs(P_calcule - Prog2_P_su);

        indice=find(diff==min(diff)) ; % RÃ©cupÃ©ration de l'indice pour retrouver la valeur de N

        N_recherche = (indice-1); % Calcul du N recherchÃ©
        
        set(handles.Prog2_N,'String',N_recherche); % Affiche le rÃ©sultat du nombre de lignes
    end
end

if value_Prog2_Q_E ==0 && value_Prog2_T_su ==0 && value_Prog2_C_appel_h ==1 % Si le trafic et la durÃ©e moyenne d'une conversation sont connus et le nombre d'appels est non connu
    Prog2_Q_E = str2double(get(handles.Prog2_Q,'String')); % RÃ©cupÃ©ration de la valeur du trafic
    if Unite_Prog2_T == 1
        C_appel_h_prog2 = Prog2_Q_E / Prog2_T_h; % Calcul du nombre moyen d'appels par heure
        set(handles.Prog2_C,'String',C_appel_h_prog2); % Affiche le rÃ©sultat du nombre d'appels par heure
	elseif Unite_Prog2_T == 2
        C_appel_h_prog2 = Prog2_Q_E / Prog2_T_h; % Calcul du nombre moyen d'appels par heure
    	set(handles.Prog2_C,'String',C_appel_h_prog2); % Affiche le rÃ©sultat du nombre d'appels par heure
    elseif Unite_Prog2_T == 3
        C_appel_h_prog2 = Prog2_Q_E / Prog2_T_h; % Calcul du nombre moyen d'appels par heure
        set(handles.Prog2_C,'String',C_appel_h_prog2); % Affiche le rÃ©sultat du nombre d'appels par heure
    else
        errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
    end
end



% --- Executes on button press in Prog2_effacer.
function Prog2_effacer_Callback(hObject, eventdata, handles)
% hObject    handle to Prog2_effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entrÃ©e du 2eme sous-programme :


set(handles.Prog2_P_Pourcent, 'String', ''); % Efface la valeur de la probabilitÃ© de blocage
set(handles.Prog2_Q, 'String', ''); % Efface la valeur du trafic
set(handles.Prog2_C, 'String', ''); % Efface la valeur du trafic
set(handles.Prog2_T, 'String', ''); % Efface la valeur du trafic

% Effacer les valeurs de sortie du 2eme sous-programme :

set(handles.Prog2_N, 'String', ''); % Efface la valeur du nombre de lignes
set(handles.Choix_Prog2_Unite_T, 'Value', 1); % Remet le popumenu "UnitÃ© T" Ã  l'Ã©tat initial


% 3Ã¨me sous-programme : Calcul de la probabilitÃ© de blocage

function Prog3_N_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog3_N as text
%        str2double(get(hObject,'String')) returns contents of Prog3_N as a double


% --- Executes during object creation, after setting all properties.
function Prog3_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog3_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog3_P_Pourcent_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_P_Pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog3_P_Pourcent as text
%        str2double(get(hObject,'String')) returns contents of Prog3_P_Pourcent as a double


% --- Executes during object creation, after setting all properties.
function Prog3_P_Pourcent_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog3_P_Pourcent (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog3_Q_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_Q (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog3_Q as text
%        str2double(get(hObject,'String')) returns contents of Prog3_Q as a double


% --- Executes during object creation, after setting all properties.
function Prog3_Q_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog3_Q (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_Prog3_Unite_T.
function Choix_Prog3_Unite_T_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_Prog3_Unite_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_Prog3_Unite_T contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_Prog3_Unite_T

switch get(handles.Choix_Prog3_Unite_T,'Value')   
	case 2
        Unite_Prog3_T = 1; % UnitÃ© de la durÃ©e d'un appel en secondes
	case 3
        Unite_Prog3_T = 2; % UnitÃ© de la durÃ©e d'un appel en minutes
    case 4
        Unite_Prog3_T = 3; % UnitÃ© de la durÃ©e d'un appel en heures
    otherwise
        errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
end
set(handles.Choix_Prog3_Unite_T, 'UserData', Unite_Prog3_T);

% --- Executes during object creation, after setting all properties.
function Choix_Prog3_Unite_T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_Prog3_Unite_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog3_T_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog3_T as text
%        str2double(get(hObject,'String')) returns contents of Prog3_T as a double


% --- Executes during object creation, after setting all properties.
function Prog3_T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog3_T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Prog3_C_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Prog3_C as text
%        str2double(get(hObject,'String')) returns contents of Prog3_C as a double


% --- Executes during object creation, after setting all properties.
function Prog3_C_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Prog3_C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Prog3_calculer.
function Prog3_calculer_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Calcul ProbabilitÃ© de blocage selon le modÃ¨le d'Erlang B :

Unite_Prog3_T = get(handles.Choix_Prog3_Unite_T, 'UserData');
Prog3_Q_E = str2double(get(handles.Prog3_Q,'String'));
Prog3_C_appel_h = str2double(get(handles.Prog3_C,'String'));
Prog3_T_su = str2double(get(handles.Prog3_T,'String'));
Prog3_N_lignes = str2double(get(handles.Prog3_N,'String'));


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_Prog3_C_appel_h = isempty(get(handles.Prog3_C,'String'));
value_Prog3_Q_E = isempty(get(handles.Prog3_Q,'String'));
value_Prog3_T_su = isempty(get(handles.Prog3_T,'String'));
value_Prog3_N_lignes = isempty(get(handles.Prog3_N,'String'));

 
% Conversion de la durÃ©e d'un appel en heure si la valeur a Ã©tÃ© renseignÃ©e:

if value_Prog3_T_su == 0 % Si une durÃ©e a Ã©tÃ© renseignÃ©e
    if Unite_Prog3_T ==1 % Si l'unitÃ© de la durÃ©e est en secondes
        Prog3_T_h = Prog3_T_su / (3600); % Conversion de la durÃ©e en h
    elseif Unite_Prog3_T ==2 % Si l'unitÃ© de la durÃ©e est en minutes
        Prog3_T_h = Prog3_T_su / (60); % Conversion de la durÃ©e en h
    elseif Unite_Prog3_T ==3 % Si l'unitÃ© de la durÃ©e est en heures
        Prog3_T_h = Prog3_T_su; % Affectation de la valeur utilisateur dans la variable
    else % Si aucune unitÃ© n'a Ã©tÃ© choisie
        errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
    end
end

   
% Calcul du trafic : 


if value_Prog3_Q_E ==1 % Si le trafic n'a pas Ã©tÃ© renseignÃ©
    if value_Prog3_C_appel_h ==1 && value_Prog3_T_su ==1
        errordlg('Rentrer une valeur d''intensitÃ© de trafic ou le nombre d''appel par heure avec la durÃ©e d''un appel','File Error');
    elseif value_Prog3_C_appel_h ==0 && value_Prog3_T_su ==0 % Si le nombre d'appels et la durÃ©e d'un appel ont Ã©tÃ© renseignÃ©s
        if Unite_Prog3_T == 1
            Prog3_Q_E = Prog3_C_appel_h * Prog3_T_h; % Calcul du trafic en Erlangs
            set(handles.Prog3_Q,'String',Prog3_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
        elseif Unite_Prog3_T == 2
            Prog3_Q_E = Prog3_C_appel_h * Prog3_T_h; % Calcul du trafic en Erlangs
            set(handles.Prog3_Q,'String',Prog3_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
        elseif Unite_Prog3_T == 3
            Prog3_Q_E = Prog3_C_appel_h * Prog3_T_h; % Calcul du trafic en Erlangs
            set(handles.Prog3_Q,'String',Prog3_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
        else
            errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
        end
    elseif value_Prog3_C_appel_h ==1 && value_Prog3_T_su ==0
        errordlg('Rentrer un nombre moyen d''appel par heure','File Error');
    else
        errordlg('Rentrer la durÃ©e moyenne d''un appel','File Error');
    end

    value_Prog3_Q_E = isempty(get(handles.Prog3_Q,'String'));
	if value_Prog3_Q_E ==0 && value_Prog3_N_lignes == 0 % Si le trafic calculÃ© et le nombre de lignes sont connus
        sum3 = 0;
        for i = 0 : Prog3_N_lignes
            sum3= sum3 + Prog3_Q_E^(i)/factorial(i); % Calcul du dÃ©nominateur
        end

        denominateur = sum3;
        numerateur = Prog3_Q_E^(Prog3_N_lignes) / factorial(Prog3_N_lignes); % Calcul du numÃ©rateur

        P = numerateur / denominateur; % Calcul de la probabilitÃ© de blocage
        P_pourcent = P * 100; % ProbabilitÃ© de blocage en pourcentage
        
        
        set(handles.Prog3_P_Pourcent,'String',P_pourcent); % Affiche le rÃ©sultat de la probabilitÃ© de blocage en %
	end
        

    
else % Le trafic a Ã©tÃ© renseignÃ©
    if value_Prog3_C_appel_h ==0 && value_Prog3_T_su ==0
        Prog3_Q_E = Prog3_C_appel_h * Prog3_T_h;
        set(handles.Prog3_Q,'String',Prog3_Q_E); % Affiche le rÃ©sultat du trafic en Erlang
    end 
    if value_Prog3_N_lignes == 1 % Si le nombre de lignes n'a pas Ã©tÃ© renseignÃ©
        errordlg('Rentrer un nombre de lignes','File Error'); % Affiche un message d'erreur
    else
        sum3 = 0; % Initialisation de la somme
        for i = 0 : Prog3_N_lignes
            sum3= sum3 + Prog3_Q_E^(i)/factorial(i); % Calcul du dÃ©nominateur
        end

        denominateur = sum3;
        numerateur = Prog3_Q_E^(Prog3_N_lignes) / factorial(Prog3_N_lignes); % Calcul du numÃ©rateur

        P = numerateur / denominateur; % Calcul de la probabilitÃ© de blocage
        P_pourcent = P * 100; % ProbabilitÃ© de blocage en pourcentage
        
        set(handles.Prog3_P_Pourcent,'String',P_pourcent); % Affiche le rÃ©sultat de la probabilitÃ© de blocage en %
    end
end

if value_Prog3_Q_E ==0 && value_Prog3_T_su ==0 && value_Prog3_C_appel_h ==1 % Si le trafic et la durÃ©e moyenne d'une conversation sont connus et le nombre d'appels est non connu
    Prog3_Q_E = str2double(get(handles.Prog3_Q,'String')); % RÃ©cupÃ©ration de la valeur du trafic
    if Unite_Prog3_T == 1
        C_appel_h_Prog3 = Prog3_Q_E / Prog3_T_h; % Calcul du nombre moyen d'appels par heure
        set(handles.Prog3_C,'String',C_appel_h_Prog3); % Affiche le rÃ©sultat du nombre d'appels par heure
	elseif Unite_Prog3_T == 2
        C_appel_h_Prog3 = Prog3_Q_E / Prog3_T_h; % Calcul du nombre moyen d'appels par heure
    	set(handles.Prog3_C,'String',C_appel_h_Prog3); % Affiche le rÃ©sultat du nombre d'appels par heure
    elseif Unite_Prog3_T == 3
        C_appel_h_Prog3 = Prog3_Q_E / Prog3_T_h; % Calcul du nombre moyen d'appels par heure
        set(handles.Prog3_C,'String',C_appel_h_Prog3); % Affiche le rÃ©sultat du nombre d'appels par heure
    else
        errordlg('Choisissez l''unitÃ© de la durÃ©e d''un appel','File Error');
    end
end

% --- Executes on button press in Prog3_effacer.
function Prog3_effacer_Callback(hObject, eventdata, handles)
% hObject    handle to Prog3_effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entrÃ©e du 3eme sous-programme :

set(handles.Prog3_N, 'String', ''); % Efface la valeur du nombre de lignes
set(handles.Prog3_Q, 'String', ''); % Efface la valeur du trafic
set(handles.Prog3_C, 'String', ''); % Efface la valeur du trafic
set(handles.Prog3_T, 'String', ''); % Efface la valeur du trafic

% Effacer les valeurs de sortie du 3eme sous-programme :

set(handles.Prog3_P_Pourcent, 'String', ''); % Efface la valeur de la probabilitÃ© de blocage
set(handles.Choix_Prog3_Unite_T, 'Value', 1); % Remet le popumenu "UnitÃ© T" Ã  l'Ã©tat initial





% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all; % Fermeture du programme au complet


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal % Retour au menu principal
close Dim_ProbaBlocage_Nlignes_Qtrafic % Fermeture du programme 'Dim_ProbaBlocage_Nlignes_Qtrafic'
