function varargout = Debit_max(varargin)
% DEBIT_MAX MATLAB code for Debit_max.fig
%      Liste des programmes :
%           - Première interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilité
%           - Température et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des réseaux cellulaires
%           - Débit maximal 
%
%DEBIT_MAX, by itself, creates a new DEBIT_MAX or raises the existing
%      singleton*.
%
%      H = DEBIT_MAX returns the handle to a new DEBIT_MAX or the handle to
%      the existing singleton*.
%
%      DEBIT_MAX('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DEBIT_MAX.M with the given input arguments.
%
%      DEBIT_MAX('Property','Value',...) creates a new DEBIT_MAX or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Debit_max_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Debit_max_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Debit_max

% Last Modified by GUIDE v2.5 14-Aug-2020 11:17:51

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Debit_max_OpeningFcn, ...
                   'gui_OutputFcn',  @Debit_max_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Debit_max is made visible.
function Debit_max_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Debit_max (see VARARGIN)

% Choose default command line output for Debit_max
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

imshow('Formule_Debit_max_5G.png','Parent', handles.image_Formule_Debit_max_5G, 'InitialMagnification','fit') % Image affichée sur l'interface graphique

% UIWAIT makes Debit_max wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Debit_max_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function v_Callback(hObject, eventdata, handles)
% hObject    handle to v (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v as text
%        str2double(get(hObject,'String')) returns contents of v as a double


% --- Executes during object creation, after setting all properties.
function v_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_valeur_J.
function Choix_valeur_J_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_valeur_J (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_valeur_J contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_valeur_J
switch get(handles.Choix_valeur_J,'Value')   
	case 2
        value_J = 1; % J=1
 
	case 3
        value_J = 2; % J=2

    case 4
        value_J = 3; % J=3

    case 5
        value_J = 4; % J=4

    case 6
        value_J = 5; % J=5
        
	case 7
        value_J = 6; % J=6
 
	case 8
        value_J = 7; % J=7

    case 9
        value_J = 8; % J=8

    case 10
        value_J = 9; % J=9

    case 11
        value_J = 10; % J=10
        
	case 12
        value_J = 11; % J=11
 
	case 13
        value_J = 12; % J=12

    case 14
        value_J = 13; % J=13

    case 15
        value_J = 14; % J=14

    case 16
        value_J = 15; % J=15
        
    case 17
        value_J = 16; % J=16
        
    otherwise
    	errordlg('Choisissez la valeur de J','File Error');

end
set(handles.Choix_valeur_J, 'UserData', value_J);


% --- Executes during object creation, after setting all properties.
function Choix_valeur_J_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_valeur_J (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Q_m_Callback(hObject, eventdata, handles)
% hObject    handle to Q_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q_m as text
%        str2double(get(hObject,'String')) returns contents of Q_m as a double


% --- Executes during object creation, after setting all properties.
function Q_m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function M_Callback(hObject, eventdata, handles)
% hObject    handle to M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M as text
%        str2double(get(hObject,'String')) returns contents of M as a double


% --- Executes during object creation, after setting all properties.
function M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_modulation.
function Choix_modulation_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_modulation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_modulation contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_modulation
switch get(handles.Choix_modulation,'Value')   
	case 2
        Choix_mod = 1; % Modulation ASK
        
	case 3
        Choix_mod = 2; % Modulation FSK
        
	case 4
        Choix_mod = 3; % Modulation OFSK
        
	case 5
        Choix_mod = 4; % Modulation PSK
        
	case 6
        Choix_mod = 5; % Modulation DPSK
        set(handles.M,'String','2'); % Fixe M = 2

	case 7
        Choix_mod = 6; % Modulation OQPSK
        set(handles.M,'String','4'); % Fixe M=4

	case 8
        Choix_mod = 7; % Modulation QAM
        value_M = isempty(get(handles.M,'String'));
        if value_M ==0 % Si M renseignée
            M_value = str2double(get(handles.M,'String'));  
            if M_value == 2 % Si M = 2
                errordlg('Valeur minimale d''une modulation M-QAM est M=4','File Error'); % retourne un message d'erreur
            end
        end
        
    otherwise
        errordlg('Choisissez le mode de modulation','File Error');
end
set(handles.Choix_modulation, 'UserData', Choix_mod);


% --- Executes during object creation, after setting all properties.
function Choix_modulation_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_modulation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function f_autre_Callback(hObject, eventdata, handles)
% hObject    handle to f_autre (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of f_autre as text
%        str2double(get(hObject,'String')) returns contents of f_autre as a double


% --- Executes during object creation, after setting all properties.
function f_autre_CreateFcn(hObject, eventdata, handles)
% hObject    handle to f_autre (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in f_defaut_checkbox.
function f_defaut_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to f_defaut_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of f_defaut_checkbox
value_f = get(handles.f_defaut_checkbox, 'Value') ;
if value_f == 1 % Si f=1 a été cochée
    set(handles.f_autre_checkbox, 'Enable', 'off'); % Rendre la sélection de f autre non possible
    set(handles.f_autre, 'Enable', 'off'); % Rendre le remplissage de f autre non possible
else % Si f=1 n'a pas été cochée
    set(handles.f_autre_checkbox, 'Enable', 'on'); % Rendre la sélection de f autre possible
    set(handles.f_autre, 'Enable', 'on'); % Rendre le remplissage de f autre  possible    
end

% --- Executes on button press in f_autre_checkbox.
function f_autre_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to f_autre_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of f_autre_checkbox
value_f_autre = get(handles.f_autre_checkbox, 'Value') ;
if value_f_autre == 1 % Si f autre a été cochée
    set(handles.f_defaut_checkbox, 'Enable', 'off'); % Rendre la sélection de f=1 non possible
else % Si f autre n'a pas été cochée
    set(handles.f_defaut_checkbox, 'Enable', 'on'); % Rendre la sélection de f=1 possible
end

% --- Executes on selection change in Choix_valeur_mu.
function Choix_valeur_mu_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_valeur_mu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_valeur_mu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_valeur_mu
switch get(handles.Choix_valeur_mu,'Value')   
	case 2
        value_mu = 1; % µ=0 : 15 kHz
 
	case 3
        value_mu = 2; % µ=1 : 30 kHz

    case 4
        value_mu = 3; % µ=2 : 60 kHz

    case 5
        value_mu = 4; % µ=3 : 120 kHz

    case 6
        value_mu = 5; % µ=4 : 240 kHz

    otherwise
    	errordlg('Choisissez la valeur de µ','File Error');

end
set(handles.Choix_valeur_mu, 'UserData', value_mu);


% --- Executes during object creation, after setting all properties.
function Choix_valeur_mu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_valeur_mu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function R_max_autre_Callback(hObject, eventdata, handles)
% hObject    handle to R_max_autre (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of R_max_autre as text
%        str2double(get(hObject,'String')) returns contents of R_max_autre as a double


% --- Executes during object creation, after setting all properties.
function R_max_autre_CreateFcn(hObject, eventdata, handles)
% hObject    handle to R_max_autre (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in R_max_defaut_checkbox.
function R_max_defaut_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to R_max_defaut_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of R_max_defaut_checkbox
value_R_max = get(handles.R_max_defaut_checkbox, 'Value') ;
if value_R_max == 1 % Si Rmax par défaut a été cochée
    set(handles.R_max_autre_checkbox, 'Enable', 'off'); % Rendre la coche "Rmax autre" non cochable
    set(handles.R_max_autre, 'Enable', 'off'); % Rendre la case "Rmax autre" non remplissable
else % Si Rmax par défaut n'a pas été cochée
    set(handles.R_max_autre_checkbox, 'Enable', 'on'); % Rendre la coche "Rmax autre" cochable
    set(handles.R_max_autre, 'Enable', 'on');  % Rendre la case "Rmax autre"  remplissable  
end

% --- Executes on button press in R_max_autre_checkbox.
function R_max_autre_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to R_max_autre_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of R_max_autre_checkbox

value_R_max_autre = get(handles.R_max_autre_checkbox, 'Value') ;
if value_R_max_autre == 1 % Si Rmax autre a été cochée
    set(handles.R_max_defaut_checkbox, 'Enable', 'off'); % Rendre la coche "Rmax par défaut" non cochable
else % Si Rmax autre n'a pas été cochée
    set(handles.R_max_defaut_checkbox, 'Enable', 'on'); % Rendre la coche "Rmax par défaut" cochable
end

function N_PRB_Callback(hObject, eventdata, handles)
% hObject    handle to N_PRB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_PRB as text
%        str2double(get(hObject,'String')) returns contents of N_PRB as a double


% --- Executes during object creation, after setting all properties.
function N_PRB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_PRB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BW_Callback(hObject, eventdata, handles)
% hObject    handle to BW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BW as text
%        str2double(get(hObject,'String')) returns contents of BW as a double


% --- Executes during object creation, after setting all properties.
function BW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_unite_BW.
function Choix_unite_BW_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_unite_BW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_unite_BW contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_unite_BW
switch get(handles.Choix_unite_BW,'Value')   
	case 2
        unite_BW = 1; % unité en Hz
 
	case 3
        unite_BW = 2; % unité en kHz

    case 4
        unite_BW = 3; % unité en MHz

    case 5
        unite_BW = 4; % unité en GHz

    otherwise
        value_BW = isempty(get(handles.BW,'String'));
        if value_BW == 0 % Si la bande passante a été renseignée
            errordlg('Choisissez l''unité de la bande passante','File Error');
        end

end
set(handles.Choix_unite_BW, 'UserData', unite_BW);


% --- Executes during object creation, after setting all properties.
function Choix_unite_BW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_unite_BW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_valeur_OH.
function Choix_valeur_OH_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_valeur_OH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_valeur_OH contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_valeur_OH
switch get(handles.Choix_valeur_OH,'Value')   
	case 2
        value_OH = 1; % OH = 0.14 pour FR1 , DL
 
	case 3
        value_OH = 2; % OH = 0.18 pour FR2 , DL

    case 4
        value_OH = 3; % OH = 0.08 pour FR1 , UL

    case 5
        value_OH = 4; % OH = 0.10 pour FR2 , UL

    otherwise
    	errordlg('Choisissez la valeur de OH','File Error');

end
set(handles.Choix_valeur_OH, 'UserData', value_OH);


% --- Executes during object creation, after setting all properties.
function Choix_valeur_OH_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_valeur_OH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Debit_max_Mega_Callback(hObject, eventdata, handles)
% hObject    handle to Debit_max_Mega (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Debit_max_Mega as text
%        str2double(get(hObject,'String')) returns contents of Debit_max_Mega as a double


% --- Executes during object creation, after setting all properties.
function Debit_max_Mega_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Debit_max_Mega (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Liaison_DL_ou_UL_Callback(hObject, eventdata, handles)
% hObject    handle to Liaison_DL_ou_UL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Liaison_DL_ou_UL as text
%        str2double(get(hObject,'String')) returns contents of Liaison_DL_ou_UL as a double


% --- Executes during object creation, after setting all properties.
function Liaison_DL_ou_UL_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Liaison_DL_ou_UL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Debit_max_Giga_Callback(hObject, eventdata, handles)
% hObject    handle to Debit_max_Giga (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Debit_max_Giga as text
%        str2double(get(hObject,'String')) returns contents of Debit_max_Giga as a double


% --- Executes during object creation, after setting all properties.
function Debit_max_Giga_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Debit_max_Giga (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Récupération de la valeur de J :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_J = get(handles.Choix_valeur_J,'UserData');

if value_J == 1 | value_J == 2 | value_J == 3 | value_J == 4 | value_J == 5 | value_J == 6 | value_J == 7 | value_J == 7 | value_J == 8 | value_J == 9 | value_J == 10 | value_J == 11 | value_J == 12 | value_J == 13 | value_J == 14 | value_J == 15 | value_J == 16 % Si la valeur de J a été choisie
    J = value_J ;
else
    errordlg('Choisir le nombre de porteuses agrégées J','File Error') % Message d'erreur : Choisir la valeur de J
end


% Récupération de la valeur de v_layers :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_v = isempty(get(handles.v,'String'));

if value_v == 0 % Si la valeur de v_layers a été renseignée
	v_value = str2double(get(handles.v,'String')); % Récupération de la valeur de v_layers
else
    errordlg('Renseigner la valeur de v_layers','File Error') % Message d'erreur : Renseigner la valeur de v_layers
end


% Récupération ou Calcul de la valeur de Q_m :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_Q_m = isempty(get(handles.Q_m,'String'));
value_M = isempty(get(handles.M,'String'));

if value_Q_m == 0 && value_M == 1 % Si la valeur de Q_m a été renseignée mais pas la valeur de M
	Q_m_value = str2double(get(handles.Q_m,'String')); % Récupération de la valeur de Q_m
    M_calculer = 2^(Q_m_value);
    set(handles.M,'String',M_calculer); % Affiche la valeur de M calculée

elseif value_Q_m == 0 && value_M == 0 % Si Q_m et M ont été renseignées
    Q_m_value = str2double(get(handles.Q_m,'String')); % Récupération de la valeur de Q_m
    M_value = str2double(get(handles.M,'String')); % Récupération de la valeur de M   
	if M_value ~= 2^(Q_m_value)
        set(handles.Q_m,'String',Q_m_value); % Affiche la valeur de Q_m
        M_calculer = 2^(Q_m_value);
        set(handles.M,'String',M_calculer);
	end
    
elseif value_Q_m == 1 && value_M == 0 % Si Q_M n'a pas été renseignée mais M a été renseignée
	M_value = str2double(get(handles.M,'String')); % Récupération de la valeur de M
	for i = 1 : 12
        if M_value ~= 2^(i)
            M_non_accept = i;
        else
            M_non_accept = [];
            Q_m_value = log2 (M_value) ; % Calcul de la valeur de Q_m
            set(handles.Q_m,'String',Q_m_value); % Affiche la valeur de Q_m
            break;
        end
	end
	if isempty(M_non_accept) == 0
        errordlg('Valeur de M non acceptable (M = 2^(Q_m) doit être un entier positif non nul)','File Error');
	end

else % Si ni Q_m ni M n'ont été renseignées
	errordlg('Renseigner soit la valeur de Q_m soit la valeur de M','File Error') % Message d'erreur : Renseigner la valeur de Q_m ou la valeur de M
end
    
% Récupération de la valeur de f :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_f = get(handles.f_defaut_checkbox, 'Value') ;
value_f_autre = get(handles.f_autre_checkbox, 'Value') ;
value_f_autre_case = isempty(get(handles.f_autre,'String'));

if value_f == 1 % Si f=1 a été cochée
    f_value = 1;
end
if value_f_autre == 1 % Si f autre a été cochée
	if value_f_autre_case == 0 % Si f autre a été renseignée
        f_autre_case_value = str2double(get(handles.f_autre,'String')); % Récupération de la valeur de f autre
        f_value = f_autre_case_value ;
        if f_autre_case_value > 1
        	errordlg('La valeur de f doit être comprise entre 0.4 et 1','File Error') % Message d'erreur : La valeur de f doit être comprise entre 0.4 et 1
        end
        if f_autre_case_value < 0.4
        	errordlg('La valeur de f doit être comprise entre 0.4 et 1','File Error') % Message d'erreur : La valeur de f doit être comprise entre 0.4 et 1
        end
	else
        errordlg('Renseigner la valeur de f','File Error') % Message d'erreur : Renseigner la valeur de f
	end
end
if value_f == 0 && value_f_autre == 0 % Si ni f=1 ni f autre n'ont été sélectionnées
	errordlg('Cocher l''une des deux cases  : soit f=1 (valeur par défaut) soit une autre valeur de f','File Error') % Message d'erreur : Cocher l'une des deux cases (f par défaut ou f autre valeur)
end
    

% Récupération de la valeur de R max :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_R_max = get(handles.R_max_defaut_checkbox, 'Value') ;
value_R_max_autre = get(handles.R_max_autre_checkbox, 'Value') ;
value_R_max_autre_case = isempty(get(handles.R_max_autre,'String'));

if value_R_max == 1 % Si R max par défaut a été cochée
    R_max_value = 948 / 1024 ;
end
if value_R_max_autre == 1 % Si R max autre a été cochée
	if value_R_max_autre_case == 0 % Si R max autre a été renseignée
        R_max_autre_case_value = str2double(get(handles.R_max_autre,'String')); % Récupération de la valeur de R max autre
        R_max_value = R_max_autre_case_value ;
	else
        errordlg('Renseigner la valeur de R max','File Error') % Message d'erreur : Renseigner la valeur de R max
	end
end
if value_R_max == 0 && value_R_max_autre == 0 % Si ni R max par défaut ni R max autre n'ont été sélectionnées
	errordlg('Cocher l''une des deux cases  : soit R_max (valeur par défaut) soit une autre valeur de R_max','File Error') % Message d'erreur : Cocher l'une des deux cases (R max par défaut ou R max autre valeur)
end
               

% Récupération de la valeur de mu :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_mu = get(handles.Choix_valeur_mu,'UserData');

if value_mu == 1 | value_mu == 2 | value_mu == 3 | value_mu == 4  | value_mu == 5 % Si la valeur de mu a été choisie
	mu = value_mu - 1 ;
else % Si la valeur de mu n'a pas été choisie
    errordlg('Choisir la valeur de µ','File Error') % Message d'erreur : Choisir la valeur de µ
end


% Récupération de la valeur de OH + Affichage si liaison UL ou liaison DL :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_OH = get(handles.Choix_valeur_OH,'UserData');

if value_OH == 1 | value_OH == 2 | value_OH == 3 | value_OH == 4 % Si la valeur de OH a été choisie
    if value_OH == 1 % Cas FR1 ; DL
        OH = 0.14 ;
        set(handles.Liaison_DL_ou_UL,'String','en amont (DL)','BackgroundColor','red','fontweight', 'bold'); % Liaison DL   
    end
    if value_OH == 2 % Cas FR2 ; DL
        OH = 0.18 ;
        set(handles.Liaison_DL_ou_UL,'String','en amont (DL)','BackgroundColor','red','fontweight', 'bold'); % Liaison DL  
    end
	if value_OH == 3 % Cas FR1 ; UL
        OH = 0.08 ;
        set(handles.Liaison_DL_ou_UL,'String','en aval (UL)','BackgroundColor','red','fontweight', 'bold'); % Liaison UL  
	end
    if value_OH == 4 % Cas FR2 ; UL
        OH = 0.10 ;
        set(handles.Liaison_DL_ou_UL,'String','en aval (UL)','BackgroundColor','red','fontweight', 'bold'); % Liaison UL  
    end
else % Si la valeur de OH n'a pas été choisie
    errordlg('Sélectionner la valeur de OH','File Error') % Message d'erreur : Sélectionner la valeur de OH
end


% Récupération de la valeur de N_PRB :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_N_PRB = isempty(get(handles.N_PRB,'String'));
value_BW = isempty(get(handles.BW,'String'));
unite_BW = get(handles.Choix_unite_BW,'UserData');

if value_N_PRB == 0 % Si la valeur de N_PRB a été renseignée
	N_PRB_value = str2double(get(handles.N_PRB,'String')); % Récupération de la valeur de N_PRB
    N_PRB = N_PRB_value ;
else % Si la valeur de N_PRB n'a pas été renseignée
	if value_BW == 0 % Si la bande passante a été renseignée
        BW_value = str2double(get(handles.BW,'String')); % Récupération de la valeur de la bande passante
        if unite_BW == 1 | unite_BW == 2 | unite_BW == 3 | unite_BW == 4 % Si l'unité de la bande passante a été renseignée
            if unite_BW == 1 % Unité en Hz
                BW = BW_value ;
            end
            if unite_BW == 2 % Unité en kHz
                BW = BW_value * 10^(3); % Conversion de la bande passante des kHz aux Hz
            end
            if unite_BW == 3 % Unité en MHz
                BW = BW_value * 10^(6); % Conversion de la bande passante des MHz aux Hz
            end
            if unite_BW == 4 % Unité en GHz
                BW = BW_value * 10^(9); % Conversion de la bande passante des GHz aux Hz
            end
        else
            errordlg('Sélectionner l''unité de la bande passante','File Error') % Message d'erreur : Sélectionner l'unité de la bande passante
        end
        if mu == 0
        	N_PRB = BW / (12 * 15 * 10^(3)) ; % Calcul de N_PRB = BW / (Nombre de ss-porteuses * BW_ss-porteuse )
        end
        if mu == 1
        	N_PRB = BW / (12 * 30 * 10^(3)) ; % Calcul de N_PRB = BW / (Nombre de ss-porteuses * BW_ss-porteuse )
        end
        if mu == 2
        	N_PRB = BW / (12 * 60 * 10^(3)) ; % Calcul de N_PRB = BW / (Nombre de ss-porteuses * BW_ss-porteuse )
        end
        if mu == 3
        	N_PRB = BW / (12 * 120 * 10^(3)) ; % Calcul de N_PRB = BW / (Nombre de ss-porteuses * BW_ss-porteuse )
        end
        if mu == 4
        	N_PRB = BW / (12 * 240 * 10^(3)) ; % Calcul de N_PRB = BW / (Nombre de ss-porteuses * BW_ss-porteuse )
        end
        set(handles.N_PRB,'String',N_PRB); % Affiche la valeur de N_PRB calculée
    else % Si la bande passante n'a pas été renseignée
        errordlg('Renseigner la valeur de N_PRB ou bien renseigner la valeur de la bande passante','File Error') % Message d'erreur : Renseigner soit la valeur de N_PRB soit la valeur de BW
    end
end


% Calcul du débit en Mbit/s :


sum = 0; % Initialisation de la somme
    for i = 1 : J
        sum = sum + (v_value * Q_m_value * f_value * R_max_value * 14 * 2^(mu) * 12 * N_PRB * (1 - OH) )/ (10^(-3)); % Calcul de la somme 
    end
       
D_Mbits = 10^(-6) * sum ; % Débit maximal en Mbits/s
set(handles.Debit_max_Mega,'String',D_Mbits); % Affiche la valeur du débit max en Mbits/s

% Conversion du débit des Mbits/s en Gbits/s :

D_Gbits = D_Mbits * 10^(-3) ;
set(handles.Debit_max_Giga,'String',D_Gbits); % Affiche la valeur du débit max en Gbits/s


% --- Executes on button press in effacer.
function effacer_Callback(hObject, eventdata, handles)
% hObject    handle to effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Efface les valeurs du programme :

set(handles.Choix_valeur_J, 'Value', 1); % Remet le popumenu "Choisir la valeur de J" àl'état initial
set(handles.v, 'String', ''); % Efface la valeur de v_layers
set(handles.Q_m, 'String', ''); % Efface la valeur de Q_m
set(handles.M, 'String', ''); % Efface la valeur de M
set(handles.Choix_modulation, 'Value', 1); % Remet le popumenu "Choisir le type de modulation"à l'état initial
set(handles.f_defaut_checkbox, 'Value', 0); % Efface la sélection du checkbox "f=1 (valeur par défaut)"
set(handles.f_autre_checkbox, 'Value', 0); % Remet le popumenu "Choisir le type de modulation"à l'état initial
set(handles.f_defaut_checkbox, 'Enable', 'on'); % Réactive la sélection du checkbox "f=1 (valeur par défaut)"
set(handles.f_autre_checkbox, 'Enable', 'on'); % Réactive la sélection du checkbox "f=autre choix"
set(handles.f_autre, 'Enable', 'on'); % Réactive le remplissage de "f=autre choix"
set(handles.f_autre, 'String', ''); % Efface la valeur de f_autre
set(handles.Choix_valeur_mu, 'Value', 1); % Remet le popumenu "Choisir la valeur de mu" àl'état initial
set(handles.R_max_defaut_checkbox, 'Value', 0); % Efface la sélection du checkbox "R (valeur par défaut)"
set(handles.R_max_autre_checkbox, 'Value', 0); % Efface la sélection du checkbox "R=autre choix"
set(handles.R_max_defaut_checkbox, 'Enable', 'on'); % Réactive la sélection du checkbox "R (valeur par défaut)"
set(handles.R_max_autre_checkbox, 'Enable', 'on'); % Réactive la sélection du checkbox "R=autre choix"
set(handles.R_max_autre, 'Enable', 'on'); % Réactive le remplissage de "Rmax=autre choix"
set(handles.R_max_autre, 'String', ''); % Efface la valeur de R_max autre
set(handles.N_PRB, 'String', ''); % Efface la valeur de N_PRB
set(handles.BW, 'String', ''); % Efface la valeur de la bande passante
set(handles.Choix_unite_BW, 'Value', 1); % Remet le popumenu "Choisir l'unité de la bande passante" àl'état initial
set(handles.Choix_valeur_OH, 'Value', 1); % Remet le popumenu "Choisir la valeur de OH" àl'état initial
set(handles.Liaison_DL_ou_UL, 'String', '','BackgroundColor',[0.94 0.94 0.94]); % Efface le texte 'en amont' ou 'en aval'


% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

close all; % Fermeture du programme au complet

% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal % Retour au menu principal
close Debit_max  % Fermeture du programme 'Debit_max'
