function varargout = Temperature_FigureBruit_Equivalentes(varargin)
% Temperature_FigureBruit_Equivalentes MATLAB code for Temperature_FigureBruit_Equivalentes.fig
%      Liste des programmes :
%           - Premire interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilit
%           - Temprature et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des rseaux cellulaires
%           - Dbit maximal 
%
%      Temperature_FigureBruit_Equivalentes, by itself, creates a new Temperature_FigureBruit_Equivalentes or raises the existing
%      singleton*.
%
%      H = Temperature_FigureBruit_Equivalentes returns the handle to a new Temperature_FigureBruit_Equivalentes or the handle to
%      the existing singleton*.
%
%      Temperature_FigureBruit_Equivalentes('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Temperature_FigureBruit_Equivalentes.M with the given input arguments.
%
%      Temperature_FigureBruit_Equivalentes('Property','Value',...) creates a new Temperature_FigureBruit_Equivalentes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Temperature_FigureBruit_Equivalentes_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Temperature_FigureBruit_Equivalentes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Temperature_FigureBruit_Equivalentes
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 25-Jul-2020 12:43:57

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Temperature_FigureBruit_Equivalentes_OpeningFcn, ...
                   'gui_OutputFcn',  @Temperature_FigureBruit_Equivalentes_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Temperature_FigureBruit_Equivalentes is made visible.
function Temperature_FigureBruit_Equivalentes_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Temperature_FigureBruit_Equivalentes (see VARARGIN)

% Choose default command line output for Temperature_FigureBruit_Equivalentes
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

imshow('Temp_fig_bruit_equiv.png','Parent', handles.image_Temp_fig_bruit_equiv, 'InitialMagnification','fit') % Image affichÃ©e sur l'interface graphique




% UIWAIT makes Temperature_FigureBruit_Equivalentes wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Temperature_FigureBruit_Equivalentes_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function T_A_Callback(hObject, eventdata, handles)
% hObject    handle to T_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_A as text
%        str2double(get(hObject,'String')) returns contents of T_A as a double


% --- Executes during object creation, after setting all properties.
function T_A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function T_Callback(hObject, eventdata, handles)
% hObject    handle to T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T as text
%        str2double(get(hObject,'String')) returns contents of T as a double


% --- Executes during object creation, after setting all properties.
function T_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_Callback(hObject, eventdata, handles)
% hObject    handle to F (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F as text
%        str2double(get(hObject,'String')) returns contents of F as a double


% --- Executes during object creation, after setting all properties.
function F_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_1_Callback(hObject, eventdata, handles)
% hObject    handle to T_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_1 as text
%        str2double(get(hObject,'String')) returns contents of T_1 as a double


% --- Executes during object creation, after setting all properties.
function T_1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_1_Callback(hObject, eventdata, handles)
% hObject    handle to F_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_1 as text
%        str2double(get(hObject,'String')) returns contents of F_1 as a double


% --- Executes during object creation, after setting all properties.
function F_1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_2_Callback(hObject, eventdata, handles)
% hObject    handle to T_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_2 as text
%        str2double(get(hObject,'String')) returns contents of T_2 as a double


% --- Executes during object creation, after setting all properties.
function T_2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_2_Callback(hObject, eventdata, handles)
% hObject    handle to F_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_2 as text
%        str2double(get(hObject,'String')) returns contents of F_2 as a double


% --- Executes during object creation, after setting all properties.
function F_2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_fig_cable.
function Choix_fig_cable_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_fig_cable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_fig_cable contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_fig_cable
value_F = isempty(get(handles.F,'String')); 

if value_F ==0  
    switch get(handles.Choix_fig_cable,'Value')   
        case 2
            Unite_fig_cable = 1; % Unit de la figure de mrite du cble de connexion sans unit
        case 3
            Unite_fig_cable = 2; % Unit de la figure de mrite du cble de connexion en dB
        otherwise
            errordlg('Choisissez l''unit de la figure de bruit du cble de connexion F','File Error');
    end
set(handles.Choix_fig_cable, 'UserData', Unite_fig_cable);
end

% --- Executes during object creation, after setting all properties.
function Choix_fig_cable_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_fig_cable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_fig_ampli2.
function Choix_fig_ampli2_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_fig_ampli2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_fig_ampli2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_fig_ampli2
value_F_2 = isempty(get(handles.F_2,'String')); 

if value_F_2 ==0  
    switch get(handles.Choix_fig_ampli2,'Value')   
        case 2
            Unite_fig_ampli2 = 1; % Unit de la figure de mrite de l'amplificateur A2 sans unit
        case 3
            Unite_fig_ampli2 = 2; % Unit de la figure de mrite de l'amplificateur A2 en dB
        otherwise
            errordlg('Choisissez l''unit de la figure de bruit de l''amplificateur A2 F','File Error');
    end
set(handles.Choix_fig_ampli2, 'UserData', Unite_fig_ampli2);
end

% --- Executes during object creation, after setting all properties.
function Choix_fig_ampli2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_fig_ampli2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_fig_ampli1.
function Choix_fig_ampli1_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_fig_ampli1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_fig_ampli1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_fig_ampli1
value_F_1 = isempty(get(handles.F_1,'String')); 

if value_F_1 ==0  
    switch get(handles.Choix_fig_ampli1,'Value')   
        case 2
            Unite_fig_ampli1 = 1; % Unit de la figure de mrite de l'amplificateur A1 sans unit
        case 3
            Unite_fig_ampli1 = 2; % Unit de la figure de mrite de l'amplificateur A1 en dB
        otherwise
            errordlg('Choisissez l''unit de la figure de bruit de l''amplificateur A1 F','File Error');
    end
set(handles.Choix_fig_ampli1, 'UserData', Unite_fig_ampli1);
end


% --- Executes during object creation, after setting all properties.
function Choix_fig_ampli1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_fig_ampli1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_temp_antenne.
function Choix_temp_antenne_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_temp_antenne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_temp_antenne contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_temp_antenne

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :
value_T_A = isempty(get(handles.T_A,'String')); 

if value_T_A ==0  
    switch get(handles.Choix_temp_antenne,'Value')   
        case 2
            Unite_temp_antenne = 1; % Unit de la temprature de l'antenne en C
        case 3
            Unite_temp_antenne = 2; % Unit de la temprature de l'antenne en K
        otherwise
            errordlg('Choisissez l''unit de la temprature de l''antenne T_A','File Error');
    end
set(handles.Choix_temp_antenne, 'UserData', Unite_temp_antenne);
end


% --- Executes during object creation, after setting all properties.
function Choix_temp_antenne_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_temp_antenne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_temp_cable.
function Choix_temp_cable_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_temp_cable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_temp_cable contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_temp_cable
value_T = isempty(get(handles.T,'String')); 

if value_T ==0  
    switch get(handles.Choix_temp_cable,'Value')   
        case 2
            Unite_temp_cable = 1; % Unit de la temprature du cble de connexion en C
        case 3
            Unite_temp_cable = 2; % Unit de la temprature du cble de connexion en K
        otherwise
            errordlg('Choisissez l''unit de la temprature du cble de connexion T','File Error');
    end
set(handles.Choix_temp_cable, 'UserData', Unite_temp_cable);
end


% --- Executes during object creation, after setting all properties.
function Choix_temp_cable_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_temp_cable (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_temp_ampli1.
function Choix_temp_ampli1_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_temp_ampli1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_temp_ampli1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_temp_ampli1
value_T_1 = isempty(get(handles.T_1,'String')); 

if value_T_1 ==0  
    switch get(handles.Choix_temp_ampli1,'Value')   
        case 2
            Unite_temp_ampli1 = 1; % Unit de la temprature de l'amplificateur A1 en C
        case 3
            Unite_temp_ampli1 = 2; % Unit de la temprature de l'amplificateur A1 en K
        otherwise
            errordlg('Choisissez l''unit de la temprature de l''amplificateur A1 T_1','File Error');
    end
set(handles.Choix_temp_ampli1, 'UserData', Unite_temp_ampli1);
end

% --- Executes during object creation, after setting all properties.
function Choix_temp_ampli1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_temp_ampli1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_temp_ampli2.
function Choix_temp_ampli2_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_temp_ampli2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_temp_ampli2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_temp_ampli2
value_T_2 = isempty(get(handles.T_2,'String')); 

if value_T_2 ==0  
    switch get(handles.Choix_temp_ampli2,'Value')   
        case 2
            Unite_temp_ampli2 = 1; % Unit de la temprature de l'amplificateur A2 en C
        case 3
            Unite_temp_ampli2 = 2; % Unit de la temprature de l'amplificateur A2 en K
        otherwise
            errordlg('Choisissez l''unit de la temprature de l''amplificateur A2 T_2','File Error');
    end
set(handles.Choix_temp_ampli2, 'UserData', Unite_temp_ampli2);
end

% --- Executes during object creation, after setting all properties.
function Choix_temp_ampli2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_temp_ampli2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_A_K_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_A_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_A_K_out as text
%        str2double(get(hObject,'String')) returns contents of T_A_K_out as a double


% --- Executes during object creation, after setting all properties.
function T_A_K_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_A_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_A_C_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_A_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_A_C_out as text
%        str2double(get(hObject,'String')) returns contents of T_A_C_out as a double


% --- Executes during object creation, after setting all properties.
function T_A_C_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_A_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_K_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_K_out as text
%        str2double(get(hObject,'String')) returns contents of T_K_out as a double


% --- Executes during object creation, after setting all properties.
function T_K_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_su_out_Callback(hObject, eventdata, handles)
% hObject    handle to F_su_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_su_out as text
%        str2double(get(hObject,'String')) returns contents of F_su_out as a double


% --- Executes during object creation, after setting all properties.
function F_su_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_su_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_1_K_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_1_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_1_K_out as text
%        str2double(get(hObject,'String')) returns contents of T_1_K_out as a double


% --- Executes during object creation, after setting all properties.
function T_1_K_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_1_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_1_su_out_Callback(hObject, eventdata, handles)
% hObject    handle to F_1_su_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_1_su_out as text
%        str2double(get(hObject,'String')) returns contents of F_1_su_out as a double


% --- Executes during object creation, after setting all properties.
function F_1_su_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_1_su_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_2_K_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_2_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_2_K_out as text
%        str2double(get(hObject,'String')) returns contents of T_2_K_out as a double


% --- Executes during object creation, after setting all properties.
function T_2_K_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_2_K_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_2_su_out_Callback(hObject, eventdata, handles)
% hObject    handle to F_2_su_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_2_su_out as text
%        str2double(get(hObject,'String')) returns contents of F_2_su_out as a double


% --- Executes during object creation, after setting all properties.
function F_2_su_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_2_su_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_C_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_C_out as text
%        str2double(get(hObject,'String')) returns contents of T_C_out as a double


% --- Executes during object creation, after setting all properties.
function T_C_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_1_C_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_1_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_1_C_out as text
%        str2double(get(hObject,'String')) returns contents of T_1_C_out as a double


% --- Executes during object creation, after setting all properties.
function T_1_C_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_1_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_2_C_out_Callback(hObject, eventdata, handles)
% hObject    handle to T_2_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_2_C_out as text
%        str2double(get(hObject,'String')) returns contents of T_2_C_out as a double


% --- Executes during object creation, after setting all properties.
function T_2_C_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_2_C_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_2_dB_out_Callback(hObject, eventdata, handles)
% hObject    handle to F_2_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_2_dB_out as text
%        str2double(get(hObject,'String')) returns contents of F_2_dB_out as a double


% --- Executes during object creation, after setting all properties.
function F_2_dB_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_2_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_1_dB_out_Callback(hObject, eventdata, handles)
% hObject    handle to F_1_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_1_dB_out as text
%        str2double(get(hObject,'String')) returns contents of F_1_dB_out as a double


% --- Executes during object creation, after setting all properties.
function F_1_dB_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_1_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_dB_out_Callback(hObject, eventdata, handles)
% hObject    handle to F_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_dB_out as text
%        str2double(get(hObject,'String')) returns contents of F_dB_out as a double


% --- Executes during object creation, after setting all properties.
function F_dB_out_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_dB_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_e_eq_K_Callback(hObject, eventdata, handles)
% hObject    handle to T_e_eq_K (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_e_eq_K as text
%        str2double(get(hObject,'String')) returns contents of T_e_eq_K as a double


% --- Executes during object creation, after setting all properties.
function T_e_eq_K_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_e_eq_K (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_e_eq_su_Callback(hObject, eventdata, handles)
% hObject    handle to F_e_eq_su (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_e_eq_su as text
%        str2double(get(hObject,'String')) returns contents of F_e_eq_su as a double


% --- Executes during object creation, after setting all properties.
function F_e_eq_su_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_e_eq_su (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function T_e_eq_C_Callback(hObject, eventdata, handles)
% hObject    handle to T_e_eq_C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_e_eq_C as text
%        str2double(get(hObject,'String')) returns contents of T_e_eq_C as a double


% --- Executes during object creation, after setting all properties.
function T_e_eq_C_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_e_eq_C (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function F_e_eq_dB_Callback(hObject, eventdata, handles)
% hObject    handle to F_e_eq_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_e_eq_dB as text
%        str2double(get(hObject,'String')) returns contents of F_e_eq_dB as a double


% --- Executes during object creation, after setting all properties.
function F_e_eq_dB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_e_eq_dB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function A_1_Callback(hObject, eventdata, handles)
% hObject    handle to A_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A_1 as text
%        str2double(get(hObject,'String')) returns contents of A_1 as a double


% --- Executes during object creation, after setting all properties.
function image_Temp_fig_bruit_equiv_CreateFcn(hObject, eventdata, handles)
% hObject    handle to image_Temp_fig_bruit_equiv (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate image_Temp_fig_bruit_equiv


% --- Executes during object creation, after setting all properties.
function A_1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function A_2_Callback(hObject, eventdata, handles)
% hObject    handle to A_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A_2 as text
%        str2double(get(hObject,'String')) returns contents of A_2 as a double


% --- Executes during object creation, after setting all properties.
function A_2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function T_CableConnexion_Callback(hObject, eventdata, handles)
% hObject    handle to T_CableConnexion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of T_CableConnexion as text
%        str2double(get(hObject,'String')) returns contents of T_CableConnexion as a double


% --- Executes during object creation, after setting all properties.
function T_CableConnexion_CreateFcn(hObject, eventdata, handles)
% hObject    handle to T_CableConnexion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function F_CableConnexion_Callback(hObject, eventdata, handles)
% hObject    handle to F_CableConnexion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of F_CableConnexion as text
%        str2double(get(hObject,'String')) returns contents of F_CableConnexion as a double


% --- Executes during object creation, after setting all properties.
function F_CableConnexion_CreateFcn(hObject, eventdata, handles)
% hObject    handle to F_CableConnexion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

T_a = 290 ; % Valeur de la temprature ambiante (en K)

% Conversion de la temprature d'antenne de K en C ou de C en K :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_T_A = isempty(get(handles.T_A,'String')); 
Unite_temp_antenne = get(handles.Choix_temp_antenne,'UserData');

if value_T_A == 0 % Si T_A a ete renseignee
    if Unite_temp_antenne ==1 % Si la température de l'antenne a ete renseigneee en °C 
        T_A_C_value = str2double(get(handles.T_A,'String')); % Recuperation de la valeur de T_A en °C
        T_A_K = T_A_C_value + 273 ; % Conversion de T_A en °K (0C = 273 K)
        set(handles.T_A_K_out,'String',T_A_K); % Affiche le résultat de la température de T_A en sortie en °K
        set(handles.T_A_C_out,'String',T_A_C_value); % Affiche le résultat de la température de T_A en sortie en °C
    elseif Unite_temp_antenne == 2 % Si la température de l'antenne a été renseignée en °K
        T_A_K_value = str2double(get(handles.T_A,'String')); % Récupération de la valeur de T_A en °C
        T_A_C = T_A_K_value - 273 ; % Conversion de T_A en °C (0°C = 273 °K)
        set(handles.T_A_K_out,'String',T_A_K_value); % Affiche le résultat de la température de T_A en sortie en °K
        set(handles.T_A_C_out,'String',T_A_C); % Affiche le résultat de la température de T_A en sortie en °C
    else
        errordlg('Choisir l''unit de la temprature de l''antenne T_A','File Error') % Choisir l'unité de la température de l'antenne
    end
else % Si la temprature T_A n'a pas t renseigne
   errordlg('Renseigner la valeur de la temprature de l''antenne T_A','File Error'); % Renseigner la valeur de la température de l'antenne 
end


% Calcul de la temprature ou de la figure de bruit du cble de connexion et conversion d'units (C/K et su/dB) :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_T = isempty(get(handles.T,'String')); 
value_F = isempty(get(handles.F,'String')); 
Unite_temp_cable = get(handles.Choix_temp_cable,'UserData');
Unite_fig_cable = get(handles.Choix_fig_cable,'UserData');

if value_T == 0 && value_F ==0 % Si la temprature ET la figure de bruit ont t renseignes
    errordlg('Noter que dans le cas o les valeurs de T ET de F ont t renseignes, seule la valeur de T sera utilise dans les calculs de la temprature de bruit et la figure de bruit quivalentes du systme','File Error');
	if Unite_temp_cable ==1 % Si la temprature du cable a ete renseigne en C 
        T_C_value = str2double(get(handles.T,'String')); % Recuperation de la valeur de T en C
        T_K = T_C_value + 273 ; % Conversion de T en K (0C = 273 K)
        set(handles.T_K_out,'String',T_K); % Affiche le rsultat de la temprature de T en sortie en °K
        set(handles.T_C_out,'String',T_C_value); % Affiche le résultat de la temprature de T en sortie en °C
	elseif Unite_temp_cable == 2 % Si la temprature du cable a t renseigne en K
        T_K_value = str2double(get(handles.T,'String')); % Récupération de la valeur de T en °C
        T_C = T_K_value - 273 ; % Conversion de T en C (0C = 273 K)
        set(handles.T_K_out,'String',T_K_value); % Affiche le rsultat de la temprature de T en sortie en °K
        set(handles.T_C_out,'String',T_C); % Affiche le rsultat de la temprature de T en sortie en °C
    else
        errordlg('Choisir l''unit de la temprature du cble de connexion T','File Error') % Choisir l'unit de la temprature du cble de connexion
	end
	if Unite_fig_cable == 1 % Si la figure de bruit du cable a t renseigne sans unit 
        F_su_value = str2double(get(handles.F,'String')); % Recuperation de la valeur de F sans unit
        F_dB = 10 *log10 (F_su_value) ; % Conversion de F en dB
        set(handles.F_su_out,'String',F_su_value); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_dB_out,'String',F_dB); % Affiche le rsultat de la figure de bruit F en sortie en dB
	elseif Unite_fig_cable == 2 % Si la figure de bruit du cable a t renseigne en dB
        F_dB_value = str2double(get(handles.F,'String')); % Rcupration de la valeur de F en dB
        F_su = 10^(F_dB_value/10) ; % Conversion de F sans unit
        set(handles.F_su_out,'String',F_su); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_dB_out,'String',F_dB_value); % Affiche le rsultat de la figure de bruit F en sortie en dB
    else
        errordlg('Choisir l''unit de la figure de bruit du cble de connexion F','File Error') % Choisir l'unit de la figure de bruit du cble de connexion
	end
end

if value_T == 0 && value_F ==1 % Si la temprature a t renseigne mais pas la figure de bruit F du cble de connexion
	if Unite_temp_cable ==1 % Si la temprature du cable a ete renseigne en C 
        T_C_value = str2double(get(handles.T,'String')); % Recuperation de la valeur de T en C
        T_K = T_C_value + 273 ; % Conversion de T en K (0C = 273 K)
        F_su = 1 + (T_K / T_a) ; % Calcul de la figure de bruit du cble sans unit
        F_dB = 10 * log10 (F_su) ; % Conversion de la valeur de la figure de bruit du cble en dB
        set(handles.T_K_out,'String',T_K); % Affiche le rsultat de la temprature de T en sortie en °K
        set(handles.T_C_out,'String',T_C_value); % Affiche le résultat de la temprature de T en sortie en °C
        set(handles.F_su_out,'String',F_su); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_dB_out,'String',F_dB); % Affiche le rsultat de la figure de bruit F en sortie en dB
	elseif Unite_temp_cable == 2 % Si la temprature du cable a t renseigne en K
        T_K_value = str2double(get(handles.T,'String')); % Rcupration de la valeur de T en °C
        T_C = T_K_value - 273 ; % Conversion de T en C (0C = 273 K)
        F_su = 1 + (T_K_value / T_a) ; % Calcul de la figure de bruit du cble sans unit
        F_dB = 10 * log10 (F_su) ; % Conversion de la valeur de la figure de bruit du cble en dB
        set(handles.T_K_out,'String',T_K_value); % Affiche le rsultat de la temprature de T en sortie en °K
        set(handles.T_C_out,'String',T_C); % Affiche le rsultat de la temprature de T en sortie en °C
        set(handles.F_su_out,'String',F_su); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_dB_out,'String',F_dB); % Affiche le rsultat de la figure de bruit F en sortie en dB
    else
        errordlg('Choisir l''unit de la temprature du cble de connexion T','File Error') % Choisir l'unit de la temprature du cble de connexion
	end
end

if value_T == 1 && value_F ==0 % Si la temprature n'a pas t renseigne et la figure de bruit F a t renseigne du cble de connexion
	if Unite_fig_cable == 1 % Si la figure de bruit du cable a t renseigne sans unit 
        F_su_value = str2double(get(handles.F,'String')); % Recuperation de la valeur de F sans unit
        F_dB = 10 *log10 (F_su_value) ; % Conversion de F en dB
        T_K = T_a * (F_su_value - 1) ; % Calcul de la temprature du cble de connexion en K
        T_C = T_K - 273 ; % Conversion de T en C (0C = 273 K)
        set(handles.F_su_out,'String',F_su_value); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_dB_out,'String',F_dB); % Affiche le rsultat de la figure de bruit F en sortie en dB
        set(handles.T_K_out,'String',T_K); % Affiche le rsultat de la temprature de T en sortie en °K
        set(handles.T_C_out,'String',T_C); % Affiche le rsultat de la temprature de T en sortie en °C
	elseif Unite_fig_cable == 2 % Si la figure de bruit du cable a t renseigne en dB
        F_dB_value = str2double(get(handles.F,'String')); % Rcupration de la valeur de F en dB
        F_su = 10^(F_dB_value/10) ; % Conversion de F sans unit
        T_K = T_a * (F_su - 1) ; % Calcul de la temprature du cble de connexion en K
        T_C = T_K - 273 ; % Conversion de T en C (0C = 273 K)
        set(handles.F_su_out,'String',F_su); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_dB_out,'String',F_dB_value); % Affiche le rsultat de la figure de bruit F en sortie en dB
        set(handles.T_K_out,'String',T_K); % Affiche le rsultat de la temprature de T en sortie en °K
        set(handles.T_C_out,'String',T_C); % Affiche le rsultat de la temprature de T en sortie en °C
    else
        errordlg('Choisir l''unit de la figure de bruit du cble de connexion F','File Error') % Choisir l'unit de la figure de bruit du cble de connexion
	end
end

if value_T == 1 && value_F ==1 % Si ni la temprature T ni la figure de bruit F n'ont pas t renseignes
	errordlg('Renseigner la valeur de la temprature du cble T OU la valeur de la figure de bruit du cble F','File Error'); % Renseigner soit la valeur de la temprature soit la valeur de la figure de bruit F du cble de connexion
end

% Calcul de la temprature ou de la figure de bruit de l'amplificateur A1 et conversion d'units (C/K et su/dB) :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_T_1 = isempty(get(handles.T_1,'String')); 
value_F_1 = isempty(get(handles.F_1,'String')); 
Unite_temp_ampli1 = get(handles.Choix_temp_ampli1,'UserData');
Unite_fig_ampli1 = get(handles.Choix_fig_ampli1,'UserData');

if value_T_1 == 0 && value_F_1 ==0 % Si la temprature ET la figure de bruit de l'amplificateur A1 ont t renseignes
    errordlg('Noter que dans le cas o les valeurs de T_1 ET de F_1 ont t renseignes, seule la valeur de T_1 sera utilise dans les calculs de la temprature de bruit et la figure de bruit quivalentes du systme','File Error');
	if Unite_temp_ampli1 ==1 % Si la temprature de l'amplificateur A1 a ete renseigne en C 
        T_1_C_value = str2double(get(handles.T_1,'String')); % Recuperation de la valeur de T_1 en C
        T_1_K = T_1_C_value + 273 ; % Conversion de T_1 en K (0C = 273 K)
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C_value); % Affiche le rsultat de la temprature de T_1 en sortie en C
	elseif Unite_temp_ampli1 == 2 % Si la temprature de l'amplificateur a t renseigne en K
        T_1_K_value = str2double(get(handles.T_1,'String')); % Rcupration de la valeur de T_1 en C
        T_1_C = T_1_K_value - 273 ; % Conversion de T_1 en C (0C = 273 K)
        set(handles.T_1_K_out,'String',T_1_K_value); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
    else
        errordlg('Choisir l''unit de la temprature de l''amplificateur A1 T_1','File Error') % Choisir l'unit de la temprature de l'amplificateur A1
	end
	if Unite_fig_ampli1 == 1 % Si la figure de bruit de l'amplificateur A1 a t renseigne sans unit 
        F_su_value = str2double(get(handles.F,'String')); % Recuperation de la valeur de F_1 sans unit
        F_dB = 10 *log10 (F_su_value) ; % Conversion de F_1 en dB
        set(handles.F_su_out,'String',F_su_value); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_dB_out,'String',F_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
	elseif Unite_fig_ampli1 == 2 % Si la figure de bruit de l'amplificateur A1 a t renseigne en dB
        F_1_dB_value = str2double(get(handles.F_1,'String')); % Rcupration de la valeur de F_1 en dB
        F_1_su = 10^(F_1_dB_value/10) ; % Conversion de F_1 sans unit
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB_value); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
    else
        errordlg('Choisir l''unit de la figure de bruit de l''amplificateur A1 F_1','File Error') % Choisir l'unit de la figure de bruit de l'amplificateur A1
	end
end

if value_T_1 == 0 && value_F_1 ==1 % Si la temprature a t renseigne mais pas la figure de bruit F_1 de l'amplificateur A1
	if Unite_temp_ampli1 ==1 % Si la temprature de l'amplificateur A1 a t renseigne en C 
        T_1_C_value = str2double(get(handles.T_1,'String')); % Rcupration de la valeur de T_1 en C
        T_1_K = T_1_C_value + 273 ; % Conversion de T_1 en K (0C = 273 K)
        F_1_su = 1 + (T_1_K / T_a) ; % Calcul de la figure de bruit de l'amplificateur A1 sans unit
        F_1_dB = 10 * log10 (F_1_su) ; % Conversion de la valeur de la figure de bruit de l'amplificateur A1 en dB
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C_value); % Affiche le rsultat de la temprature de T_1 en sortie en C
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
	elseif Unite_temp_ampli1 == 2 % Si la temprature de l'amplificateur A1 a t renseigne en K
        T_1_K_value = str2double(get(handles.T_1,'String')); % Rcupration de la valeur de T_1 en C
        T_1_C = T_1_K_value - 273 ; % Conversion de T_1 en C (0C = 273 K)
        F_1_su = 1 + (T_1_K_value / T_a) ; % Calcul de la figure de bruit de l'amplificateur A1 sans unit
        F_1_dB = 10 * log10 (F_1_su) ; % Conversion de la valeur de la figure de bruit de l'amplificateur A1 en dB
        set(handles.T_1_K_out,'String',T_1_K_value); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
    else
        errordlg('Choisir l''unit de la temprature de l''amplificateur A1 T_1','File Error') % Choisir l'unit de la temprature de l'amplificateur A1
	end
end

if value_T_1 == 1 && value_F_1 ==0 % Si la temprature n'a pas t renseigne et la figure de bruit F_1 a t renseigne de l'amplificateur A1
	if Unite_fig_ampli1 == 1 % Si la figure de bruit de l'amplificateur A1 a t renseigne sans unit 
        F_1_su_value = str2double(get(handles.F_1,'String')); % Recuperation de la valeur de F_1 sans unit
        F_1_dB = 10 *log10 (F_1_su_value) ; % Conversion de F_1 en dB
        T_1_K = T_a * (F_1_su_value - 1) ; % Calcul de la temprature de l'amplificateur en K
        T_1_C = T_1_K - 273 ; % Conversion de T_1 en C (0C = 273 K)
        set(handles.F_1_su_out,'String',F_1_su_value); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
	elseif Unite_fig_ampli1 == 2 % Si la figure de bruit de l'amplificateur a t renseigne en dB
        F_1_dB_value = str2double(get(handles.F_1,'String')); % Rcupration de la valeur de F_1 en dB
        F_1_su = 10^(F_1_dB_value/10) ; % Conversion de F_1 sans unit
        T_1_K = T_a * (F_1_su - 1) ; % Calcul de la temprature de l'amplificateur A1 en K
        T_1_C = T_1_K - 273 ; % Conversion de T_1 en C (0C = 273 K)
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB_value); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
    else
        errordlg('Choisir l''unit de la figure de bruit de l''amplificateur A1 F_1','File Error') % Choisir l'unit de la figure de bruit de l'amplificateur A1
	end
end

if value_T_1 == 1 && value_F_1 ==1 % Si ni la temprature T_1 ni la figure de bruit F_1 n'ont pas t renseignes
	errordlg('Renseigner la valeur de la temprature de l''amplificateur A1 T_1 OU la valeur de la figure de bruit de l''amplificateur A1 F_1','File Error'); % Renseigner soit la valeur de la temprature soit la valeur de la figure de bruit F_1 de l'amplificateur A1
end

% Calcul de la temprature ou de la figure de bruit de l'amplificateur A1 et conversion d'units (C/K et su/dB) :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_T_1 = isempty(get(handles.T_1,'String')); 
value_F_1 = isempty(get(handles.F_1,'String')); 
Unite_temp_ampli1 = get(handles.Choix_temp_ampli1,'UserData');
Unite_fig_ampli1 = get(handles.Choix_fig_ampli1,'UserData');

if value_T_1 == 0 && value_F_1 ==0 % Si la temprature ET la figure de bruit de l'amplificateur A1 ont t renseignes
    errordlg('Noter que dans le cas o les valeurs de T_1 ET de F_1 ont t renseignes, seule la valeur de T_1 sera utilise dans les calculs de la temprature de bruit et la figure de bruit quivalentes du systme','File Error');
	if Unite_temp_ampli1 ==1 % Si la temprature de l'amplificateur A1 a ete renseigne en C 
        T_1_C_value = str2double(get(handles.T_1,'String')); % Recuperation de la valeur de T_1 en C
        T_1_K = T_1_C_value + 273 ; % Conversion de T_1 en K (0C = 273 K)
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C_value); % Affiche le rsultat de la temprature de T_1 en sortie en C
	elseif Unite_temp_ampli1 == 2 % Si la temprature de l'amplificateur a t renseigne en K
        T_1_K_value = str2double(get(handles.T_1,'String')); % Rcupration de la valeur de T_1 en C
        T_1_C = T_1_K_value - 273 ; % Conversion de T_1 en C (0C = 273 K)
        set(handles.T_1_K_out,'String',T_1_K_value); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
    else
        errordlg('Choisir l''unit de la temprature de l''amplificateur A1 T_1','File Error') % Choisir l'unit de la temprature de l'amplificateur A1
	end
	if Unite_fig_ampli1 == 1 % Si la figure de bruit de l'amplificateur A1 a t renseigne sans unit 
        F_1_su_value = str2double(get(handles.F_1,'String')); % Recuperation de la valeur de F_1 sans unit
        F_1_dB = 10 *log10 (F_1_su_value) ; % Conversion de F_1 en dB
        set(handles.F_1_su_out,'String',F_1_su_value); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
	elseif Unite_fig_ampli1 == 2 % Si la figure de bruit de l'amplificateur A1 a t renseigne en dB
        F_1_dB_value = str2double(get(handles.F_1,'String')); % Rcupration de la valeur de F_1 en dB
        F_1_su = 10^(F_1_dB_value/10) ; % Conversion de F_1 sans unit
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB_value); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
    else
        errordlg('Choisir l''unit de la figure de bruit de l''amplificateur A1 F_1','File Error') % Choisir l'unit de la figure de bruit de l'amplificateur A1
	end
end

if value_T_1 == 0 && value_F_1 ==1 % Si la temprature a t renseigne mais pas la figure de bruit F_1 de l'amplificateur A1
	if Unite_temp_ampli1 ==1 % Si la temprature de l'amplificateur A1 a t renseigne en C 
        T_1_C_value = str2double(get(handles.T_1,'String')); % Rcupration de la valeur de T_1 en C
        T_1_K = T_1_C_value + 273 ; % Conversion de T_1 en K (0C = 273 K)
        F_1_su = 1 + (T_1_K / T_a) ; % Calcul de la figure de bruit de l'amplificateur A1 sans unit
        F_1_dB = 10 * log10 (F_1_su) ; % Conversion de la valeur de la figure de bruit de l'amplificateur A1 en dB
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C_value); % Affiche le rsultat de la temprature de T_1 en sortie en C
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
	elseif Unite_temp_ampli1 == 2 % Si la temprature de l'amplificateur A1 a t renseigne en K
        T_1_K_value = str2double(get(handles.T_1,'String')); % Rcupration de la valeur de T_1 en C
        T_1_C = T_1_K_value - 273 ; % Conversion de T_1 en C (0C = 273 K)
        F_1_su = 1 + (T_1_K_value / T_a) ; % Calcul de la figure de bruit de l'amplificateur A1 sans unit
        F_1_dB = 10 * log10 (F_1_su) ; % Conversion de la valeur de la figure de bruit de l'amplificateur A1 en dB
        set(handles.T_1_K_out,'String',T_1_K_value); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F en sortie en dB
    else
        errordlg('Choisir l''unit de la temprature de l''amplificateur A1 T_1','File Error') % Choisir l'unit de la temprature de l'amplificateur A1
	end
end

if value_T_1 == 1 && value_F_1 ==0 % Si la temprature n'a pas t renseigne et la figure de bruit F_1 a t renseigne de l'amplificateur A1
	if Unite_fig_ampli1 == 1 % Si la figure de bruit de l'amplificateur A1 a t renseigne sans unit 
        F_1_su_value = str2double(get(handles.F_1,'String')); % Recuperation de la valeur de F_1 sans unit
        F_1_dB = 10 *log10 (F_1_su_value) ; % Conversion de F_1 en dB
        T_1_K = T_a * (F_1_su_value - 1) ; % Calcul de la temprature de l'amplificateur en K
        T_1_C = T_1_K - 273 ; % Conversion de T_1 en C (0C = 273 K)
        set(handles.F_1_su_out,'String',F_1_su_value); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en C
	elseif Unite_fig_ampli1 == 2 % Si la figure de bruit de l'amplificateur a t renseigne en dB
        F_1_dB_value = str2double(get(handles.F_1,'String')); % Rcupration de la valeur de F_1 en dB
        F_1_su = 10^(F_1_dB_value/10) ; % Conversion de F_1 sans unit
        T_1_K = T_a * (F_1_su - 1) ; % Calcul de la temprature de l'amplificateur A1 de connexion en K
        T_1_C = T_1_K - 273 ; % Conversion de T_1 en C (0C = 273 K)
        set(handles.F_1_su_out,'String',F_1_su); % Affiche le rsultat de la figure de bruit F_1 en sortie sans unit
        set(handles.F_1_dB_out,'String',F_1_dB_value); % Affiche le rsultat de la figure de bruit F_1 en sortie en dB
        set(handles.T_1_K_out,'String',T_1_K); % Affiche le rsultat de la temprature de T_1 en sortie en °K
        set(handles.T_1_C_out,'String',T_1_C); % Affiche le rsultat de la temprature de T_1 en sortie en °C
    else
        errordlg('Choisir l''unit de la figure de bruit de l''amplificateur A1 F_1','File Error') % Choisir l'unit de la figure de bruit de l'amplificateur A1
	end
end

if value_T_1 == 1 && value_F_1 ==1 % Si ni la temprature T_1 ni la figure de bruit F_1 n'ont pas t renseignes
	errordlg('Renseigner la valeur de la temprature de l''amplificateur A1 T_1 OU la valeur de la figure de bruit de l''amplificateur A1 F_1','File Error'); % Renseigner soit la valeur de la temprature soit la valeur de la figure de bruit F_1 de l'amplificateur A1
end

% Calcul de la temprature ou de la figure de bruit de l'amplificateur A2 et conversion d'units (C/K et su/dB) :

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_T_2 = isempty(get(handles.T_2,'String')); 
value_F_2 = isempty(get(handles.F_2,'String')); 
Unite_temp_ampli2 = get(handles.Choix_temp_ampli2,'UserData');
Unite_fig_ampli2 = get(handles.Choix_fig_ampli2,'UserData');

if value_T_2 == 0 && value_F_2 ==0 % Si la temprature ET la figure de bruit de l'amplificateur A2 ont t renseignes
    errordlg('Noter que dans le cas o les valeurs de T_2 ET de F_2 ont t renseignes, seule la valeur de T_2 sera utilise dans les calculs de la temprature de bruit et la figure de bruit quivalentes du systme','File Error');
	if Unite_temp_ampli2 ==1 % Si la temprature de l'amplificateur A2 a ete renseigne en C 
        T_2_C_value = str2double(get(handles.T_2,'String')); % Recuperation de la valeur de T_2 en C
        T_2_K = T_2_C_value + 273 ; % Conversion de T_2 en K (0C = 273 K)
        set(handles.T_2_K_out,'String',T_2_K); % Affiche le rsultat de la temprature de T_2 en sortie en K
        set(handles.T_2_C_out,'String',T_2_C_value); % Affiche le rsultat de la temprature de T_2 en sortie en C
	elseif Unite_temp_ampli2 == 2 % Si la temprature de l'amplificateur a t renseigne en K
        T_2_K_value = str2double(get(handles.T_2,'String')); % Rcupration de la valeur de T_2 en C
        T_2_C = T_2_K_value - 273 ; % Conversion de T_2 en C (0C = 273 K)
        set(handles.T_2_K_out,'String',T_2_K_value); % Affiche le rsultat de la temprature de T_2 en sortie en K
        set(handles.T_2_C_out,'String',T_2_C); % Affiche le rsultat de la temprature de T_2 en sortie en C
    else
        errordlg('Choisir l''unit de la temprature de l''amplificateur A2 T_2','File Error') % Choisir l'unit de la temprature de l'amplificateur A2
	end
	if Unite_fig_ampli2 == 1 % Si la figure de bruit de l'amplificateur A2 a t renseigne sans unit 
        F_2_su_value = str2double(get(handles.F_2,'String')); % Recuperation de la valeur de F_2 sans unit
        F_2_dB = 10 *log10 (F_2_su_value) ; % Conversion de F_2 en dB
        set(handles.F_2_su_out,'String',F_2_su_value); % Affiche le rsultat de la figure de bruit F_2 en sortie sans unit
        set(handles.F_2_dB_out,'String',F_2_dB); % Affiche le rsultat de la figure de bruit F_2 en sortie en dB
	elseif Unite_fig_ampli2 == 2 % Si la figure de bruit de l'amplificateur A2 a t renseigne en dB
        F_2_dB_value = str2double(get(handles.F_2,'String')); % Rcupration de la valeur de F_2 en dB
        F_2_su = 10^(F_2_dB_value/10) ; % Conversion de F_2 sans unit
        set(handles.F_2_su_out,'String',F_2_su); % Affiche le rsultat de la figure de bruit F_2 en sortie sans unit
        set(handles.F_2_dB_out,'String',F_2_dB_value); % Affiche le rsultat de la figure de bruit F_2 en sortie en dB
    else
        errordlg('Choisir l''unit de la figure de bruit de l''amplificateur A2 F_2','File Error') % Choisir l'unit de la figure de bruit de l'amplidicateur A2
	end
end

if value_T_2 == 0 && value_F_2 ==1 % Si la temprature a t renseigne mais pas la figure de bruit F_2 de l'amplificateur A2
	if Unite_temp_ampli2 ==1 % Si la temprature de l'amplificateur A2 a t renseigne en C 
        T_2_C_value = str2double(get(handles.T_2,'String')); % Rcupration de la valeur de T_2 en C
        T_2_K = T_2_C_value + 273 ; % Conversion de T_2 en K (0C = 273 K)
        F_2_su = 1 + (T_2_K / T_a) ; % Calcul de la figure de bruit de l'amplificateur A2 sans unit
        F_2_dB = 10 * log10 (F_2_su) ; % Conversion de la valeur de la figure de bruit de l'amplificateur A2 en dB
        set(handles.T_2_K_out,'String',T_2_K); % Affiche le rsultat de la temprature de T_2 en sortie en K
        set(handles.T_2_C_out,'String',T_2_C_value); % Affiche le rsultat de la temprature de T_2 en sortie en C
        set(handles.F_2_su_out,'String',F_2_su); % Affiche le rsultat de la figure de bruit F_2 en sortie sans unit
        set(handles.F_2_dB_out,'String',F_2_dB); % Affiche le rsultat de la figure de bruit F_2 en sortie en dB
	elseif Unite_temp_ampli2 == 2 % Si la temprature de l'amplificateur A2 a t renseigne en K
        T_2_K_value = str2double(get(handles.T_2,'String')); % Rcupration de la valeur de T_2 en C
        T_2_C = T_2_K_value - 273 ; % Conversion de T_2 en C (0C = 273 K)
        F_2_su = 1 + (T_2_K_value / T_a) ; % Calcul de la figure de bruit de l'amplificateur A2 sans unit
        F_2_dB = 10 * log10 (F_2_su) ; % Conversion de la valeur de la figure de bruit de l'amplificateur A2 en dB
        set(handles.T_2_K_out,'String',T_2_K_value); % Affiche le rsultat de la temprature de T_2 en sortie en K
        set(handles.T_2_C_out,'String',T_2_C); % Affiche le rsultat de la temprature de T_2 en sortie en C
        set(handles.F_2_su_out,'String',F_2_su); % Affiche le rsultat de la figure de bruit F_2 en sortie sans unit
        set(handles.F_2_dB_out,'String',F_2_dB); % Affiche le rsultat de la figure de bruit F_2 en sortie en dB
    else
        errordlg('Choisir l''unit de la temprature de l''amplificateur A2 T_2','File Error') % Choisir l'unit de la temprature de l'amplificateur A2
	end
end

if value_T_2 == 1 && value_F_2 ==0 % Si la temprature n'a pas t renseigne et la figure de bruit F_2 a t renseigne de l'amplificateur A2
	if Unite_fig_ampli2 == 1 % Si la figure de bruit de l'amplificateur A2 a t renseigne sans unit 
        F_2_su_value = str2double(get(handles.F_2,'String')); % Recuperation de la valeur de F_2 sans unit
        F_2_dB = 10 *log10 (F_2_su_value) ; % Conversion de F_2 en dB
        T_2_K = T_a * (F_2_su_value - 1) ; % Calcul de la temprature de l'amplificateur en K
        T_2_C = T_2_K - 273 ; % Conversion de T_2 en C (0C = 273 K)
        set(handles.F_2_su_out,'String',F_2_su_value); % Affiche le rsultat de la figure de bruit F_2 en sortie sans unit
        set(handles.F_2_dB_out,'String',F_2_dB); % Affiche le rsultat de la figure de bruit F_2 en sortie en dB
        set(handles.T_2_K_out,'String',T_2_K); % Affiche le rsultat de la temprature de T_2 en sortie en K
        set(handles.T_2_C_out,'String',T_2_C); % Affiche le rsultat de la temprature de T_2 en sortie en C
	elseif Unite_fig_ampli2 == 2 % Si la figure de bruit de l'amplificateur a t renseigne en dB
        F_2_dB_value = str2double(get(handles.F_2,'String')); % Rcupration de la valeur de F_2 en dB
        F_2_su = 10^(F_2_dB_value/10) ; % Conversion de F_2 sans unit
        T_2_K = T_a * (F_2_su - 1) ; % Calcul de la temprature de l'amplificateur A2 de connexion en K
        T_2_C = T_2_K - 273 ; % Conversion de T_2 en C (0C = 273 K)
        set(handles.F_2_su_out,'String',F_2_su); % Affiche le rsultat de la figure de bruit F_2 en sortie sans unit
        set(handles.F_2_dB_out,'String',F_2_dB_value); % Affiche le rsultat de la figure de bruit F_2 en sortie en dB
        set(handles.T_2_K_out,'String',T_2_K); % Affiche le rsultat de la temprature de T_2 en sortie en K
        set(handles.T_2_C_out,'String',T_2_C); % Affiche le rsultat de la temprature de T_2 en sortie en C
    else
        errordlg('Choisir l''unit de la figure de bruit de l''amplificateur A2 F_2','File Error') % Choisir l'unit de la figure de bruit de l'amplificateur A2
	end
end

if value_T_2 == 1 && value_F_2 ==1 % Si ni la temprature T_2 ni la figure de bruit F_2 n'ont pas t renseignes
	errordlg('Renseigner la valeur de la temprature de l''amplificateur A2 T_2 OU la valeur de la figure de bruit de l''amplificateur A2 F_2','File Error'); % Renseigner soit la valeur de la temprature soit la valeur de la figure de bruit F_2 de l'amplificateur A2
end

% Calcul de la temprature de bruit quivalente du systme :

value_T_A_K_out = isempty(get(handles.T_A_K_out,'String')); 
value_T_K_out = isempty(get(handles.T_K_out,'String')); 
value_F_su_out = isempty(get(handles.F_su_out,'String')); 
value_T_1_K_out = isempty(get(handles.T_1_K_out,'String')); 
value_T_2_K_out = isempty(get(handles.T_2_K_out,'String')); 
value_A_2 = isempty(get(handles.A_2,'String'));

if value_T_A_K_out == 0 && value_T_K_out == 0 && value_F_su_out == 0 && value_T_1_K_out == 0 && value_T_2_K_out == 0 && value_A_2 == 0 % Si T_A , T, L, T_1, T_2 et A_2 ont t renseigns
    T_A_K_out_value = str2double(get(handles.T_A_K_out,'String')); % Recuperation de la valeur de T_A en K en sortie
    T_K_out_value = str2double(get(handles.T_K_out,'String')); % Recuperation de la valeur de T en K en sortie
    F_su_out_value = str2double(get(handles.F_su_out,'String')); % Recuperation de la valeur de F sans unit en sortie
    T_1_K_out_value = str2double(get(handles.T_1_K_out,'String')); % Recuperation de la valeur de T_1 en K en sortie
    T_2_K_out_value = str2double(get(handles.T_2_K_out,'String')); % Recuperation de la valeur de T_2 en K en sortie
    A_2_value = str2double(get(handles.A_2,'String')); % Recuperation de la valeur du gain A_2 en dB
    
    A_2_su = 10^(A_2_value/10); % Conversion de la valeur du gain des dB  sans unit
    
    T_e_eq_K_calculer = T_A_K_out_value + T_K_out_value + F_su_out_value * T_1_K_out_value + (F_su_out_value * T_2_K_out_value ) / A_2_su ; % Calcul de la temprature de bruit quivalente du systme en K
    T_e_eq_C_calculer = T_e_eq_K_calculer - 273 ; % Conversion de la temprature de bruit quivalente du systme en C
                   
	set(handles.T_e_eq_K,'String',T_e_eq_K_calculer); % Affiche le rsultat de la temprature de bruit quivalente du systme en sortie en K
	set(handles.T_e_eq_C,'String',T_e_eq_C_calculer); % Affiche le rsultat de la temprature de bruit quivalente du systme en sortie en C
elseif value_A_2 == 1 % Si le gain A_2 n'a pas t renseign
	errordlg('Renseigner la valeur du gain A_2 de l''amplificateur A2','File Error'); % Renseigner la valeur du gain A_2 de l'amplificateur A2
end

% Calcul de la figure de bruit quivalente du systme :

value_T_e_eq_K = isempty(get(handles.T_e_eq_K,'String')); 

if value_T_e_eq_K == 0 % Si la temprature de bruit quivalente du systme a t calcule
    T_e_eq_K_value = str2double(get(handles.T_e_eq_K,'String')); % Recuperation de la valeur de la temprature de bruit quivalente du systme en K
    F_e_eq_su_calculer = 1 + (T_e_eq_K_value / T_a ) ; % Calcul de la figure de bruit quivalente du systme sans unit
    F_e_eq_dB_calculer = 10 * log10 (F_e_eq_su_calculer) ; % Conversion de la figure de bruit quivalente du systme en dB
    set(handles.F_e_eq_su,'String',F_e_eq_su_calculer); % Affiche le rsultat de la figure de bruit quivalente du systme sans unit
	set(handles.F_e_eq_dB,'String',F_e_eq_dB_calculer); % Affiche le rsultat de la figure de bruit quivalente du systme en dB
end


% --- Executes on button press in effacer.
function effacer_Callback(hObject, eventdata, handles)
% hObject    handle to effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs du programme :

    % Ct donnes renseignes :
set(handles.T_A, 'String', ''); % Efface la valeur de la temprature de l'antenne
set(handles.T, 'String', ''); % Efface la valeur de la temprature du cble de connexion
set(handles.F, 'String', ''); % Efface la valeur de la figure de bruit du cble de connexion
set(handles.A_1, 'String', ''); % Efface la valeur du gain de l'amplificateur A1
set(handles.T_1, 'String', ''); % Efface la valeur de la temprature de l'amplificateur A1
set(handles.F_1, 'String', ''); % Efface la valeur de la figure de bruit de l'amplificateur A1
set(handles.A_2, 'String', ''); % Efface la valeur du gain de l'amplificateur A2
set(handles.T_2, 'String', ''); % Efface la valeur de la temprature de l'amplificateur A2
set(handles.F_2, 'String', ''); % Efface la valeur de la figure de bruit de l'amplificateur A2
set(handles.Choix_temp_antenne, 'Value', 1); % Remet le popumenu "Choisir unit temprature de l'antenne" l'tat initial
set(handles.Choix_temp_cable, 'Value', 1); % Remet le popumenu "Choisir unit temprature du câble de connexion" l'tat initial
set(handles.Choix_fig_cable, 'Value', 1); % Remet le popumenu "Choisir unit figure de bruit du câble de connexion" l'tat initial
set(handles.Choix_temp_ampli1, 'Value', 1); % Remet le popumenu "Choisir unit temprature de l'amplificateur A1" l'tat initial
set(handles.Choix_fig_ampli1, 'Value', 1); % Remet le popumenu "Choisir unit figure de bruit de l'amplificateur A1" l'tat initial
set(handles.Choix_temp_ampli2, 'Value', 1); % Remet le popumenu "Choisir unit temprature de l'amplificateur A2"  l'tat initial
set(handles.Choix_fig_ampli2, 'Value', 1); % Remet le popumenu "Choisir unit figure de bruit de l'amplificateur A2"  l'tat initial

    % Ct rsultats :
set(handles.T_A_K_out, 'String', ''); % Efface la valeur de la temprature de l'antenne en K en sortie
set(handles.T_A_C_out, 'String', ''); % Efface la valeur de la temprature de l'antenne en C en sortie
set(handles.T_K_out, 'String', ''); % Efface la valeur de la temprature du cble de connexion en K en sortie
set(handles.T_C_out, 'String', ''); % Efface la valeur de la temprature du cble de connexion en C en sortie
set(handles.F_su_out, 'String', ''); % Efface la valeur de la figure de bruit du cble de connexion sans unit en sortie
set(handles.F_dB_out, 'String', ''); % Efface la valeur de la figure de bruit du cble de connexion en dB en sortie
set(handles.T_1_K_out, 'String', ''); % Efface la valeur de la temprature de l'amplificateur A1 en K en sortie
set(handles.T_1_C_out, 'String', ''); % Efface la valeur de la temprature de l'amplificateur A1 en C en sortie
set(handles.F_1_su_out, 'String', ''); % Efface la valeur de la figure de bruit de l'amplificateur A1 sans unit en sortie
set(handles.F_1_dB_out, 'String', ''); % Efface la valeur de la figure de bruit de l'amplificateur A1 en dB en sortie
set(handles.T_2_K_out, 'String', ''); % Efface la valeur de la temprature de l'amplificateur A2 en K en sortie
set(handles.T_2_C_out, 'String', ''); % Efface la valeur de la temprature de l'amplificateur A2 en C en sortie
set(handles.F_2_su_out, 'String', ''); % Efface la valeur de la figure de bruit de l'amplificateur A2 sans unit en sortie
set(handles.F_2_dB_out, 'String', ''); % Efface la valeur de la figure de bruit de l'amplificateur A2 en dB en sortie
set(handles.T_e_eq_K, 'String', ''); % Efface la valeur de la temprature quivalente du systme en K en sortie
set(handles.T_e_eq_C, 'String', ''); % Efface la valeur de la temprature quivalente du systme en C en sortie
set(handles.F_e_eq_su, 'String', ''); % Efface la valeur de la figure de bruit quivalente du systme sans unit en sortie
set(handles.F_e_eq_dB, 'String', ''); % Efface la valeur de la figure de bruit quivalente du systme en dB en sortie

    
% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all; % Fermeture du programme au complet


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal % Retour au menu principal
close Temperature_FigureBruit_Equivalentes % Fermeture du programme 'Temperature_FigureBruit_Equivalentes'
