function varargout = Performances_Modulations(varargin)
% Liaisons_fixes MATLAB code for Liaisons_fixes.fig
%      Liste des programmes :
%           - Premire interface
%           - Menu principal
%           - Bilan de liaisons pour les liaisons fixes
%           - Bilan de liaisons pour les liaisons fixes et disponibilit
%           - Temprature et figure de bruit
%           - Distance minimale entre cellules
%           - Performances de modulation
%           - Dimensionnement des rseaux cellulaires
%           - Dbit maximal 
%
%      Liaisons_fixes, by itself, creates a new Performances_Modulations or raises the existing
%      singleton*.
%
%      H = Liaisons_fixes returns the handle to a new Performances_Modulations or the handle to
%      the existing singleton*.
%
%      Performances_Modulations('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Liaisons_fixes.M with the given input arguments.
%
%      Performances_Modulations('Property','Value',...) creates a new Liaisons_fixes or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Performances_Modulations_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Liaisons_fixes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Performances_Modulations
% By Anais LAMARI LE MOUROUX
% Last Modified by GUIDE v2.5 11-Apr-2019 21:09:26

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Performances_Modulations_OpeningFcn, ...
                   'gui_OutputFcn',  @Performances_Modulations_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Performances_Modulations is made visible.
function Performances_Modulations_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Performances_Modulations (see VARARGIN)

% Choose default command line output for Performances_Modulations
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);



% UIWAIT makes Performances_Modulations wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Performances_Modulations_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function M_2eme_choix_Callback(hObject, eventdata, handles)
% hObject    handle to M_2eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M_2eme_choix as text
%        str2double(get(hObject,'String')) returns contents of M_2eme_choix as a double

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_M_2eme_choix = isempty(get(handles.M_2eme_choix,'String'));

if value_M_2eme_choix ==0
    M_2eme_choix_value = str2double(get(handles.M_2eme_choix,'String'));  
    for i = 1 : 12
        if M_2eme_choix_value ~= 2^(i)
            M_non_accept = i;
        else
            M_non_accept = [];
            break;
        end
    
    end
    if isempty(M_non_accept) == 0
        errordlg('2me choix : Valeur de M non acceptable (M = 2^m doit tre un entier positif non nul)','File Error');
    end   
end


% --- Executes during object creation, after setting all properties.
function M_2eme_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M_2eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function M_3eme_choix_Callback(hObject, eventdata, handles)
% hObject    handle to M_3eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M_3eme_choix as text
%        str2double(get(hObject,'String')) returns contents of M_3eme_choix as a double

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_M_3eme_choix = isempty(get(handles.M_3eme_choix,'String'));

if value_M_3eme_choix ==0
    M_3eme_choix_value = str2double(get(handles.M_3eme_choix,'String'));  
    for i = 1 : 12
        if M_3eme_choix_value ~= 2^(i)
            M_non_accept = i;
        else
            M_non_accept = [];
            break;
        end
    
    end
    if isempty(M_non_accept) == 0
        errordlg('3me choix : Valeur de M non acceptable (M = 2^m doit tre un entier positif non nul)','File Error');
    end   
end



% --- Executes during object creation, after setting all properties.
function M_3eme_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M_3eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function M_4eme_choix_Callback(hObject, eventdata, handles)
% hObject    handle to M_4eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M_4eme_choix as text
%        str2double(get(hObject,'String')) returns contents of M_4eme_choix as a double


% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_M_4eme_choix = isempty(get(handles.M_4eme_choix,'String'));

if value_M_4eme_choix ==0
    M_4eme_choix_value = str2double(get(handles.M_4eme_choix,'String'));  
    for i = 1 : 12
        if M_4eme_choix_value ~= 2^(i)
            M_non_accept = i;
        else
            M_non_accept = [];
            break;
        end
    end
    if isempty(M_non_accept) == 0
        errordlg('4me choix : Valeur de M non acceptable (M = 2^m doit tre un entier positif non nul)','File Error');
    end   
end

% --- Executes during object creation, after setting all properties.
function M_4eme_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M_4eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_modulation_1er_choix.
function Choix_modulation_1er_choix_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_1er_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_modulation_1er_choix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_modulation_1er_choix

switch get(handles.Choix_modulation_1er_choix,'Value')   
	case 2
        Choix_1_mod = 1; % Modulation ASK
        
	case 3
        Choix_1_mod = 2; % Modulation FSK
        
	case 4
        Choix_1_mod = 3; % Modulation OFSK
        
	case 5
        Choix_1_mod = 4; % Modulation PSK
        
	case 6
        Choix_1_mod = 5; % Modulation DPSK
        set(handles.M_1er_choix,'String','2'); % Fixe M=2

	case 7
        Choix_1_mod = 6; % Modulation OQPSK
        set(handles.M_1er_choix,'String','4'); % Fixe M = 4

	case 8
        Choix_1_mod = 7; % Modulation QAM
        value_M_1er_choix = isempty(get(handles.M_1er_choix,'String'));
        if value_M_1er_choix ==0
            M_1er_choix_value = str2double(get(handles.M_1er_choix,'String'));  
            if M_1er_choix_value == 2
                errordlg('Choix 1 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
            end
        end
        
    otherwise
        errordlg('Choisissez le mode de modulation','File Error');
end
set(handles.Choix_modulation_1er_choix, 'UserData', Choix_1_mod);



% --- Executes during object creation, after setting all properties.
function Choix_modulation_1er_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_1er_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_modulation_2eme_choix.
function Choix_modulation_2eme_choix_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_2eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_modulation_2eme_choix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_modulation_2eme_choix

switch get(handles.Choix_modulation_2eme_choix,'Value')   
	case 2
        Choix_2_mod = 1; % Modulation ASK
        
	case 3
        Choix_2_mod = 2; % Modulation FSK
       
	case 4
        Choix_2_mod = 3; % Modulation OFSK
        
	case 5
        Choix_2_mod = 4; % Modulation PSK
        
	case 6
        Choix_2_mod = 5; % Modulation DPSK
        set(handles.M_2eme_choix,'String','2'); % Fixe M=2

	case 7
        Choix_2_mod = 6; % Modulation OQPSK
        set(handles.M_2eme_choix,'String','4'); % Fixe M=4

	case 8
        Choix_2_mod = 7; % Modulation QAM
        value_M_2eme_choix = isempty(get(handles.M_2eme_choix,'String'));
        if value_M_2eme_choix ==0
            M_2eme_choix_value = str2double(get(handles.M_2eme_choix,'String'));  
            if M_2eme_choix_value == 2
                errordlg('Choix 2 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
            end
        end
        
    otherwise
        errordlg('Choisissez le mode de modulation','File Error');
end
set(handles.Choix_modulation_2eme_choix, 'UserData', Choix_2_mod);

% --- Executes during object creation, after setting all properties.
function Choix_modulation_2eme_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_2eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_modulation_3eme_choix.
function Choix_modulation_3eme_choix_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_3eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_modulation_3eme_choix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_modulation_3eme_choix

switch get(handles.Choix_modulation_3eme_choix,'Value')   
	case 2
        Choix_3_mod = 1; % Modulation ASK
        
	case 3
        Choix_3_mod = 2; % Modulation FSK
        
	case 4
        Choix_3_mod = 3; % Modulation OFSK
        
	case 5
        Choix_3_mod = 4; % Modulation PSK
        
	case 6
        Choix_3_mod = 5; % Modulation DPSK
        set(handles.M_3eme_choix,'String','2'); % Fixe M = 2

	case 7
        Choix_3_mod = 6; % Modulation OQPSK
        set(handles.M_3eme_choix,'String','4'); % Fixe M=4

	case 8
        Choix_3_mod = 7; % Modulation QAM
        value_M_3eme_choix = isempty(get(handles.M_3eme_choix,'String'));
        if value_M_3eme_choix ==0 % Si M choix 3 renseign
            M_3eme_choix_value = str2double(get(handles.M_3eme_choix,'String'));  
            if M_3eme_choix_value == 2 % Si M = 2
                errordlg('Choix 3 : Valeur minimale d''une modulation M-QAM est M=4','File Error'); % retourne un message d'erreur
            end
        end
        
    otherwise
        errordlg('Choisissez le mode de modulation','File Error');
end
set(handles.Choix_modulation_3eme_choix, 'UserData', Choix_3_mod);

% --- Executes during object creation, after setting all properties.
function Choix_modulation_3eme_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_3eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_modulation_4eme_choix.
function Choix_modulation_4eme_choix_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_4eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_modulation_4eme_choix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_modulation_4eme_choix

switch get(handles.Choix_modulation_4eme_choix,'Value')   
	case 2
        Choix_4_mod = 1; % Modulation ASK
        
	case 3
        Choix_4_mod = 2; % Modulation FSK
        
	case 4
        Choix_4_mod = 3; % Modulation OFSK
        
	case 5
        Choix_4_mod = 4; % Modulation PSK
        
	case 6
        Choix_4_mod = 5; % Modulation DPSK
        set(handles.M_4eme_choix,'String','2');

	case 7
        Choix_4_mod = 6; % Modulation OQPSK
        set(handles.M_4eme_choix,'String','4');

	case 8
        Choix_4_mod = 7; % Modulation QAM
        value_M_4eme_choix = isempty(get(handles.M_4eme_choix,'String'));
        if value_M_4eme_choix ==0
            M_4eme_choix_value = str2double(get(handles.M_4eme_choix,'String'));  
            if M_4eme_choix_value == 2
                errordlg('Choix 4 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
            end
        end
        
    otherwise
        errordlg('Choisissez le mode de modulation','File Error');
end
set(handles.Choix_modulation_4eme_choix, 'UserData', Choix_4_mod);


% --- Executes during object creation, after setting all properties.
function Choix_modulation_4eme_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_modulation_4eme_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Choix_representation_graph.
function Choix_representation_graph_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_representation_graph (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Choix_representation_graph contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Choix_representation_graph

switch get(handles.Choix_representation_graph,'Value')   
	case 2
        Choix_representation_graphique = 1; % TEB en fonction de Eb_N0
        
	case 3
        Choix_representation_graphique = 2; % TEB en fonction de S_N
        
    otherwise
        errordlg('Choisissez la reprsentation graphique dsire','File Error');
end
set(handles.Choix_representation_graph, 'UserData', Choix_representation_graphique);

% --- Executes during object creation, after setting all properties.
function Choix_representation_graph_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_representation_graph (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function TEB_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to TEB_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TEB_seuil as text
%        str2double(get(hObject,'String')) returns contents of TEB_seuil as a double


% --- Executes during object creation, after setting all properties.
function TEB_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TEB_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Eb_N0_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Eb_N0_seuil as text
%        str2double(get(hObject,'String')) returns contents of Eb_N0_seuil as a double


% --- Executes during object creation, after setting all properties.
function Eb_N0_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function S_N_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of S_N_seuil as text
%        str2double(get(hObject,'String')) returns contents of S_N_seuil as a double


% --- Executes during object creation, after setting all properties.
function S_N_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function d_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to d_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of d_seuil as text
%        str2double(get(hObject,'String')) returns contents of d_seuil as a double


% --- Executes during object creation, after setting all properties.
function d_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to d_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function f_b_Callback(hObject, eventdata, handles)
% hObject    handle to f_b (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of f_b as text
%        str2double(get(hObject,'String')) returns contents of f_b as a double


% --- Executes during object creation, after setting all properties.
function f_b_CreateFcn(hObject, eventdata, handles)
% hObject    handle to f_b (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function M_1er_choix_Callback(hObject, eventdata, handles)
% hObject    handle to M_1er_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M_1er_choix as text
%        str2double(get(hObject,'String')) returns contents of M_1er_choix as a double

% Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_M_1er_choix = isempty(get(handles.M_1er_choix,'String'));

if value_M_1er_choix ==0
    M_1er_choix_value = str2double(get(handles.M_1er_choix,'String'));  
    for i = 1 : 12
        if M_1er_choix_value ~= 2^(i)
            M_non_accept = i;
        else
            M_non_accept = [];
            break;
        end
    end
    if isempty(M_non_accept) == 0
        errordlg('1er choix : Valeur de M non acceptable (M = 2^m doit tre un entier positif non nul)','File Error');
    end   
end
    

% --- Executes during object creation, after setting all properties.
function M_1er_choix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M_1er_choix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_1er_S_N_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_S_N_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_S_N_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_S_N_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_1er_Eb_N0_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_Eb_N0_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_Eb_N0_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_Eb_N0_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_1er_TEB_seuil_Eb_N0_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_TEB_seuil_Eb_N0 as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_TEB_seuil_Eb_N0 as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_TEB_seuil_Eb_N0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Choix_1er_m_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_m as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_m as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Choix_1er_W_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_W as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_W as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_W_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_1er_eff_spectrale_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_eff_spectrale as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_eff_spectrale as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_eff_spectrale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_1er_f_s_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_f_s as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_f_s as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_f_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_1er_TEB_seuil_S_N_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_1er_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_1er_TEB_seuil_S_N as text
%        str2double(get(hObject,'String')) returns contents of Choix_1er_TEB_seuil_S_N as a double


% --- Executes during object creation, after setting all properties.
function Choix_1er_TEB_seuil_S_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_1er_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_S_N_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_S_N_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_S_N_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_S_N_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_Eb_N0_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_Eb_N0_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_Eb_N0_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_Eb_N0_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_TEB_seuil_Eb_N0_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_TEB_seuil_Eb_N0 as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_TEB_seuil_Eb_N0 as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_TEB_seuil_Eb_N0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_TEB_seuil_S_N_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_TEB_seuil_S_N as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_TEB_seuil_S_N as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_TEB_seuil_S_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_m_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_m as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_m as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_W_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_W as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_W as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_W_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_eff_spectrale_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_eff_spectrale as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_eff_spectrale as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_eff_spectrale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_4eme_f_s_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_4eme_f_s as text
%        str2double(get(hObject,'String')) returns contents of Choix_4eme_f_s as a double


% --- Executes during object creation, after setting all properties.
function Choix_4eme_f_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_4eme_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_S_N_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_S_N_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_S_N_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_S_N_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_Eb_N0_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_Eb_N0_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_Eb_N0_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_Eb_N0_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_TEB_seuil_Eb_N0_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_TEB_seuil_Eb_N0 as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_TEB_seuil_Eb_N0 as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_TEB_seuil_Eb_N0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_TEB_seuil_S_N_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_TEB_seuil_S_N as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_TEB_seuil_S_N as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_TEB_seuil_S_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_m_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_m as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_m as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_W_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_W as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_W as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_W_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_eff_spectrale_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_eff_spectrale as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_eff_spectrale as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_eff_spectrale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_3eme_f_s_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_3eme_f_s as text
%        str2double(get(hObject,'String')) returns contents of Choix_3eme_f_s as a double


% --- Executes during object creation, after setting all properties.
function Choix_3eme_f_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_3eme_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_f_s_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_f_s as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_f_s as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_f_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_f_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function representation_graph_CreateFcn(hObject, eventdata, handles)
% hObject    handle to representation_graph (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate representation_graph


function Choix_2eme_eff_spectrale_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_eff_spectrale as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_eff_spectrale as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_eff_spectrale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_eff_spectrale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_W_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_W as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_W as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_W_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_W (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_m_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_m as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_m as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_TEB_seuil_S_N_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_TEB_seuil_S_N as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_TEB_seuil_S_N as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_TEB_seuil_S_N_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_TEB_seuil_S_N (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_TEB_seuil_Eb_N0_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_TEB_seuil_Eb_N0 as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_TEB_seuil_Eb_N0 as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_TEB_seuil_Eb_N0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_TEB_seuil_Eb_N0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_Eb_N0_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_Eb_N0_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_Eb_N0_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_Eb_N0_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_Eb_N0_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Choix_2eme_S_N_seuil_Callback(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Choix_2eme_S_N_seuil as text
%        str2double(get(hObject,'String')) returns contents of Choix_2eme_S_N_seuil as a double


% --- Executes during object creation, after setting all properties.
function Choix_2eme_S_N_seuil_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Choix_2eme_S_N_seuil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in calculer.
function calculer_Callback(hObject, eventdata, handles)
% hObject    handle to calculer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

cla(handles.representation_graph,'reset'); % Remet la figure  l'tat initial
% Calcul du nombre de bits par symbole :

    % Cellule vide ou non : Valeur = 1 (cellule vide) ou 0 (cellule non vide) :

value_M_1er_choix = isempty(get(handles.M_1er_choix,'String'));
value_M_2eme_choix = isempty(get(handles.M_2eme_choix,'String'));
value_M_3eme_choix = isempty(get(handles.M_3eme_choix,'String'));
value_M_4eme_choix = isempty(get(handles.M_4eme_choix,'String'));

    % 1er choix :

if value_M_1er_choix == 0 % Si M_1 a t renseign
    M_1er_choix_value = str2double(get(handles.M_1er_choix,'String')); % Rcupration de la valeur de M_1
    m_1er_choix = log10(M_1er_choix_value) / log10(2);
    set(handles.Choix_1er_m,'String',m_1er_choix); % Affiche le rsultat du nombre de bits/symbole du 1er choix
end

    % 2me choix :

if value_M_2eme_choix == 0 % Si M_2 a t renseign
    M_2eme_choix_value = str2double(get(handles.M_2eme_choix,'String')); % Rcupration de la valeur de M_2
    m_2eme_choix = log10(M_2eme_choix_value) / log10(2); % calcul de m (M=2^m)
    set(handles.Choix_2eme_m,'String',m_2eme_choix); % Affiche le rsultat du nombre de bits/symbole du 2me choix
end

    % 3me choix :

if value_M_3eme_choix == 0 % Si M_3 a t renseign
    M_3eme_choix_value = str2double(get(handles.M_3eme_choix,'String')); % Rcupration de la valeur de M_3
    m_3eme_choix = log10(M_3eme_choix_value) / log10(2); % calcul de m (M=2^m)
    set(handles.Choix_3eme_m,'String',m_3eme_choix); % Affiche le rsultat du nombre de bits/symbole du 3me choix
end

    % 4me choix :

if value_M_4eme_choix == 0 % Si M_4 a t renseign
    M_4eme_choix_value = str2double(get(handles.M_4eme_choix,'String')); % Rcupration de la valeur de M_4
    m_4eme_choix = log10(M_4eme_choix_value) / log10(2); % calcul de m (M=2^m)
    set(handles.Choix_4eme_m,'String',m_4eme_choix); % Affiche le rsultat du nombre de bits/symbole du 4me choix
end

% Calcul de la frquence symbole :

value_f_b = isempty(get(handles.f_b,'String'));

if value_f_b == 0 % Si f_b a t renseigne
    f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
    
    % 1er choix :
    
    if value_M_1er_choix == 0 % Si M_1 a t renseign
        M_1er_choix_value = str2double(get(handles.M_1er_choix,'String')); % Rcupration de la valeur de M_1
        f_s_1er_choix = f_b_value / (log10(M_1er_choix_value) / log10(2)); % Calcul de la frquence symbole
        set(handles.Choix_1er_f_s,'String',f_s_1er_choix); % Affiche le rsultat de f_s du 1er choix
    end

    % 2me choix :
    
    if value_M_2eme_choix == 0 % Si M_2 a t renseign
        M_2eme_choix_value = str2double(get(handles.M_2eme_choix,'String')); % Rcupration de la valeur de M_2
        f_s_2eme_choix = f_b_value / (log10(M_2eme_choix_value) / log10(2)); % Calcul de la frquence symbole
        set(handles.Choix_2eme_f_s,'String',f_s_2eme_choix); % Affiche le rsultat de f_s du 2me choix
    end
  
    % 3me choix :

    if value_M_3eme_choix == 0 % Si M_3 a t renseign
        M_3eme_choix_value = str2double(get(handles.M_3eme_choix,'String')); % Rcupration de la valeur de M_3
        f_s_3eme_choix = f_b_value / (log10(M_3eme_choix_value) / log10(2)); % Calcul de la frquence symbole
        set(handles.Choix_3eme_f_s,'String',f_s_3eme_choix); % Affiche le rsultat de f_s du 3me choix
    end
    
    % 4me choix :
    
    if value_M_4eme_choix == 0 % Si M_4 a t renseign
        M_4eme_choix_value = str2double(get(handles.M_4eme_choix,'String')); % Rcupration de la valeur de M_4
        f_s_4eme_choix = f_b_value / (log10(M_4eme_choix_value) / log10(2)); % Calcul de la frquence symbole
        set(handles.Choix_4eme_f_s,'String',f_s_4eme_choix); % Affiche le rsultat de f_s du 4me choix
    end
end

% Calcul de la bande passante, de l'efficacit spectrale et des valeurs seuils :

value_f_b = isempty(get(handles.f_b,'String'));
Choix_1_mod = get(handles.Choix_modulation_1er_choix,'UserData');
Choix_2_mod = get(handles.Choix_modulation_2eme_choix,'UserData');
Choix_3_mod = get(handles.Choix_modulation_3eme_choix,'UserData');
Choix_4_mod = get(handles.Choix_modulation_4eme_choix,'UserData');
value_TEB_seuil = isempty(get(handles.TEB_seuil,'String'));
value_Eb_N0_seuil = isempty(get(handles.Eb_N0_seuil,'String'));
value_S_N_seuil = isempty(get(handles.S_N_seuil,'String'));
Choix_representation_graphique = get(handles.Choix_representation_graph,'UserData');


    % 1er choix :
    
if value_M_1er_choix == 0 % Si M_1 a t renseign
	M_1er_choix_value = str2double(get(handles.M_1er_choix,'String')); % Rcupration de la valeur de M_1
	if Choix_1_mod == 1 % Si Modulation ASK choisie
        
        % Calcul bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_1er_choix = (2 * f_b_value )/log2(M_1er_choix_value); % Calcul de la bande passante du 1er choix - M-ASK
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
        end
        
        % Calcul efficacit spectrale :
        eff_spectrale_1er_choix = log2(M_1er_choix_value) / 2; % Calcul de l'efficacit spectrale du 1er choix - M-ASK
        set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        
        % Calcul Eb_N0 seuil et S/N seuil si TEB_seuil renseign :
        
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_1er_choix = (((M_1er_choix_value)^2 - 1 )/ (3 * log2(M_1er_choix_value))) * (erfcinv((M_1er_choix_value *log2(M_1er_choix_value) * TEB_seuil_value ) / ( M_1er_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
        
            	% Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = ((M_1er_choix_value - 1 )/ (M_1er_choix_value * log2(M_1er_choix_value))) * erfc( sqrt( ((3 *log2(M_1er_choix_value)) / ((M_1er_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_1er_choix = ((M_1er_choix_value - 1 )/ (M_1er_choix_value * log2(M_1er_choix_value))) * erfc( sqrt( ((3 *log2(M_1er_choix_value)) / ((M_1er_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = ((M_1er_choix_value - 1 )./ (M_1er_choix_value .* log2(M_1er_choix_value))) .* erfc( sqrt( ((3 .*log2(M_1er_choix_value)) ./ ((M_1er_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = ((M_1er_choix_value - 1 )./ (M_1er_choix_value .* log2(M_1er_choix_value))) .* erfc( sqrt( ((3 .*log2(M_1er_choix_value)) ./ ((M_1er_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
            end
        end

        
	elseif Choix_1_mod == 2 % Si Modulation FSK choisie
        
        % Calcul de la bande passante et de l'efficacit spectrale :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            Choix_1er_Fc_demande = inputdlg({'Premire frquence de coupure en bits/s : f_c1','Frquence de coupure maximale en bits/s : f_cM'},'Choix 1 : Renseigner les frquences de coupure', [1 80; 1 80]); 
            user_Choix_1_val_f_c1 = str2double(Choix_1er_Fc_demande{1}); % Rcupre la valeur de f_c1
            user_Choix_1_val_f_cM = str2double(Choix_1er_Fc_demande{2}); % Rcupre la valeur de f_cM
            W_1er_choix = user_Choix_1_val_f_cM - user_Choix_1_val_f_c1 + (2 * f_b_value )/log2(M_1er_choix_value);  % Calcul de la bande passante du 1er choix - M-FSK
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
            eff_spectrale_1er_choix = f_b_value / (W_1er_choix); % Calcul de l'efficacit spectrale du 1er choix - M-FSK
            set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        end
        
        % Calcul Eb_N0 seuil et S/N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_1er_choix = (2/ (log2(M_1er_choix_value))) * (erfcinv((2 *log2(M_1er_choix_value) * TEB_seuil_value ) / ( M_1er_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
                
                % Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = ((M_1er_choix_value - 1 )/ (2 * log2(M_1er_choix_value))) * erfc( sqrt( (log2(M_1er_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
                Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
                TEB_seuil_S_N_1er_choix = ((M_1er_choix_value - 1 )/ (2 * log2(M_1er_choix_value))) * erfc( sqrt( (log2(M_1er_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
                set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
                
            else
                errordlg('Choix 1 : Rentrer la frquence binaire','File Error');
            end
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = ((M_1er_choix_value - 1 )./ (2 .* log2(M_1er_choix_value))) .* erfc( sqrt( (log2(M_1er_choix_value) ./ 2).* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = ((M_1er_choix_value - 1 )./ (2 .* log2(M_1er_choix_value))) .* erfc( sqrt( (log2(M_1er_choix_value) ./ 2).* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
                
            else
                errordlg('Choix 1 : Rentrer la frquence binaire','File Error');
            end
        end
            
	elseif Choix_1_mod == 3 % Modulation OFSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_1er_choix = ((M_1er_choix_value + 1)/log2(M_1er_choix_value)) * f_b_value; % Calcul de la bande passante du 1er choix - M-OFSK
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_1er_choix = log2(M_1er_choix_value)/(M_1er_choix_value + 1); % Calcul de l'efficacit spectrale du 1er choix - M-OFSK
        set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul de Eb_N0 seuil :
            Eb_N0_seuil_1er_choix = (2/ (log2(M_1er_choix_value))) * (erfcinv((2 *log2(M_1er_choix_value) * TEB_seuil_value ) / ( M_1er_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
        
            	% Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = ((M_1er_choix_value - 1 )/ (2 * log2(M_1er_choix_value))) * erfc( sqrt( (log2(M_1er_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_1er_choix = ((M_1er_choix_value - 1 )/ (2 * log2(M_1er_choix_value))) * erfc( sqrt( (log2(M_1er_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = ((M_1er_choix_value - 1 )./ (2 .* log2(M_1er_choix_value))) .* erfc( sqrt( (log2(M_1er_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = ((M_1er_choix_value - 1 )./ (2 .* log2(M_1er_choix_value))) .* erfc( sqrt( (log2(M_1er_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_1_mod == 4 % Modulation PSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_1er_choix = (2 * f_b_value )/log2(M_1er_choix_value); % Calcul de la bande passante du 1er choix - M-PSK
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
        end
        
        % Calcul de l'efficacit spectrale
        eff_spectrale_1er_choix = log2(M_1er_choix_value) / 2; % Calcul de l'efficacit spectrale du 1er choix - M-PSK
        set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        
        % Calcul Eb_N0 seuil et S/N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul de Eb_N0 seuil :
            Eb_N0_seuil_1er_choix = (1/ (log2(M_1er_choix_value) * (sin(pi/M_1er_choix_value))^2)) * (erfcinv(log2(M_1er_choix_value) * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
        
            	% Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = (1/ log2(M_1er_choix_value)) * erfc( (sqrt(log2(M_1er_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_1er_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_1er_choix = (1/ log2(M_1er_choix_value)) * erfc( (sqrt(log2(M_1er_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_1er_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = (1./log2(M_1er_choix_value)) .* erfc( (sqrt(log2(M_1er_choix_value) .* Eb_N0_su)) .* sin(pi/M_1er_choix_value)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = (1./log2(M_1er_choix_value)) .* erfc( (sqrt(log2(M_1er_choix_value) .* Eb_N0_su)) .* sin(pi/M_1er_choix_value)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_1_mod == 5 % Modulation DPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_1er_choix = 2*f_b_value; % Calcul de la bande passante du 1er choix - DPSK
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_1er_choix = 1 / 2; % Calcul de l'efficacit spectrale du 1er choix - DPSK
        set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        
        % Calcul Eb_N0 seuil et Eb_N0 seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul de Eb_N0 seuil :
            Eb_N0_seuil_1er_choix =  -log((2*TEB_seuil_value)); % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
        
            	% Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_1er_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_1_mod == 6 % Modulation OQPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_1er_choix = f_b_value; % Calcul de la bande passante du 1er choix - OQPSK
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_1er_choix = 1 ; % Calcul de l'efficacit spectrale du 1er choix - OQPSK
        set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_1er_choix =  (erfcinv(2 * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_1er_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_1_mod == 7 % Modulation QAM choisie
        
        % Vrification de la valeur de M : M=2 non acceptable
        if M_1er_choix_value == 2
            errordlg('Choix 1 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
        end
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_1er_choix = (2 * f_b_value )/log2(M_1er_choix_value); % Calcul de la bande passante du 1er choix - M-QAM
            set(handles.Choix_1er_W,'String',W_1er_choix); % Affiche le rsultat de la bande passante du 1er choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_1er_choix = log2(M_1er_choix_value) / 2 ; % Calcul de l'efficacit spectrale du 1er choix - M-QAM
        set(handles.Choix_1er_eff_spectrale,'String',eff_spectrale_1er_choix); % Affiche le rsultat de l'efficacit spectrale du 1er choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_1er_choix =  ((2* (M_1er_choix_value - 1))/(3 *log2(M_1er_choix_value))) *  (erfcinv( (sqrt(M_1er_choix_value)*log2(M_1er_choix_value) * TEB_seuil_value) / ( 2 * (sqrt(M_1er_choix_value) - 1))))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_1er_choix = 10*log10(Eb_N0_seuil_1er_choix); % Conversion en dB
            set(handles.Choix_1er_Eb_N0_seuil,'String',Eb_N0_seuil_dB_1er_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 1er choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_1er_choix = eff_spectrale_1er_choix * Eb_N0_seuil_1er_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_1er_choix = 10*log10(S_N_seuil_1er_choix); % Conversion en dB
                set(handles.Choix_1er_S_N_seuil,'String',S_N_seuil_dB_1er_choix); % Affiche le rsultat du rapport S_N seuil en dB du 1er choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_1er_choix = ((2*(sqrt(M_1er_choix_value) - 1) )/ (sqrt(M_1er_choix_value) * log2(M_1er_choix_value))) * erfc( sqrt( ((3*log2(M_1er_choix_value)) / (2*(M_1er_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_Eb_N0,'String',TEB_seuil_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_1er_choix = ((2*(sqrt(M_1er_choix_value) - 1) )/ (sqrt(M_1er_choix_value) * log2(M_1er_choix_value))) * erfc( sqrt( ((3*log2(M_1er_choix_value)) / (2*(M_1er_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_1er_TEB_seuil_S_N,'String',TEB_seuil_S_N_1er_choix); % Affiche le rsultat du TEB seuil en dB du 1er choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_1er_choix = ((2.*(sqrt(M_1er_choix_value) - 1) )./ (sqrt(M_1er_choix_value) .* log2(M_1er_choix_value))) .* erfc( sqrt( ((3.*log2(M_1er_choix_value)) ./ (2.*(M_1er_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_1er_Choix = semilogy(Eb_N0_dB,TEB_1er_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_1er_choix = isempty(get(handles.Choix_1er_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_1er_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_1er_choix = str2double(get(handles.Choix_1er_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_1er_choix); % Calcul de Eb_N0 sans unit
                TEB_1er_choix = ((2.*(sqrt(M_1er_choix_value) - 1) )./ (sqrt(M_1er_choix_value) .* log2(M_1er_choix_value))) .* erfc( sqrt( ((3.*log2(M_1er_choix_value)) ./ (2.*(M_1er_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_1er_Choix = semilogy(S_N_dB,TEB_1er_choix,'LineWidth',2);
            end
        end
        
	else
        errordlg('Choix 1 : Choisissez le mode de modulation','File Error');
	end
end
    
    % 2me choix :

if value_M_2eme_choix == 0 % Si M_2 a t renseign
	M_2eme_choix_value = str2double(get(handles.M_2eme_choix,'String')); % Rcupration de la valeur de M_2
    if value_M_1er_choix == 0
        hold on; % Si le 1er choix a t renseign, enregistre la courbe
    end
    
	if Choix_2_mod == 1 % Si Modulation ASK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_2eme_choix = (2 * f_b_value )/log2(M_2eme_choix_value); % Calcul de la bande passante du 2me choix - M-ASK
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_2eme_choix = log2(M_2eme_choix_value) / 2; % Calcul de l'efficacit spectrale du 2me choix - M-ASK
        set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix
         
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_2eme_choix = (((M_2eme_choix_value)^2 - 1 )/ (3 * log2(M_2eme_choix_value))) * (erfcinv((M_2eme_choix_value *log2(M_2eme_choix_value) * TEB_seuil_value ) / ( M_2eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
            	% Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = ((M_2eme_choix_value - 1 )/ (M_2eme_choix_value * log2(M_2eme_choix_value))) * erfc( sqrt( ((3 *log2(M_2eme_choix_value)) / ((M_2eme_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_2eme_choix = ((M_2eme_choix_value - 1 )/ (M_2eme_choix_value * log2(M_2eme_choix_value))) * erfc( sqrt( ((3 *log2(M_2eme_choix_value)) / ((M_2eme_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = ((M_2eme_choix_value - 1 )./ (M_2eme_choix_value .* log2(M_2eme_choix_value))) .* erfc( sqrt( ((3 .*log2(M_2eme_choix_value)) ./ ((M_2eme_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = ((M_2eme_choix_value - 1 )./ (M_2eme_choix_value .* log2(M_2eme_choix_value))) .* erfc( sqrt( ((3 .*log2(M_2eme_choix_value)) ./ ((M_2eme_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_2_mod == 2 % Si Modulation FSK choisie
        
        % Calcul de la bande passante et de l'efficacit spectrale :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            Choix_2eme_Fc_demande = inputdlg({'Premire frquence de coupure en bits/s : f_c1','Frquence de coupure maximale en bits/s : f_cM'},'Choix 2 : Renseigner les frquences de coupure', [1 80; 1 80]); 
            user_Choix_2_val_f_c1 = str2double(Choix_2eme_Fc_demande{1}); % Rcupre la valeur de f_c1
            user_Choix_2_val_f_cM = str2double(Choix_2eme_Fc_demande{2}); % Rcupre la valeur de f_cM
            W_2eme_choix = user_Choix_2_val_f_cM - user_Choix_2_val_f_c1 + (2 * f_b_value )/log2(M_2eme_choix_value);  % Calcul de la bande passante du 2me choix - M-FSK
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
            eff_spectrale_2eme_choix = f_b_value / (W_2eme_choix); % Calcul de l'efficacit spectrale du 2me choix - M-FSK
            set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix
        end
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_2eme_choix = (2/ (log2(M_2eme_choix_value))) * (erfcinv((2 *log2(M_2eme_choix_value) * TEB_seuil_value ) / ( M_2eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = ((M_2eme_choix_value - 1 )/ (2 * log2(M_2eme_choix_value))) * erfc( sqrt( (log2(M_2eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
                Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
                TEB_seuil_S_N_2eme_choix = ((M_2eme_choix_value - 1 )/ (2 * log2(M_2eme_choix_value))) * erfc( sqrt( (log2(M_2eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
                set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
            else
                errordlg('Choix 2 : Rentrer la frquence binaire','File Error');
            end
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = ((M_2eme_choix_value - 1 )./ (2 .* log2(M_2eme_choix_value))) .* erfc( sqrt( (log2(M_2eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = ((M_2eme_choix_value - 1 )./ (2 .* log2(M_2eme_choix_value))) .* erfc( sqrt( (log2(M_2eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            else
                errordlg('Choix 2 : Rentrer la frquence binaire','File Error');
            end
        end
        
	elseif Choix_2_mod == 3 % Modulation OFSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_2eme_choix = ((M_2eme_choix_value + 1)/log2(M_2eme_choix_value)) * f_b_value; % Calcul de la bande passante du 2me choix - M-OFSK
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_2eme_choix = log2(M_2eme_choix_value)/(M_2eme_choix_value + 1); % Calcul de l'efficacit spectrale du 2me choix - M-OFSK
        set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_2eme_choix = (2/ (log2(M_2eme_choix_value))) * (erfcinv((2 *log2(M_2eme_choix_value) * TEB_seuil_value ) / ( M_2eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = ((M_2eme_choix_value - 1 )/ (2 * log2(M_2eme_choix_value))) * erfc( sqrt( (log2(M_2eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_2eme_choix = ((M_2eme_choix_value - 1 )/ (2 * log2(M_2eme_choix_value))) * erfc( sqrt( (log2(M_2eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = ((M_2eme_choix_value - 1 )./ (2 .* log2(M_2eme_choix_value))) .* erfc( sqrt( (log2(M_2eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = ((M_2eme_choix_value - 1 )./ (2 .* log2(M_2eme_choix_value))) .* erfc( sqrt( (log2(M_2eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_2_mod == 4 % Modulation PSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_2eme_choix = (2 * f_b_value )/log2(M_2eme_choix_value); % Calcul de la bande passante du 2me choix - M-PSK
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_2eme_choix = log2(M_2eme_choix_value) / 2; % Calcul de l'efficacit spectrale du 2me choix - M-PSK
        set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_2eme_choix = (1/ (log2(M_2eme_choix_value) * (sin(pi/M_2eme_choix_value))^2)) * (erfcinv(log2(M_2eme_choix_value) * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = (1/ log2(M_2eme_choix_value)) * erfc( (sqrt(log2(M_2eme_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_2eme_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_2eme_choix = (1/ log2(M_2eme_choix_value)) * erfc( (sqrt(log2(M_2eme_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_2eme_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = (1./log2(M_2eme_choix_value)) .* erfc( (sqrt(log2(M_2eme_choix_value) .* Eb_N0_su)) .* sin(pi/M_2eme_choix_value)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = (1./log2(M_2eme_choix_value)) .* erfc( (sqrt(log2(M_2eme_choix_value) .* Eb_N0_su)) .* sin(pi/M_2eme_choix_value)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            end
        end        
        
	elseif Choix_2_mod == 5 % Modulation DPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_2eme_choix = 2*f_b_value; % Calcul de la bande passante du 2me choix - DPSK
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_2eme_choix = 1 / 2; % Calcul de l'efficacit spectrale du 2me choix - DPSK
        set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_2eme_choix =  -log((2*TEB_seuil_value)); % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_2eme_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_2_mod == 6 % Modulation OQPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_2eme_choix = f_b_value; % Calcul de la bande passante du 2me choix - OQPSK
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_2eme_choix = 1 ; % Calcul de l'efficacit spectrale du 2me choix - OQPSK
        set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix

        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :    
            Eb_N0_seuil_2eme_choix =  (erfcinv(2 * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_2eme_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
       
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_2_mod == 7 % Modulation QAM choisie
        
        % Vrification de la valeur de M : M=2 non acceptable
        if M_2eme_choix_value == 2
            errordlg('Choix 2 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
        end
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_2eme_choix = (2 * f_b_value )/log2(M_2eme_choix_value); % Calcul de la bande passante du 2me choix - M-QAM
            set(handles.Choix_2eme_W,'String',W_2eme_choix); % Affiche le rsultat de la bande passante du 2me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_2eme_choix = log2(M_2eme_choix_value) / 2 ; % Calcul de l'efficacit spectrale du 2me choix - M-QAM
        set(handles.Choix_2eme_eff_spectrale,'String',eff_spectrale_2eme_choix); % Affiche le rsultat de l'efficacit spectrale du 2me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_2eme_choix =  ((2* (M_2eme_choix_value - 1))/(3 *log2(M_2eme_choix_value))) *  (erfcinv( (sqrt(M_2eme_choix_value)*log2(M_2eme_choix_value) * TEB_seuil_value) / ( 2 * (sqrt(M_2eme_choix_value) - 1))))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_2eme_choix = 10*log10(Eb_N0_seuil_2eme_choix); % Conversion en dB
            set(handles.Choix_2eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_2eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 2me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_2eme_choix = eff_spectrale_2eme_choix * Eb_N0_seuil_2eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_2eme_choix = 10*log10(S_N_seuil_2eme_choix); % Conversion en dB
                set(handles.Choix_2eme_S_N_seuil,'String',S_N_seuil_dB_2eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 2me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_2eme_choix = ((2*(sqrt(M_2eme_choix_value) - 1) )/ (sqrt(M_2eme_choix_value) * log2(M_2eme_choix_value))) * erfc( sqrt( ((3*log2(M_2eme_choix_value)) / (2*(M_2eme_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_Eb_N0,'String',TEB_seuil_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_2eme_choix = ((2*(sqrt(M_2eme_choix_value) - 1) )/ (sqrt(M_2eme_choix_value) * log2(M_2eme_choix_value))) * erfc( sqrt( ((3*log2(M_2eme_choix_value)) / (2*(M_2eme_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_2eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_2eme_choix); % Affiche le rsultat du TEB seuil en dB du 2eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_2eme_choix = ((2.*(sqrt(M_2eme_choix_value) - 1) )./ (sqrt(M_2eme_choix_value) .* log2(M_2eme_choix_value))) .* erfc( sqrt( ((3.*log2(M_2eme_choix_value)) ./ (2.*(M_2eme_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_2eme_Choix = semilogy(Eb_N0_dB,TEB_2eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_2eme_choix = isempty(get(handles.Choix_2eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_2eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_2eme_choix = str2double(get(handles.Choix_2eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_2eme_choix); % Calcul de Eb_N0 sans unit
                TEB_2eme_choix = ((2.*(sqrt(M_2eme_choix_value) - 1) )./ (sqrt(M_2eme_choix_value) .* log2(M_2eme_choix_value))) .* erfc( sqrt( ((3.*log2(M_2eme_choix_value)) ./ (2.*(M_2eme_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_2eme_Choix = semilogy(S_N_dB,TEB_2eme_choix,'LineWidth',2);
            end
        end
  
    else
        errordlg('Choix 2 : Choisissez le mode de modulation','File Error');
	end
    
end    
    
    % 3me choix :

if value_M_3eme_choix == 0 % Si M_3 a t renseign
	M_3eme_choix_value = str2double(get(handles.M_3eme_choix,'String')); % Rcupration de la valeur de M_3

    if value_M_1er_choix == 0 || value_M_2eme_choix == 0
        hold on; % Si le 1er choix et ou le 2me a t renseign, enregistre la courbe
    end
    
	if Choix_3_mod == 1 % Si Modulation ASK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_3eme_choix = (2 * f_b_value )/log2(M_3eme_choix_value); % Calcul de la bande passante du 3me choix - M-ASK
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_3eme_choix = log2(M_3eme_choix_value) / 2; % Calcul de l'efficacit spectrale du 3me choix - M-ASK
        set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix = (((M_3eme_choix_value)^2 - 1 )/ (3 * log2(M_3eme_choix_value))) * (erfcinv((M_3eme_choix_value *log2(M_3eme_choix_value) * TEB_seuil_value ) / ( M_3eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = ((M_3eme_choix_value - 1 )/ (M_3eme_choix_value * log2(M_3eme_choix_value))) * erfc( sqrt( ((3 *log2(M_3eme_choix_value)) / ((M_3eme_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_3eme_choix = ((M_3eme_choix_value - 1 )/ (M_3eme_choix_value * log2(M_3eme_choix_value))) * erfc( sqrt( ((3 *log2(M_3eme_choix_value)) / ((M_3eme_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = ((M_3eme_choix_value - 1 )./ (M_3eme_choix_value .* log2(M_3eme_choix_value))) .* erfc( sqrt( ((3 .*log2(M_3eme_choix_value)) ./ ((M_3eme_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = ((M_3eme_choix_value - 1 )./ (M_3eme_choix_value .* log2(M_3eme_choix_value))) .* erfc( sqrt( ((3 .*log2(M_3eme_choix_value)) ./ ((M_3eme_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            end
        end
        
    elseif Choix_3_mod == 2 % Si Modulation FSK choisie
        
        % Calcul de la bande passante et de l'efficacit spectrale :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            Choix_3eme_Fc_demande = inputdlg({'Premire frquence de coupure en bits/s : f_c1','Frquence de coupure maximale en bits/s : f_cM'},'Choix 3 : Renseigner les frquences de coupure', [1 80; 1 80]); 
            user_Choix_3_val_f_c1 = str2double(Choix_3eme_Fc_demande{1}); % Rcupre la valeur de f_c1
            user_Choix_3_val_f_cM = str2double(Choix_3eme_Fc_demande{2}); % Rcupre la valeur de f_cM
            W_3eme_choix = user_Choix_3_val_f_cM - user_Choix_3_val_f_c1 + (2 * f_b_value )/log2(M_3eme_choix_value);  % Calcul de la bande passante du 3me choix - M-FSK
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
            eff_spectrale_3eme_choix = f_b_value / (W_3eme_choix); % Calcul de l'efficacit spectrale du 3me choix - M-FSK
            set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
        end
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix = (2/ (log2(M_3eme_choix_value))) * (erfcinv((2 *log2(M_3eme_choix_value) * TEB_seuil_value ) / ( M_3eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = ((M_3eme_choix_value - 1 )/ (2 * log2(M_3eme_choix_value))) * erfc( sqrt( (log2(M_3eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
                Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
                TEB_seuil_S_N_3eme_choix = ((M_3eme_choix_value - 1 )/ (2 * log2(M_3eme_choix_value))) * erfc( sqrt( (log2(M_3eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
                set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
            else
                errordlg('Choix 3 : Rentrer la frquence binaire','File Error');
            end
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = ((M_3eme_choix_value - 1 )./ (2 .* log2(M_3eme_choix_value))) .* erfc( sqrt( (log2(M_3eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = ((M_3eme_choix_value - 1 )./ (2 .* log2(M_3eme_choix_value))) .* erfc( sqrt( (log2(M_3eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            else
                errordlg('Choix 3 : Rentrer la frquence binaire','File Error');
            end
        end
            
    elseif Choix_3_mod == 3 % Modulation OFSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_3eme_choix = ((M_3eme_choix_value + 1)/log2(M_3eme_choix_value)) * f_b_value; % Calcul de la bande passante du 3me choix - M-OFSK
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_3eme_choix = log2(M_3eme_choix_value)/(M_3eme_choix_value + 1); % Calcul de l'efficacit spectrale du 3me choix - M-OFSK
        set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix = (2/ (log2(M_3eme_choix_value))) * (erfcinv((2 *log2(M_3eme_choix_value) * TEB_seuil_value ) / ( M_3eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = ((M_3eme_choix_value - 1 )/ (2 * log2(M_3eme_choix_value))) * erfc( sqrt( (log2(M_3eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_3eme_choix = ((M_3eme_choix_value - 1 )/ (2 * log2(M_3eme_choix_value))) * erfc( sqrt( (log2(M_3eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = ((M_3eme_choix_value - 1 )./ (2 .* log2(M_3eme_choix_value))) .* erfc( sqrt( (log2(M_3eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = ((M_3eme_choix_value - 1 )./ (2 .* log2(M_3eme_choix_value))) .* erfc( sqrt( (log2(M_3eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            end
        end
        
    elseif Choix_3_mod == 4 % Modulation PSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_3eme_choix = (2 * f_b_value )/log2(M_3eme_choix_value); % Calcul de la bande passante du 3me choix - M-PSK
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_3eme_choix = log2(M_3eme_choix_value) / 2; % Calcul de l'efficacit spectrale du 3me choix - M-PSK
        set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
        
        % Calcul Eb_N0 seuil et S/N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix = (1/ (log2(M_3eme_choix_value) * (sin(pi/M_3eme_choix_value))^2)) * (erfcinv(log2(M_3eme_choix_value) * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
            
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = (1/ log2(M_3eme_choix_value)) * erfc( (sqrt(log2(M_3eme_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_3eme_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_3eme_choix = (1/ log2(M_3eme_choix_value)) * erfc( (sqrt(log2(M_3eme_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_3eme_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = (1./log2(M_3eme_choix_value)) .* erfc( (sqrt(log2(M_3eme_choix_value) .* Eb_N0_su)) .* sin(pi/M_3eme_choix_value)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = (1./log2(M_3eme_choix_value)) .* erfc( (sqrt(log2(M_3eme_choix_value) .* Eb_N0_su)) .* sin(pi/M_3eme_choix_value)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            end
        end
        
    elseif Choix_3_mod == 5 % Modulation DPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_3eme_choix = 2*f_b_value; % Calcul de la bande passante du 3me choix - DPSK
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_3eme_choix = 1 / 2; % Calcul de l'efficacit spectrale du 3me choix - DPSK
        set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix =  -log((2*TEB_seuil_value)); % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_3eme_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            end
        end
        
    elseif Choix_3_mod == 6 % Modulation OQPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_3eme_choix = f_b_value; % Calcul de la bande passante du 3me choix - OQPSK
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_3eme_choix = 1 ; % Calcul de l'efficacit spectrale du 3me choix - OQPSK
        set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
  
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix =  (erfcinv(2 * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_3eme_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            end
        end
        
    elseif Choix_3_mod == 7 % Modulation QAM choisie
        
        % Vrification valeur de M : M = 2 non acceptable
        if M_3eme_choix_value == 2
        	errordlg('Choix 3 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
        end
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_3eme_choix = (2 * f_b_value )/log2(M_3eme_choix_value); % Calcul de la bande passante du 3me choix - M-QAM
            set(handles.Choix_3eme_W,'String',W_3eme_choix); % Affiche le rsultat de la bande passante du 3me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_3eme_choix = log2(M_3eme_choix_value) / 2 ; % Calcul de l'efficacit spectrale du 3me choix - M-QAM
        set(handles.Choix_3eme_eff_spectrale,'String',eff_spectrale_3eme_choix); % Affiche le rsultat de l'efficacit spectrale du 3me choix
        
        % Calcul Eb_N0 seuil et S/N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_3eme_choix =  ((2* (M_3eme_choix_value - 1))/(3 *log2(M_3eme_choix_value))) *  (erfcinv( (sqrt(M_3eme_choix_value)*log2(M_3eme_choix_value) * TEB_seuil_value) / ( 2 * (sqrt(M_3eme_choix_value) - 1))))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_3eme_choix = 10*log10(Eb_N0_seuil_3eme_choix); % Conversion en dB
            set(handles.Choix_3eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_3eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 3me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_3eme_choix = eff_spectrale_3eme_choix * Eb_N0_seuil_3eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_3eme_choix = 10*log10(S_N_seuil_3eme_choix); % Conversion en dB
                set(handles.Choix_3eme_S_N_seuil,'String',S_N_seuil_dB_3eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 3me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_3eme_choix = ((2*(sqrt(M_3eme_choix_value) - 1) )/ (sqrt(M_3eme_choix_value) * log2(M_3eme_choix_value))) * erfc( sqrt( ((3*log2(M_3eme_choix_value)) / (2*(M_3eme_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_Eb_N0,'String',TEB_seuil_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_3eme_choix = ((2*(sqrt(M_3eme_choix_value) - 1) )/ (sqrt(M_3eme_choix_value) * log2(M_3eme_choix_value))) * erfc( sqrt( ((3*log2(M_3eme_choix_value)) / (2*(M_3eme_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_3eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_3eme_choix); % Affiche le rsultat du TEB seuil en dB du 3eme choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_3eme_choix = ((2.*(sqrt(M_3eme_choix_value) - 1) )./ (sqrt(M_3eme_choix_value) .* log2(M_3eme_choix_value))) .* erfc( sqrt( ((3.*log2(M_3eme_choix_value)) ./ (2.*(M_3eme_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_3eme_Choix = semilogy(Eb_N0_dB,TEB_3eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_3eme_choix = isempty(get(handles.Choix_3eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_3eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_3eme_choix = str2double(get(handles.Choix_3eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_3eme_choix); % Calcul de Eb_N0 sans unit
                TEB_3eme_choix = ((2.*(sqrt(M_3eme_choix_value) - 1) )./ (sqrt(M_3eme_choix_value) .* log2(M_3eme_choix_value))) .* erfc( sqrt( ((3.*log2(M_3eme_choix_value)) ./ (2.*(M_3eme_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_3eme_Choix = semilogy(S_N_dB,TEB_3eme_choix,'LineWidth',2);
            end
        end
        
	else
        errordlg('Choix 3 : Choisissez le mode de modulation','File Error');
	end
end 

    % 4me choix :

if value_M_4eme_choix == 0 % Si M_4 a t renseign
	M_4eme_choix_value = str2double(get(handles.M_4eme_choix,'String')); % Rcupration de la valeur de M_4

    if value_M_1er_choix == 0 || value_M_2eme_choix == 0 || value_M_3eme_choix == 0
        hold on; % Si le 1er et ou le 2me et ou le 4me choix a t renseign, enregistre la courbe
    end
    
	if Choix_4_mod == 1 % Si Modulation ASK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_4eme_choix = (2 * f_b_value )/log2(M_4eme_choix_value); % Calcul de la bande passante du 4me choix - M-ASK
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_4eme_choix = log2(M_4eme_choix_value) / 2; % Calcul de l'efficacit spectrale du 4me choix - M-ASK
        set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix = (((M_4eme_choix_value)^2 - 1 )/ (3 * log2(M_4eme_choix_value))) * (erfcinv((M_4eme_choix_value *log2(M_4eme_choix_value) * TEB_seuil_value ) / ( M_4eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = ((M_4eme_choix_value - 1 )/ (M_4eme_choix_value * log2(M_4eme_choix_value))) * erfc( sqrt( ((3 *log2(M_4eme_choix_value)) / ((M_4eme_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_4eme_choix = ((M_4eme_choix_value - 1 )/ (M_4eme_choix_value * log2(M_4eme_choix_value))) * erfc( sqrt( ((3 *log2(M_4eme_choix_value)) / ((M_4eme_choix_value)^2 - 1)) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = ((M_4eme_choix_value - 1 )./ (M_4eme_choix_value .* log2(M_4eme_choix_value))) .* erfc( sqrt( ((3 .*log2(M_4eme_choix_value)) ./ ((M_4eme_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = ((M_4eme_choix_value - 1 )./ (M_4eme_choix_value .* log2(M_4eme_choix_value))) .* erfc( sqrt( ((3 .*log2(M_4eme_choix_value)) ./ ((M_4eme_choix_value)^2 - 1)) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_4_mod == 2 % Si Modulation FSK choisie
        
        % Calcul de la bande passante et de l'efficacit spectrale :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            Choix_4eme_Fc_demande = inputdlg({'Premire frquence de coupure en bits/s : f_c1','Frquence de coupure maximale en bits/s : f_cM'},'Choix 4 : Renseigner les frquences de coupure', [1 80; 1 80]); 
            user_Choix_4_val_f_c1 = str2double(Choix_4eme_Fc_demande{1}); % Rcupre la valeur de f_c1
            user_Choix_4_val_f_cM = str2double(Choix_4eme_Fc_demande{2}); % Rcupre la valeur de f_cM
            W_4eme_choix = user_Choix_4_val_f_cM - user_Choix_4_val_f_c1 + (2 * f_b_value )/log2(M_4eme_choix_value);  % Calcul de la bande passante du 4me choix - M-FSK
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
            eff_spectrale_4eme_choix = f_b_value / (W_4eme_choix); % Calcul de l'efficacit spectrale du 4me choix - M-FSK
            set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix
        end
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix = (2/ (log2(M_4eme_choix_value))) * (erfcinv((2 *log2(M_4eme_choix_value) * TEB_seuil_value ) / ( M_4eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = ((M_4eme_choix_value - 1 )/ (2 * log2(M_4eme_choix_value))) * erfc( sqrt( (log2(M_4eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
                Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
                TEB_seuil_S_N_4eme_choix = ((M_4eme_choix_value - 1 )/ (2 * log2(M_4eme_choix_value))) * erfc( sqrt( (log2(M_4eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
                set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
            else
                errordlg('Choix 4 : Rentrer la frquence binaire','File Error');
            end
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = ((M_4eme_choix_value - 1 )./ (2 .* log2(M_4eme_choix_value))) .* erfc( sqrt( (log2(M_4eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = ((M_4eme_choix_value - 1 )./ (2 .* log2(M_4eme_choix_value))) .* erfc( sqrt( (log2(M_4eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            else
                errordlg('Choix 4 : Rentrer la frquence binaire','File Error');
            end
        end

	elseif Choix_4_mod == 3 % Modulation OFSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_4eme_choix = ((M_4eme_choix_value + 1)/log2(M_4eme_choix_value)) * f_b_value; % Calcul de la bande passante du 4me choix - M-OFSK
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_4eme_choix = log2(M_4eme_choix_value)/(M_4eme_choix_value + 1); % Calcul de l'efficacit spectrale du 4me choix - M-OFSK
        set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                %Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix = (2/ (log2(M_4eme_choix_value))) * (erfcinv((2 *log2(M_4eme_choix_value) * TEB_seuil_value ) / ( M_4eme_choix_value - 1 )))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = ((M_4eme_choix_value - 1 )/ (2 * log2(M_4eme_choix_value))) * erfc( sqrt( (log2(M_4eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_4eme_choix = ((M_4eme_choix_value - 1 )/ (2 * log2(M_4eme_choix_value))) * erfc( sqrt( (log2(M_4eme_choix_value) / 2) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = ((M_4eme_choix_value - 1 )./ (2 .* log2(M_4eme_choix_value))) .* erfc( sqrt( (log2(M_4eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = ((M_4eme_choix_value - 1 )./ (2 .* log2(M_4eme_choix_value))) .* erfc( sqrt( (log2(M_4eme_choix_value) ./ 2) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_4_mod == 4 % Modulation PSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_4eme_choix = (2 * f_b_value )/log2(M_4eme_choix_value); % Calcul de la bande passante du 4me choix - M-PSK
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_4eme_choix = log2(M_4eme_choix_value) / 2; % Calcul de l'efficacit spectrale du 4me choix - M-PSK
        set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix

        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix = (1/ (log2(M_4eme_choix_value) * (sin(pi/M_4eme_choix_value))^2)) * (erfcinv(log2(M_4eme_choix_value) * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = (1/ log2(M_4eme_choix_value)) * erfc( (sqrt(log2(M_4eme_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_4eme_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_4eme_choix = (1/ log2(M_4eme_choix_value)) * erfc( (sqrt(log2(M_4eme_choix_value) * Eb_N0_seuil_su_value)) * sin(pi/M_4eme_choix_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = (1./log2(M_4eme_choix_value)) .* erfc( (sqrt(log2(M_4eme_choix_value) .* Eb_N0_su)) .* sin(pi/M_4eme_choix_value)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = (1./log2(M_4eme_choix_value)) .* erfc( (sqrt(log2(M_4eme_choix_value) .* Eb_N0_su)) .* sin(pi/M_4eme_choix_value)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_4_mod == 5 % Modulation DPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_4eme_choix = 2*f_b_value; % Calcul de la bande passante du 4me choix - DPSK
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_4eme_choix = 1 / 2; % Calcul de l'efficacit spectrale du 4me choix - DPSK
        set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix =  -log((2*TEB_seuil_value)); % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_4eme_choix = (1/2) * exp( - Eb_N0_seuil_su_value); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = (1/2) .* exp( - Eb_N0_su); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_4_mod == 6 % Modulation OQPSK choisie
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_4eme_choix = f_b_value; % Calcul de la bande passante du 4me choix - OQPSK
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_4eme_choix = 1 ; % Calcul de l'efficacit spectrale du 4me choix - OQPSK
        set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix
   
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix =  (erfcinv(2 * TEB_seuil_value ))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_4eme_choix = (1/2) * erfc(sqrt(Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = (1/2) .* erfc(sqrt(Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            end
        end
        
	elseif Choix_4_mod == 7 % Modulation QAM choisie
        
        % Vrification de la valeur de M (M=2 non acceptable) :
        if M_4eme_choix_value == 2
            errordlg('Choix 4 : Valeur minimale d''une modulation M-QAM est M=4','File Error');
        end
        
        % Calcul de la bande passante :
        if value_f_b == 0 % Si f_b a t renseigne
            f_b_value = str2double(get(handles.f_b,'String')); % Rcupration de la valeur de f_b
            W_4eme_choix = (2 * f_b_value )/log2(M_4eme_choix_value); % Calcul de la bande passante du 4me choix - M-QAM
            set(handles.Choix_4eme_W,'String',W_4eme_choix); % Affiche le rsultat de la bande passante du 4me choix
        end
        
        % Calcul de l'efficacit spectrale :
        eff_spectrale_4eme_choix = log2(M_4eme_choix_value) / 2 ; % Calcul de l'efficacit spectrale du 4me choix - M-QAM
        set(handles.Choix_4eme_eff_spectrale,'String',eff_spectrale_4eme_choix); % Affiche le rsultat de l'efficacit spectrale du 4me choix
        
        % Calcul Eb_N0 seuil et S_N seuil si TEB_seuil renseign :
        if value_TEB_seuil == 0 % Si TEB seuil renseign
            TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
            
                % Calcul Eb_N0 seuil :
            Eb_N0_seuil_4eme_choix =  ((2* (M_4eme_choix_value - 1))/(3 *log2(M_4eme_choix_value))) *  (erfcinv( (sqrt(M_4eme_choix_value)*log2(M_4eme_choix_value) * TEB_seuil_value) / ( 2 * (sqrt(M_4eme_choix_value) - 1))))^2; % Calcul du Eb_N0 seuil sans unit
            Eb_N0_seuil_dB_4eme_choix = 10*log10(Eb_N0_seuil_4eme_choix); % Conversion en dB
            set(handles.Choix_4eme_Eb_N0_seuil,'String',Eb_N0_seuil_dB_4eme_choix); % Affiche le rsultat du rapport Eb_N0 seuil en dB du 4me choix
        
                % Calcul S_N seuil :
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si l'efficacit spectrale est connue
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_seuil_4eme_choix = eff_spectrale_4eme_choix * Eb_N0_seuil_4eme_choix; % Calcul du S/N seuil sans unit
                S_N_seuil_dB_4eme_choix = 10*log10(S_N_seuil_4eme_choix); % Conversion en dB
                set(handles.Choix_4eme_S_N_seuil,'String',S_N_seuil_dB_4eme_choix); % Affiche le rsultat du rapport S_N seuil en dB du 4me choix
            end
        end
        
        % Calcul TEB seuil si Eb_N0_seuil renseign :
        if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
            Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
            Eb_N0_seuil_su_value = 10^(Eb_N0_seuil_dB_value/10); % Conversion des dB  sans unit
            TEB_seuil_4eme_choix = ((2*(sqrt(M_4eme_choix_value) - 1) )/ (sqrt(M_4eme_choix_value) * log2(M_4eme_choix_value))) * erfc( sqrt( ((3*log2(M_4eme_choix_value)) / (2*(M_4eme_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_Eb_N0,'String',TEB_seuil_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB seuil si S_N_seuil renseign :
        value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
        if value_S_N_seuil == 0 && value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
            S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du rapport S/N seuil
            eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
            S_N_seuil_su_value = 10^(S_N_seuil_dB_value/10); % Conversion des dB  sans unit
            Eb_N0_seuil_su_value = S_N_seuil_su_value * (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 seuil
            TEB_seuil_S_N_4eme_choix = ((2*(sqrt(M_4eme_choix_value) - 1) )/ (sqrt(M_4eme_choix_value) * log2(M_4eme_choix_value))) * erfc( sqrt( ((3*log2(M_4eme_choix_value)) / (2*(M_4eme_choix_value - 1))) * Eb_N0_seuil_su_value)); % Calcul du TEB seuil sans unit
            set(handles.Choix_4eme_TEB_seuil_S_N,'String',TEB_seuil_S_N_4eme_choix); % Affiche le rsultat du TEB seuil en dB du 4me choix
        end
        
        % Calcul TEB en fonction de Eb_N0 :
        if Choix_representation_graphique == 1
            Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
            Eb_N0_su = 10.^(Eb_N0_dB./10); % Conversion Eb_N0_dB sans unit
            TEB_4eme_choix = ((2.*(sqrt(M_4eme_choix_value) - 1))./ (sqrt(M_4eme_choix_value) .* log2(M_4eme_choix_value))) .* erfc( sqrt( ((3.*log2(M_4eme_choix_value)) ./ (2.*(M_4eme_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
            Afficher_TEB_Eb_N0_4eme_Choix = semilogy(Eb_N0_dB,TEB_4eme_choix,'LineWidth',2);
        end
        
        % Calcul TEB en fonction de S_N :
        if Choix_representation_graphique == 2
            value_eff_spectrale_4eme_choix = isempty(get(handles.Choix_4eme_eff_spectrale,'String')); % =1 si vide =0 sinon
            if value_eff_spectrale_4eme_choix ==0 % Si S/N seuil et l'efficacit spectrale renseigns
                eff_spectrale_4eme_choix = str2double(get(handles.Choix_4eme_eff_spectrale,'String')); % Rcupration de la valeur de l'efficacit spectrale
                S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
                S_N_su = 10.^(S_N_dB./10); % Conversion S_N_dB sans unit
                Eb_N0_su = S_N_su .* (1/eff_spectrale_4eme_choix); % Calcul de Eb_N0 sans unit
                TEB_4eme_choix = ((2.*(sqrt(M_4eme_choix_value) - 1))./ (sqrt(M_4eme_choix_value) .* log2(M_4eme_choix_value))) .* erfc( sqrt( ((3.*log2(M_4eme_choix_value)) ./ (2.*(M_4eme_choix_value - 1))) .* Eb_N0_su)); % Calcul du TEB sans unit
                Afficher_TEB_S_N_4eme_Choix = semilogy(S_N_dB,TEB_4eme_choix,'LineWidth',2);
            end
        end
        
	else
        errordlg('Choix 4 : Choisissez le mode de modulation','File Error');
	end
end


% Tracer  TEB en fonction de Eb/N0 :
 
Choix_representation_graphique = get(handles.Choix_representation_graph,'UserData');

if Choix_representation_graphique == 1 % Reprsentation TEB en fonction de E_b_N0
    % Si TEB seuil renseign :
	if value_TEB_seuil == 0 % Si TEB seuil renseign
        Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
        if value_M_1er_choix == 0 || value_M_2eme_choix == 0 || value_M_3eme_choix == 0 || value_M_4eme_choix == 0
            hold on; % Si l'un des choix a t renseign, enregistre la courbe
        end
        TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
        TEB_1er_choix_seuil = yline(TEB_seuil_value,'--r','TEB seuil');
        Afficher_TEB_Seuil = semilogy(Eb_N0_dB,TEB_1er_choix_seuil,'--r','LineWidth',0.5); 
	end
    
    % Si Eb_N0 seuil renseign :
	if value_Eb_N0_seuil == 0 % Si Eb_N0 seuil renseign
        if value_M_1er_choix == 0 || value_M_2eme_choix == 0 || value_M_3eme_choix == 0 || value_M_4eme_choix == 0 || value_TEB_seuil == 0
            hold on; % Si l'un des choix et ou le TEB seuil a t renseign, enregistre la courbe
        end
        Eb_N0_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
        Eb_N0_seuil_dB_value = str2double(get(handles.Eb_N0_seuil,'String')); % Rcupration de la valeur du Eb_N0 seuil
        Trace_Eb_N0_seuil_dB = xline(Eb_N0_seuil_dB_value,'--r','Eb/N0 seuil');
        Afficher_Eb_N0_seuil = semilogy(Eb_N0_dB, Trace_Eb_N0_seuil_dB,'--r','LineWidth',0.5);
	end
    
	
	grid on;
	ylim ([10^(-15) 10^(0)]);
	ylabel('TEB','LineWidth',3,'FontWeight','bold');
	xlabel('E_b/N_0 en dB','LineWidth',3,'FontWeight','bold');
    
    if value_M_1er_choix == 0 % Si M_1 a t renseign
        if value_M_2eme_choix == 0 && value_M_3eme_choix == 0 % Si M_2 et M_3 ont t renseigns
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1, M2, M3 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1, M2 et M3 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 0 && value_M_3eme_choix == 1 % Si M_2 connu et M_3 non connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1, M2 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 2me choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 1er choix', 'TEB 2me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1 et M2 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 2me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_2eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 2me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_2eme_Choix],{'TEB 1er choix', 'TEB 2me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 1 && value_M_3eme_choix == 0 % Si M_2 non connu et M_3 connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1, M3 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                	legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_3eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_3eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_3eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 3me choix', 'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 1er choix', 'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1 et M3 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 3me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 3me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_3eme_Choix],{'TEB 1er choix', 'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        else  % Si M_2 et M_3 non connus 
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                	legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 1er choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1 connu
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 1er choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_TEB_Seuil],{'TEB 1er choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_1er_Choix; Afficher_Eb_N0_seuil],{'TEB 1er choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_1er_Choix],{'TEB 1er choix'},'FontSize',9,'FontWeight','bold');
                end
            end
        end
        
	else % M_1 non connu
        if value_M_2eme_choix == 0 && value_M_3eme_choix == 0 % Si M_2 et M_3 ont t renseigns
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M2, M3 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([ Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([ Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M2 et M3 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'TEB 3me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'TEB 3me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_3eme_Choix],{'TEB 2me choix', 'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 0 && value_M_3eme_choix == 1 % Si M_2 connu et M_3 non connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M2 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_2eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 2me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M2 connu
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 2me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_2eme_Choix; Afficher_Eb_N0_seuil],{'TEB 2me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_2eme_Choix],{'TEB 2me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 1 && value_M_3eme_choix == 0 % Si M_2 non connu et M_3 connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M3 et M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                	legend([Afficher_TEB_Eb_N0_3eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_3eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_3eme_Choix;Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 3me choix', 'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M3 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                    legend([Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 3me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_3eme_Choix; Afficher_TEB_Seuil],{'TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_3eme_Choix; Afficher_Eb_N0_seuil],{'TEB 3me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_3eme_Choix],{'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        else  % Si M_2 et M_3 non connus 
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M4 connus
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                	legend([Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB 4me choix','TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Eb_N0_4eme_Choix; Afficher_TEB_Seuil],{'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_Eb_N0_seuil == 0 && value_TEB_seuil == 1  % Seulement Eb_N0 seuil connu
                    legend([Afficher_TEB_Eb_N0_4eme_Choix; Afficher_Eb_N0_seuil],{'TEB 4me choix', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_Eb_N0_4eme_Choix],{'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else
                if value_TEB_seuil == 0 && value_Eb_N0_seuil == 0 % TEB seuil et Eb_N0 connus
                	legend([Afficher_TEB_Seuil; Afficher_Eb_N0_seuil],{'TEB seuil', 'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_Eb_N0_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Seuil],{'TEB seuil'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_Eb_N0_seuil],{'Eb/N0 seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                end
            end
        end
    end
                 
    hold off;
end

% Tracer  TEB en fonction de S/N :
 
if Choix_representation_graphique == 2 % Reprsentation TEB en fonction de S/N

 % Si TEB seuil renseign :
	if value_TEB_seuil == 0 % Si TEB seuil renseign
        S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
        if value_M_1er_choix == 0 || value_M_2eme_choix == 0 || value_M_3eme_choix == 0 || value_M_4eme_choix == 0
            hold on; % Si l'un des choix a t renseign, enregistre la courbe
        end
        TEB_seuil_value = str2num(get(handles.TEB_seuil,'String')); % Rcupration de la valeur du TEB seuil
        TEB_1er_choix_seuil = yline(TEB_seuil_value,'--r','TEB seuil');
        Afficher_TEB_Seuil = semilogy(S_N_dB,TEB_1er_choix_seuil,'--r','LineWidth',0.5); 
	end
    
    % Si S/N seuil renseign :
	if value_S_N_seuil == 0 % Si S_N seuil renseign
        if value_M_1er_choix == 0 || value_M_2eme_choix == 0 || value_M_3eme_choix == 0 || value_M_4eme_choix == 0 || value_TEB_seuil == 0
            hold on; % Si l'un des choix et ou le TEB seuil a t renseign, enregistre la courbe
        end
        S_N_dB = 0 : 0.1 : 30; % chelle de 0  30 dB
        S_N_seuil_dB_value = str2double(get(handles.S_N_seuil,'String')); % Rcupration de la valeur du S_N seuil
        Trace_S_N_seuil_dB = xline(S_N_seuil_dB_value,'--r','S/N seuil');
        Afficher_S_N_seuil = semilogy(S_N_dB, Trace_S_N_seuil_dB,'--r','LineWidth',0.5);
	end
    
	
	grid on;
	ylim ([10^(-15) 10^(0)]);
	ylabel('TEB','LineWidth',3,'FontWeight','bold');
	xlabel('S/N en dB','LineWidth',3,'FontWeight','bold');
    
    if value_M_1er_choix == 0 % Si M_1 a t renseign
        if value_M_2eme_choix == 0 && value_M_3eme_choix == 0 % Si M_2 et M_3 ont t renseigns
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1, M2, M3 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix;Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1, M2 et M3 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_3eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 3me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix;Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix],{'TEB 1er choix', 'TEB 2me choix', 'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 0 && value_M_3eme_choix == 1 % Si M_2 connu et M_3 non connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1, M2 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 2me choix', 'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 2me choix', 'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix;Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 1er choix', 'TEB 2me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1 et M2 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S/N connus
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 2me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 2me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S/N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_2eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 2me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix;Afficher_TEB_S_N_2eme_Choix],{'TEB 1er choix', 'TEB 2me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 1 && value_M_3eme_choix == 0 % Si M_2 non connu et M_3 connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1, M3 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                	legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'S/N (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 3me choix', 'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 1er choix', 'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1 et M3 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 3me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix','TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 3me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_3eme_Choix],{'TEB 1er choix', 'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        else  % Si M_2 et M_3 non connus 
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M1 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                	legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix', 'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 1er choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 1er choix','TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 1er choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M1 connu
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 1er choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_TEB_Seuil],{'TEB 1er choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_1er_Choix; Afficher_S_N_seuil],{'TEB 1er choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_1er_Choix],{'TEB 1er choix'},'FontSize',9,'FontWeight','bold');
                end
            end
        end
        
	else % M_1 non connu
        if value_M_2eme_choix == 0 && value_M_3eme_choix == 0 % Si M_2 et M_3 ont t renseigns
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M2, M3 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([ Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([ Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 2me choix', 'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M2 et M3 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 2me choix', 'TEB 3me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix; Afficher_S_N_seuil],{'TEB 2me choix', 'TEB 3me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_3eme_Choix],{'TEB 2me choix', 'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 0 && value_M_3eme_choix == 1 % Si M_2 connu et M_3 non connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M2 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 2me choix', 'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_2eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 2me choix', 'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 2me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M2 connu
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 2me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_TEB_Seuil],{'TEB 2me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_2eme_Choix; Afficher_S_N_seuil],{'TEB 2me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_2eme_Choix],{'TEB 2me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        elseif value_M_2eme_choix == 1 && value_M_3eme_choix == 0 % Si M_2 non connu et M_3 connu
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M3 et M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                	legend([Afficher_TEB_S_N_3eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 3me choix', 'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_3eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 3me choix', 'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_3eme_Choix;Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 3me choix', 'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_S_N_4eme_Choix],{'TEB 3me choix', 'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else % M3 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                    legend([Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 3me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_3eme_Choix; Afficher_TEB_Seuil],{'TEB 3me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_3eme_Choix; Afficher_S_N_seuil],{'TEB 3me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_3eme_Choix],{'TEB 3me choix'},'FontSize',9,'FontWeight','bold');
                end
            end
            
        else  % Si M_2 et M_3 non connus 
            if value_M_4eme_choix == 0 % Si M_4 a t renseign => M4 connus
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                	legend([Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB 4me choix','TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_S_N_4eme_Choix; Afficher_TEB_Seuil],{'TEB 4me choix', 'TEB seuil'},'FontSize',9,'FontWeight','bold');
                elseif value_S_N_seuil == 0 && value_TEB_seuil == 1  % Seulement S_N seuil connu
                    legend([Afficher_TEB_S_N_4eme_Choix; Afficher_S_N_seuil],{'TEB 4me choix', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_TEB_S_N_4eme_Choix],{'TEB 4me choix'},'FontSize',9,'FontWeight','bold');
                end
            else
                if value_TEB_seuil == 0 && value_S_N_seuil == 0 % TEB seuil et S_N connus
                	legend([Afficher_TEB_Seuil; Afficher_S_N_seuil],{'TEB seuil', 'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                elseif value_TEB_seuil == 0 && value_S_N_seuil == 1 % Seulement TEB seuil connu
                    legend([Afficher_TEB_Seuil],{'TEB seuil'},'FontSize',9,'FontWeight','bold');
                else
                    legend([Afficher_S_N_seuil],{'S/N seuil (en dB)'},'FontSize',9,'FontWeight','bold');
                end
            end
        end
    end
                 
    hold off;
end
   



% --- Executes on button press in effacer.
function effacer_Callback(hObject, eventdata, handles)
% hObject    handle to effacer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Effacer les valeurs d'entre du programme :

set(handles.M_1er_choix, 'String', ''); % Efface la valeur du nombre d'tats du 1er choix
set(handles.M_2eme_choix, 'String', ''); % Efface la valeur du nombre d'tats du 2eme choix
set(handles.M_3eme_choix, 'String', ''); % Efface la valeur du nombre d'tats du 3eme choix
set(handles.M_4eme_choix, 'String', ''); % Efface la valeur du nombre d'tats du 4eme choix
set(handles.Choix_modulation_1er_choix, 'Value', 1); % Remet le popumenu "Choix mode de modulation du 1er choix"  l'tat initial
set(handles.Choix_modulation_2eme_choix, 'Value', 1); % Remet le popumenu "Choix mode de modulation du 2eme choix"  l'tat initial
set(handles.Choix_modulation_3eme_choix, 'Value', 1); % Remet le popumenu "Choix mode de modulation du 3eme choix"  l'tat initial
set(handles.Choix_modulation_4eme_choix, 'Value', 1); % Remet le popumenu "Choix mode de modulation du 4eme choix"  l'tat initial
set(handles.Choix_representation_graph, 'Value', 1); % Remet le popumenu "Choix reprsentation graphique"  l'tat initial
set(handles.f_b, 'String', ''); % Efface la valeur de la frquence binaire
set(handles.TEB_seuil, 'String', ''); % Efface la valeur du TEB seuil
set(handles.Eb_N0_seuil, 'String', ''); % Efface la valeur du Eb_N0 seuil
set(handles.S_N_seuil, 'String', ''); % Efface la valeur du S/N seuil



% Effacer les valeurs de sortie du programme :

    % 1er choix :
set(handles.Choix_1er_m, 'String', ''); % Efface la valeur du nombre de bits/symbole 1er choix
set(handles.Choix_1er_W, 'String', ''); % Efface la valeur de la bande passante du 1er choix
set(handles.Choix_1er_eff_spectrale, 'String', ''); % Efface la valeur de l'efficacit spectrale du 1er choix
set(handles.Choix_1er_f_s, 'String', ''); % Efface la valeur de la frquence symbole du 1er choix
set(handles.Choix_1er_S_N_seuil, 'String', ''); % Efface la valeur de la distance min du 1er choix
set(handles.Choix_1er_Eb_N0_seuil, 'String', ''); % Efface la valeur du rapport Eb/N0 seuil du 1er choix
set(handles.Choix_1er_TEB_seuil_Eb_N0, 'String', ''); % Efface la valeur du TEB seuil si Eb_N0 donn du 1er choix
set(handles.Choix_1er_TEB_seuil_S_N, 'String', ''); % Efface la valeur du TEB seuil si d donne du 1er choix

    % 2eme choix :
set(handles.Choix_2eme_m, 'String', ''); % Efface la valeur du nombre de bits/symbole 2eme choix
set(handles.Choix_2eme_W, 'String', ''); % Efface la valeur de la bande passante du 2eme choix
set(handles.Choix_2eme_eff_spectrale, 'String', ''); % Efface la valeur de l'efficacit spectrale du 2eme choix
set(handles.Choix_2eme_f_s, 'String', ''); % Efface la valeur de la frquence symbole du 2eme choix
set(handles.Choix_2eme_S_N_seuil, 'String', ''); % Efface la valeur de la distance min du 2eme choix
set(handles.Choix_2eme_Eb_N0_seuil, 'String', ''); % Efface la valeur du rapport Eb/N0 seuil du 2eme choix
set(handles.Choix_2eme_TEB_seuil_Eb_N0, 'String', ''); % Efface la valeur du TEB seuil si Eb_N0 donn du 2eme choix
set(handles.Choix_2eme_TEB_seuil_S_N, 'String', ''); % Efface la valeur du TEB seuil si d donne du 2eme choix

    % 3eme choix :
set(handles.Choix_3eme_m, 'String', ''); % Efface la valeur du nombre de bits/symbole 3eme choix
set(handles.Choix_3eme_W, 'String', ''); % Efface la valeur de la bande passante du 3eme choix
set(handles.Choix_3eme_eff_spectrale, 'String', ''); % Efface la valeur de l'efficacit spectrale du 3eme choix
set(handles.Choix_3eme_f_s, 'String', ''); % Efface la valeur de la frquence symbole du 3eme choix
set(handles.Choix_3eme_S_N_seuil, 'String', ''); % Efface la valeur de la distance min du 3eme choix
set(handles.Choix_3eme_Eb_N0_seuil, 'String', ''); % Efface la valeur du rapport Eb/N0 seuil du 3eme choix
set(handles.Choix_3eme_TEB_seuil_Eb_N0, 'String', ''); % Efface la valeur du TEB seuil si Eb_N0 donn du 3eme choix
set(handles.Choix_3eme_TEB_seuil_S_N, 'String', ''); % Efface la valeur du TEB seuil si d donne du 3eme choix

    % 4eme choix :
set(handles.Choix_4eme_m, 'String', ''); % Efface la valeur du nombre de bits/symbole 4eme choix
set(handles.Choix_4eme_W, 'String', ''); % Efface la valeur de la bande passante du 4eme choix
set(handles.Choix_4eme_eff_spectrale, 'String', ''); % Efface la valeur de l'efficacit spectrale du 4eme choix
set(handles.Choix_4eme_f_s, 'String', ''); % Efface la valeur de la frquence symbole du 4eme choix
set(handles.Choix_4eme_S_N_seuil, 'String', ''); % Efface la valeur de la distance min du 4eme choix
set(handles.Choix_4eme_Eb_N0_seuil, 'String', ''); % Efface la valeur du rapport Eb/N0 seuil du 4eme choix
set(handles.Choix_4eme_TEB_seuil_Eb_N0, 'String', ''); % Efface la valeur du TEB seuil si Eb_N0 donn du 4eme choix
set(handles.Choix_4eme_TEB_seuil_S_N, 'String', ''); % Efface la valeur du TEB seuil si d donne du 4eme choix
cla(handles.representation_graph,'reset'); % Remet la figure  l'tat initial

% --- Executes on button press in pushbutton_close_prog.
function pushbutton_close_prog_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close_prog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all; % Fermeture du programme au complet


% --- Executes on button press in pushbutton_Menuppal.
function pushbutton_Menuppal_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Menuppal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Menu_ppal % Retour au menu principal
close Performances_Modulations % Fermeture du programme 'Performances_Modulations'
